/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.pig;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.elasticsearch.hadoop.mr.EsInputFormat;
import org.elasticsearch.hadoop.mr.compat.CompatHandler;

public class EsPigInputFormat
extends EsInputFormat<String, Object> {
    @Override
    public AbstractPigShardRecordReader createRecordReader(InputSplit split, TaskAttemptContext context) {
        return this.isOutputAsJson(CompatHandler.taskAttemptContext(context).getConfiguration()) ? new PigJsonShardRecordReader() : new PigShardRecordReader();
    }

    @Override
    public AbstractPigShardRecordReader getRecordReader(org.apache.hadoop.mapred.InputSplit split, JobConf job, Reporter reporter) {
        return this.isOutputAsJson((Configuration)job) ? new PigJsonShardRecordReader(split, (Configuration)job, reporter) : new PigShardRecordReader(split, (Configuration)job, reporter);
    }

    protected static class PigJsonShardRecordReader
    extends AbstractPigShardRecordReader<String> {
        public PigJsonShardRecordReader() {
        }

        public PigJsonShardRecordReader(org.apache.hadoop.mapred.InputSplit split, Configuration job, Reporter reporter) {
            super(split, job, reporter);
        }

        @Override
        public String createValue() {
            return "";
        }

        @Override
        protected String setCurrentValue(String hadoopValue, Object object) {
            return object.toString();
        }
    }

    protected static class PigShardRecordReader
    extends AbstractPigShardRecordReader<Map> {
        public PigShardRecordReader() {
        }

        public PigShardRecordReader(org.apache.hadoop.mapred.InputSplit split, Configuration job, Reporter reporter) {
            super(split, job, reporter);
        }

        @Override
        public Map createValue() {
            return new LinkedHashMap();
        }

        @Override
        protected Map setCurrentValue(Map hadoopValue, Object object) {
            Map map = (Map)object;
            if (hadoopValue != null) {
                hadoopValue.clear();
                hadoopValue.putAll(map);
            }
            return hadoopValue;
        }
    }

    protected static abstract class AbstractPigShardRecordReader<V>
    extends EsInputFormat.ShardRecordReader<String, V> {
        public AbstractPigShardRecordReader() {
        }

        public AbstractPigShardRecordReader(org.apache.hadoop.mapred.InputSplit split, Configuration job, Reporter reporter) {
            super(split, job, reporter);
        }

        @Override
        public String createKey() {
            return "";
        }

        @Override
        protected String setCurrentKey(String hadoopKey, Object object) {
            return object.toString();
        }
    }
}

