/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.pig;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.LoadPushDown;
import org.apache.pig.ResourceSchema;
import org.apache.pig.data.DataType;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.cfg.PropertiesSettings;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.util.DateUtils;
import org.elasticsearch.hadoop.util.FieldAlias;
import org.elasticsearch.hadoop.util.SettingsUtils;
import org.elasticsearch.hadoop.util.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.ISODateTimeFormat;

class PigUtils {
    static final String MAPPING_NAMES = "es.mapping.names";
    static final String NAMED_TUPLE = "es.mapping.pig.tuple.use.field.names";
    static final boolean NAMED_TUPLE_DEFAULT = false;
    private static final boolean pig11Available = "datetime".equals(DataType.findTypeName((byte)30));

    PigUtils() {
    }

    static String convertDateToES(Object pigDate) {
        return pig11Available ? Pig11OrHigherConverter.convertToES(pigDate) : PigUpTo10Converter.convertToES(pigDate);
    }

    static Object convertDateFromES(String esDate) {
        return pig11Available ? Pig11OrHigherConverter.convertFromES(esDate) : PigUpTo10Converter.convertFromES(esDate);
    }

    static Object convertDateFromES(Long esDate) {
        return pig11Available ? Pig11OrHigherConverter.convertFromES(esDate) : PigUpTo10Converter.convertFromES(esDate);
    }

    static FieldAlias alias(Settings settings) {
        return new FieldAlias(SettingsUtils.aliases(settings.getProperty(MAPPING_NAMES), false), false);
    }

    static String asProjection(Schema schema2, Properties props) {
        ArrayList<String> fields = new ArrayList<String>();
        PigUtils.addField(schema2, fields, PigUtils.alias(new PropertiesSettings(props)), null);
        return StringUtils.concatenate(fields, ",");
    }

    private static void addField(Schema schema2, List<String> fields, FieldAlias fa, String currentNode) {
        for (Schema.FieldSchema field : schema2.getFields()) {
            String node;
            if (field.alias != null) {
                node = fa.toES(field.alias);
                node = currentNode != null ? currentNode + "." + node : node;
            } else {
                node = currentNode;
            }
            if (field.schema != null) {
                PigUtils.addField(field.schema, fields, fa, node);
                continue;
            }
            if (!StringUtils.hasText(node)) {
                LogFactory.getLog(PigUtils.class).warn((Object)("Cannot detect alias for field in schema" + schema2));
            }
            if (node == null) continue;
            fields.add(fa.toES(node));
        }
    }

    static String asProjection(LoadPushDown.RequiredFieldList list, Properties props) {
        ArrayList<String> fields = new ArrayList<String>();
        FieldAlias alias = PigUtils.alias(new PropertiesSettings(props));
        for (LoadPushDown.RequiredField field : list.getFields()) {
            PigUtils.addField(field, fields, alias, "");
        }
        return StringUtils.concatenateAndUriEncode(fields, ",");
    }

    private static void addField(LoadPushDown.RequiredField field, List<String> fields, FieldAlias fa, String currentNode) {
        if (field.getSubFields() != null && !field.getSubFields().isEmpty()) {
            for (LoadPushDown.RequiredField subField : field.getSubFields()) {
                PigUtils.addField(subField, fields, fa, currentNode + "." + fa.toES(subField.getAlias()));
            }
        } else {
            fields.add(fa.toES(field.getAlias()));
        }
    }

    static boolean isComplexType(ResourceSchema.ResourceFieldSchema fieldSchema) {
        return fieldSchema != null && fieldSchema.getType() >= 100;
    }

    private static abstract class Pig11OrHigherConverter {
        private Pig11OrHigherConverter() {
        }

        static String convertToES(Object pigDate) {
            DateTime dt = (DateTime)pigDate;
            return dt.toString();
        }

        static Object convertFromES(String esDate) {
            return ISODateTimeFormat.dateOptionalTimeParser().parseDateTime(esDate);
        }

        static Object convertFromES(Long esDate) {
            return new DateTime((Object)esDate, DateTimeZone.UTC);
        }
    }

    private static abstract class PigUpTo10Converter {
        private PigUpTo10Converter() {
        }

        static String convertToES(Object pigDate) {
            if (pigDate instanceof Number) {
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(((Number)pigDate).longValue());
                return DatatypeConverter.printDateTime((Calendar)cal);
            }
            if (pigDate instanceof String) {
                return (String)pigDate;
            }
            throw new EsHadoopIllegalArgumentException(String.format("Cannot convert [%s] to date", pigDate));
        }

        static Object convertFromES(String esDate) {
            return DateUtils.parseDate(esDate).getTimeInMillis();
        }

        static Object convertFromES(Long esDate) {
            return esDate;
        }
    }
}

