/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.yarn.cfg;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.elasticsearch.hadoop.yarn.util.Assert;
import org.elasticsearch.hadoop.yarn.util.PropertiesUtils;
import org.elasticsearch.hadoop.yarn.util.StringUtils;

public class Config {
    private static final String CLIENT_CFG = "cfg.properties";
    private final Properties cfg = new Properties(PropertiesUtils.load(Config.class, "cfg.properties"));

    public Config(Properties props) {
        PropertiesUtils.merge(this.cfg, props);
    }

    public String appType() {
        return this.cfg.getProperty("app.type");
    }

    public String appName() {
        return this.cfg.getProperty("app.name");
    }

    public int amPriority() {
        return Integer.parseInt(this.cfg.getProperty("app.priority"));
    }

    public String amQueue() {
        return this.cfg.getProperty("app.queue");
    }

    public int amMem() {
        return Integer.parseInt(this.cfg.getProperty("am.mem"));
    }

    public int amVCores() {
        return Integer.parseInt(this.cfg.getProperty("am.vcores"));
    }

    public Set<String> appTags() {
        return new LinkedHashSet<String>(StringUtils.tokenize(this.cfg.getProperty("app.tags")));
    }

    private String hdfsUploadDir() {
        String dir = this.cfg.getProperty("hdfs.upload.dir");
        return dir.endsWith("/") ? dir : dir + "/";
    }

    public String jarHdfsPath() {
        return this.hdfsUploadDir() + this.jarName();
    }

    public String jarName() {
        return this.cfg.getProperty("hdfs.es.yarn.jar");
    }

    public String esZipHdfsPath() {
        return this.hdfsUploadDir() + this.esZipName();
    }

    public String esZipName() {
        return "elasticsearch-" + this.downloadEsVersion() + ".zip";
    }

    public String esScript() {
        return "elasticsearch-" + this.downloadEsVersion() + "/bin/elasticsearch";
    }

    public int containerPriority() {
        return Integer.parseInt(this.cfg.getProperty("container.priority"));
    }

    public int containerMem() {
        return Integer.parseInt(this.cfg.getProperty("container.mem"));
    }

    public int containerVCores() {
        return Integer.parseInt(this.cfg.getProperty("container.vcores"));
    }

    public int containersToAllocate() {
        return Integer.parseInt(this.cfg.getProperty("containers"));
    }

    public URL downloadURL() {
        try {
            return new URL(this.cfg.getProperty("download.es.url") + this.esZipName());
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("Invalid URL", ex);
        }
    }

    public String downloadLocalDir() {
        return this.cfg.getProperty("download.local.dir");
    }

    public String downloadEsVersion() {
        return this.cfg.getProperty("es.version");
    }

    public File downloadedEs() {
        String dl = this.downloadLocalDir();
        if (!dl.endsWith("/")) {
            dl = dl + "/";
        }
        return new File(dl + this.esZipName());
    }

    public File downloadedEsYarn() {
        String jar = this.cfg.getProperty("internal.es.yarn.file");
        if (!StringUtils.hasText(jar)) {
            Class<?> clazz = this.getClass();
            ClassLoader loader = clazz.getClassLoader();
            String classFile = clazz.getName().replaceAll("\\.", "/") + ".class";
            try {
                Enumeration<URL> itr = loader.getResources(classFile);
                while (itr.hasMoreElements()) {
                    URL url = itr.nextElement();
                    if (!"jar".equals(url.getProtocol())) continue;
                    String toReturn = url.getPath();
                    if (toReturn.startsWith("file:")) {
                        toReturn = toReturn.substring("file:".length());
                    }
                    toReturn = URLDecoder.decode(toReturn, "UTF-8");
                    jar = toReturn.replaceAll("!.*$", "");
                }
            }
            catch (IOException ex) {
                throw new IllegalStateException("Cannot detect the Es-YARN jar", ex);
            }
        }
        Assert.hasText(jar, "Es-YARN.jar is not set and could not be detected...");
        return new File(jar);
    }

    public Map<String, String> envVars() {
        LinkedHashMap<String, String> env = new LinkedHashMap<String, String>();
        Set<String> keys = this.cfg.stringPropertyNames();
        String prefix = "env.";
        for (String key : keys) {
            if (!key.startsWith("env.")) continue;
            env.put(key.substring(prefix.length()), this.cfg.getProperty(key));
        }
        return env;
    }

    public Properties asProperties() {
        return PropertiesUtils.merge(null, this.cfg);
    }
}

