/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.yarn.cli;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.elasticsearch.hadoop.yarn.cfg.Config;
import org.elasticsearch.hadoop.yarn.client.ClientRpc;
import org.elasticsearch.hadoop.yarn.client.YarnLauncher;
import org.elasticsearch.hadoop.yarn.util.HttpDownloader;
import org.elasticsearch.hadoop.yarn.util.IOUtils;
import org.elasticsearch.hadoop.yarn.util.PropertiesUtils;

public class YarnBootstrap
extends Configured
implements Tool {
    private static String HELP = null;
    private Config cfg;

    public static void main(String[] args) throws Exception {
        int status = -1;
        try {
            status = ToolRunner.run((Tool)new YarnBootstrap(), (String[])args);
        }
        catch (Exception ex) {
            System.err.println("Abnormal execution:" + ex.getMessage());
            ex.printStackTrace(System.err);
        }
        System.exit(status);
    }

    private void displayHelp(String message) {
        if (message != null) {
            System.out.println(message);
        }
        if (HELP == null) {
            HELP = IOUtils.readFrom(((Object)((Object)this)).getClass().getResourceAsStream("help.txt"));
        }
        System.out.println(HELP);
    }

    public int run(String[] args) throws Exception {
        if (args == null || args.length < 1) {
            this.displayHelp("No command specified");
            return -1;
        }
        String cmd = args[0];
        this.cfg = new Config(PropertiesUtils.fromCmdLine(args, 1));
        if ("-download-es".equals(cmd)) {
            this.downloadEs();
        } else if ("-install".equals(cmd)) {
            this.installEsYarn();
        } else if ("-install-es".equals(cmd)) {
            this.installEs();
        } else if ("-help".equals(cmd)) {
            this.displayHelp(null);
        } else if ("-start".equals(cmd)) {
            this.start();
        } else if ("-status".equals(cmd)) {
            this.status();
        } else if ("-stop".equals(cmd)) {
            this.stop();
        } else {
            this.displayHelp("Unknown command specified " + cmd);
            return -1;
        }
        return 0;
    }

    private void downloadEs() {
        if (this.cfg.downloadedEs().exists()) {
            System.out.println(String.format("Destination file %s already exists; aborting download...", this.cfg.downloadedEs()));
            return;
        }
        System.out.println(String.format("Downloading Elasticsearch %s", this.cfg.downloadEsVersion()));
        new HttpDownloader().downloadES(this.cfg);
    }

    private void installEsYarn() {
        this.install(this.cfg.downloadedEsYarn(), this.cfg.jarHdfsPath(), this.getConf());
    }

    private void installEs() {
        this.install(this.cfg.downloadedEs(), this.cfg.esZipHdfsPath(), this.getConf());
    }

    private void install(File src, String dst, Configuration cfg) {
        Path target = new Path(dst);
        try {
            FileSystem fs = FileSystem.get((URI)URI.create("hdfs:///"), (Configuration)cfg);
            if (fs.exists(target)) {
                fs.delete(target, true);
            }
            FileUtil.copy((File)src, (FileSystem)fs, (Path)target, (boolean)false, (Configuration)cfg);
            FileStatus stats = fs.getFileStatus(target);
            System.out.println(String.format("Uploaded %s to HDFS at %s", src.getAbsolutePath(), stats.getPath()));
        }
        catch (IOException ex) {
            throw new IllegalStateException(String.format("Cannot upload %s in HDFS at %s", src.getAbsolutePath(), dst), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start() {
        ClientRpc client = new ClientRpc(this.getConf());
        ApplicationId id = null;
        ApplicationReport report = null;
        try {
            YarnLauncher launcher = new YarnLauncher(client, this.cfg);
            id = launcher.run();
            report = client.getReport(id);
        }
        finally {
            client.close();
        }
        System.out.println(String.format("Launched a %d %s Elasticsearch-YARN cluster [%s@%s] at %tc", this.cfg.containersToAllocate(), this.cfg.containersToAllocate() > 1 ? "nodes" : "node", id, report.getTrackingUrl(), report.getStartTime()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop() {
        ClientRpc client = new ClientRpc(this.getConf());
        client.start();
        try {
            List<ApplicationReport> esApps = client.listEsClustersAlive();
            for (ApplicationReport report : esApps) {
                System.out.println(String.format("Stopping Elasticsearch-YARN Cluster with id %s", report.getApplicationId()));
            }
            List<ApplicationReport> apps = client.killEsApps();
            for (ApplicationReport report : apps) {
                System.out.println(String.format("Stopped Elasticsearch-YARN cluster with id %s", report.getApplicationId()));
            }
        }
        finally {
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void status() {
        ClientRpc client = new ClientRpc(this.getConf());
        client.start();
        List<ApplicationReport> esApps = null;
        try {
            esApps = client.listEsClusters();
        }
        finally {
            client.close();
        }
        System.out.println(this.buildStatusReport(esApps));
    }

    private String buildStatusReport(List<ApplicationReport> esApps) {
        if (esApps.isEmpty()) {
            return String.format("No Elasticsearch YARN clusters found at %s, webapp at %s", this.getConf().get("yarn.resourcemanager.address"), WebAppUtils.getRMWebAppURLWithoutScheme((Configuration)this.getConf()));
        }
        String columnSeparator = "  ";
        StringBuilder sb = new StringBuilder();
        sb.append("Id                            ");
        sb.append(columnSeparator);
        sb.append("State     ");
        sb.append(columnSeparator);
        sb.append("Status   ");
        sb.append(columnSeparator);
        sb.append("Start Time       ");
        sb.append(columnSeparator);
        sb.append("Finish Time      ");
        sb.append(columnSeparator);
        sb.append("Tracking URL");
        sb.append("\n");
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);
        for (ApplicationReport appReport : esApps) {
            sb.append(appReport.getApplicationId());
            sb.append(columnSeparator);
            sb.append(this.box(appReport.getYarnApplicationState().toString(), 10));
            sb.append(columnSeparator);
            sb.append(this.box(appReport.getFinalApplicationStatus().toString(), 9));
            sb.append(columnSeparator);
            long date2 = appReport.getStartTime();
            sb.append(date2 == 0L ? "N/A              " : this.box(dateFormat.format(new Date(date2)), 17));
            sb.append(columnSeparator);
            date2 = appReport.getFinishTime();
            sb.append(date2 == 0L ? "N/A              " : this.box(dateFormat.format(new Date(date2)), 17));
            sb.append(columnSeparator);
            sb.append(appReport.getTrackingUrl());
            sb.append(columnSeparator);
            sb.append("\n");
        }
        return sb.toString();
    }

    private String box(String string, int limit) {
        StringBuilder sb = new StringBuilder(string);
        for (int i = sb.length(); i < limit; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }
}

