/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.yarn.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.client.api.YarnClientApplication;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Records;
import org.elasticsearch.hadoop.yarn.am.ApplicationMaster;
import org.elasticsearch.hadoop.yarn.cfg.Config;
import org.elasticsearch.hadoop.yarn.client.ClientRpc;
import org.elasticsearch.hadoop.yarn.compat.YarnCompat;
import org.elasticsearch.hadoop.yarn.util.PropertiesUtils;
import org.elasticsearch.hadoop.yarn.util.StringUtils;
import org.elasticsearch.hadoop.yarn.util.YarnUtils;

public class YarnLauncher {
    private static final Log log = LogFactory.getLog(YarnLauncher.class);
    private final ClientRpc client;
    private Config clientCfg;

    public YarnLauncher(ClientRpc client, Config cfg) {
        this.client = client;
        this.clientCfg = cfg;
    }

    public ApplicationId run() {
        this.client.start();
        YarnClientApplication app = this.client.newApp();
        ApplicationSubmissionContext am = this.setupAM(app);
        ApplicationId appId = this.client.submitApp(am);
        return am.getApplicationId();
    }

    private ApplicationSubmissionContext setupAM(YarnClientApplication clientApp) {
        ApplicationSubmissionContext appContext = clientApp.getApplicationSubmissionContext();
        appContext.setApplicationId(clientApp.getNewApplicationResponse().getApplicationId());
        appContext.setApplicationName(this.clientCfg.appName());
        appContext.setAMContainerSpec(this.createContainerContext());
        appContext.setResource(YarnCompat.resource(this.client.getConfiguration(), this.clientCfg.amMem(), this.clientCfg.amVCores()));
        appContext.setPriority(Priority.newInstance((int)this.clientCfg.amPriority()));
        appContext.setQueue(this.clientCfg.amQueue());
        appContext.setApplicationType(this.clientCfg.appType());
        YarnCompat.setApplicationTags(appContext, this.clientCfg.appTags());
        return appContext;
    }

    private ContainerLaunchContext createContainerContext() {
        ContainerLaunchContext amContainer = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
        amContainer.setLocalResources(this.setupEsYarnJar());
        amContainer.setEnvironment(this.setupEnv());
        amContainer.setCommands(this.setupCmd());
        return amContainer;
    }

    private Map<String, LocalResource> setupEsYarnJar() {
        FileStatus fsStat;
        LinkedHashMap<String, LocalResource> resources = new LinkedHashMap<String, LocalResource>();
        LocalResource esYarnJar = (LocalResource)Records.newRecord(LocalResource.class);
        Path p = new Path(this.clientCfg.jarHdfsPath());
        try {
            fsStat = FileSystem.get((Configuration)this.client.getConfiguration()).getFileStatus(p);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(String.format("Cannot find jar [%s]; make sure the artifacts have been properly provisioned and the correct permissions are in place.", this.clientCfg.jarHdfsPath()), ex);
        }
        esYarnJar.setResource(ConverterUtils.getYarnUrlFromPath((Path)fsStat.getPath()));
        esYarnJar.setSize(fsStat.getLen());
        esYarnJar.setTimestamp(fsStat.getModificationTime());
        esYarnJar.setType(LocalResourceType.FILE);
        esYarnJar.setVisibility(LocalResourceVisibility.PUBLIC);
        resources.put(this.clientCfg.jarName(), esYarnJar);
        return resources;
    }

    private Map<String, String> setupEnv() {
        Configuration cfg = this.client.getConfiguration();
        Map<String, String> env = YarnUtils.setupEnv(cfg);
        YarnUtils.addToEnv(env, "ES_YARN_CFG_PROPERTIES", PropertiesUtils.propsToBase64(this.clientCfg.asProperties()));
        YarnUtils.addToEnv(env, this.clientCfg.envVars());
        return env;
    }

    private List<String> setupCmd() {
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add(YarnCompat.$$(ApplicationConstants.Environment.JAVA_HOME) + "/bin/java");
        cmds.add(ApplicationMaster.class.getName());
        cmds.add("1><LOG_DIR>/stdout");
        cmds.add("2><LOG_DIR>/stderr");
        return Collections.singletonList(StringUtils.concatenate(cmds, " "));
    }
}

