/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.dto.mapping;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.cfg.FieldPresenceValidation;
import org.elasticsearch.hadoop.serialization.FieldType;
import org.elasticsearch.hadoop.serialization.dto.mapping.Field;
import org.elasticsearch.hadoop.serialization.field.FieldFilter;
import org.elasticsearch.hadoop.util.StringUtils;

public abstract class MappingUtils {
    private static final Set<String> BUILT_IN_FIELDS = new HashSet<String>();

    public static void validateMapping(String fields, Field mapping, FieldPresenceValidation validation, Log log) {
        if (StringUtils.hasText(fields)) {
            MappingUtils.validateMapping(StringUtils.tokenizeAndUriDecode(fields, ","), mapping, validation, log);
        }
    }

    public static void validateMapping(Collection<String> fields, Field mapping, FieldPresenceValidation validation, Log log) {
        if (mapping == null || fields == null || fields.isEmpty() || validation == null || FieldPresenceValidation.IGNORE == validation) {
            return;
        }
        List[] results = MappingUtils.findTypos(fields, mapping);
        if (results == null) {
            return;
        }
        String message = String.format("Field(s) [%s] not found in the Elasticsearch mapping specified; did you mean [%s]?", MappingUtils.removeDoubleBrackets(results[0]), MappingUtils.removeDoubleBrackets(results[1]));
        if (validation != FieldPresenceValidation.WARN) {
            throw new EsHadoopIllegalArgumentException(message);
        }
        log.warn((Object)message);
    }

    static List[] findTypos(Collection<String> fields, Field mapping) {
        Set<String> keys = Field.toLookupMap(mapping).keySet();
        ArrayList<String> missing = new ArrayList<String>(fields.size());
        for (String field : fields) {
            if (keys.contains(field) || MappingUtils.isBuiltIn(field)) continue;
            missing.add(field);
        }
        if (missing.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, String> unwrapped = new LinkedHashMap<String, String>();
        for (String key : keys) {
            String leafField;
            int match = key.lastIndexOf(".");
            if (match > 0 && !unwrapped.containsKey(leafField = key.substring(match + 1))) {
                unwrapped.put(leafField, key);
            }
            unwrapped.put(key, key);
        }
        ArrayList typos = new ArrayList();
        Set<String> similar = unwrapped.keySet();
        for (String string : missing) {
            List<String> matches = StringUtils.findSimiliar(string, similar);
            for (String match : matches) {
                typos.add(unwrapped.get(match));
            }
        }
        return new List[]{missing, typos};
    }

    private static boolean isBuiltIn(String field) {
        return BUILT_IN_FIELDS.contains(field);
    }

    private static String removeDoubleBrackets(List col) {
        if (col.isEmpty()) {
            return "<no-similar-match-found>";
        }
        if (col.size() == 1) {
            return col.get(0).toString();
        }
        return col.toString();
    }

    public static Field filter(Field field, Collection<String> includes, Collection<String> excludes) {
        ArrayList<Field> filtered = new ArrayList<Field>();
        for (Field fl : field.skipHeaders().properties()) {
            MappingUtils.processField(fl, null, filtered, includes, excludes);
        }
        return new Field(field.name(), field.type(), filtered);
    }

    private static void processField(Field field, String parentName, List<Field> filtered, Collection<String> includes, Collection<String> excludes) {
        String fieldName;
        String string = fieldName = parentName != null ? parentName + "." + field.name() : field.name();
        if (FieldFilter.filter(fieldName, includes, excludes)) {
            if (FieldType.OBJECT == field.type()) {
                ArrayList<Field> nested = new ArrayList<Field>();
                for (Field nestedField : field.properties()) {
                    MappingUtils.processField(nestedField, field.name(), nested, includes, excludes);
                }
                filtered.add(new Field(field.name(), field.type(), nested));
            } else {
                filtered.add(field);
            }
        }
    }

    static {
        BUILT_IN_FIELDS.addAll(Arrays.asList("_uid", "_id", "_type", "_source", "_all", "_analyzer", "_boost", "_parent", "_routing", "_index", "_size", "_timestamp", "_ttl"));
    }
}

