/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.cascading;

import cascading.scheme.SinkCall;
import cascading.tuple.Tuple;
import java.util.List;
import org.apache.hadoop.io.Writable;
import org.elasticsearch.hadoop.cascading.CascadingUtils;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.mr.WritableValueWriter;
import org.elasticsearch.hadoop.serialization.Generator;
import org.elasticsearch.hadoop.serialization.builder.FilteringValueWriter;
import org.elasticsearch.hadoop.serialization.builder.JdkValueWriter;
import org.elasticsearch.hadoop.serialization.builder.ValueWriter;

public class CascadingValueWriter
extends FilteringValueWriter<SinkCall<Object[], ?>> {
    private final JdkValueWriter jdkWriter;
    private final WritableValueWriter writableWriter;

    public CascadingValueWriter() {
        this(false);
    }

    public CascadingValueWriter(boolean writeUnknownTypes) {
        this.jdkWriter = new JdkValueWriter(writeUnknownTypes);
        this.writableWriter = new WritableValueWriter(writeUnknownTypes);
    }

    @Override
    public ValueWriter.Result write(SinkCall<Object[], ?> sinkCall, Generator generator) {
        Tuple tuple = CascadingUtils.coerceToString(sinkCall);
        List names = (List)((Object[])sinkCall.getContext())[0];
        generator.writeBeginObject();
        for (int i = 0; i < tuple.size(); ++i) {
            String name;
            String string = name = i < names.size() ? (String)names.get(i) : "tuple" + i;
            if (!this.shouldKeep(generator.getParentPath(), name)) continue;
            generator.writeFieldName(name);
            Object object = tuple.getObject(i);
            ValueWriter.Result result = this.jdkWriter.write(object, generator);
            if (result.isSuccesful()) continue;
            if (object instanceof Writable) {
                return this.writableWriter.write((Writable)object, generator);
            }
            return ValueWriter.Result.FAILED(object);
        }
        generator.writeEndObject();
        return ValueWriter.Result.SUCCESFUL();
    }

    @Override
    public void setSettings(Settings settings) {
        super.setSettings(settings);
        this.jdkWriter.setSettings(settings);
        this.writableWriter.setSettings(settings);
    }
}

