/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.spark.sql;

import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.elasticsearch.hadoop.cfg.PropertiesSettings;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.rest.InitializationUtils;
import org.elasticsearch.hadoop.util.ObjectUtils;
import org.elasticsearch.spark.cfg.SparkSettings;
import org.elasticsearch.spark.cfg.SparkSettingsManager;
import org.elasticsearch.spark.sql.EsDataFrameWriter;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.generic.Growable;
import scala.collection.mutable.MapLike;
import scala.reflect.ClassTag$;

public final class EsSparkSQL$ {
    public static final EsSparkSQL$ MODULE$;
    private final Class<?> init;

    static {
        new EsSparkSQL$();
    }

    private Class<?> init() {
        return this.init;
    }

    public DataFrame esDF(SQLContext sc) {
        return this.esDF(sc, (Map<String, String>)Map$.MODULE$.empty());
    }

    public DataFrame esDF(SQLContext sc, String resource) {
        return this.esDF(sc, (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"es.resource.read"), (Object)resource)}))));
    }

    public DataFrame esDF(SQLContext sc, String resource, String query) {
        return this.esDF(sc, (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"es.resource.read"), (Object)resource), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"es.query"), (Object)query)}))));
    }

    public DataFrame esDF(SQLContext sc, Map<String, String> cfg) {
        Settings esConf = new SparkSettingsManager().load(sc.sparkContext().getConf()).copy();
        esConf.merge((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(cfg).asJava());
        return sc.load("org.elasticsearch.spark.sql", ((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(esConf.asProperties()).asScala()).toMap(Predef$.MODULE$.conforms()));
    }

    public DataFrame esDF(SQLContext sc, String resource, String query, Map<String, String> cfg) {
        return this.esDF(sc, (Map<String, String>)((Map)((Growable)scala.collection.mutable.Map$.MODULE$.apply(cfg.toSeq())).$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"es.resource.read"), (Object)resource), (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"es.query"), (Object)query), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]))));
    }

    public DataFrame esDF(SQLContext sc, String resource, Map<String, String> cfg) {
        return this.esDF(sc, (Map<String, String>)((Map)((MapLike)scala.collection.mutable.Map$.MODULE$.apply(cfg.toSeq())).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"es.resource.read"), (Object)resource))));
    }

    public void saveToEs(DataFrame srdd, String resource) {
        this.saveToEs(srdd, (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"es.resource.write"), (Object)resource)}))));
    }

    public void saveToEs(DataFrame srdd, String resource, Map<String, String> cfg) {
        this.saveToEs(srdd, (Map<String, String>)((Map)((MapLike)scala.collection.mutable.Map$.MODULE$.apply(cfg.toSeq())).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"es.resource.write"), (Object)resource))));
    }

    public void saveToEs(DataFrame srdd, Map<String, String> cfg) {
        if (srdd == null) {
            return;
        }
        SparkContext sparkCtx = srdd.sqlContext().sparkContext();
        SparkSettings sparkCfg = new SparkSettingsManager().load(sparkCtx.getConf());
        Settings esCfg = new PropertiesSettings().load(sparkCfg.save());
        esCfg.merge((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(cfg).asJava());
        InitializationUtils.checkIdForOperation(esCfg);
        InitializationUtils.checkIndexExistence(esCfg, null);
        EsDataFrameWriter esDataFrameWriter = new EsDataFrameWriter(srdd.schema(), esCfg.save());
        sparkCtx.runJob(srdd.rdd(), (Function2)new Serializable(esDataFrameWriter){
            public static final long serialVersionUID = 0L;
            private final EsDataFrameWriter eta$0$1$1;

            public final void apply(TaskContext taskContext, Iterator<Row> data) {
                this.eta$0$1$1.write(taskContext, data);
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
            }
        }, ClassTag$.MODULE$.Unit());
    }

    private EsSparkSQL$() {
        MODULE$ = this;
        this.init = ObjectUtils.loadClass("org.elasticsearch.spark.rdd.CompatUtils", ObjectUtils.class.getClassLoader());
    }
}

