/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest;

import org.elasticsearch.hadoop.rest.Request;
import org.elasticsearch.hadoop.util.ByteSequence;
import org.elasticsearch.hadoop.util.StringUtils;

public class SimpleRequest
implements Request {
    private final Request.Method method;
    private final CharSequence uri;
    private final CharSequence path;
    private final CharSequence params;
    private final ByteSequence body;

    public SimpleRequest(Request.Method method, CharSequence uri, CharSequence path) {
        this(method, uri, path, null, null);
    }

    public SimpleRequest(Request.Method method, CharSequence uri, CharSequence path, CharSequence params2) {
        this(method, uri, path, params2, null);
    }

    public SimpleRequest(Request.Method method, CharSequence uri, CharSequence path, ByteSequence body) {
        this(method, uri, path, null, body);
    }

    public SimpleRequest(Request.Method method, CharSequence uri, CharSequence path, CharSequence params2, ByteSequence body) {
        this.method = method;
        this.uri = uri;
        int queryMark = String.valueOf(path).indexOf(63);
        if (StringUtils.hasText(params2) && queryMark >= 0) {
            throw new IllegalArgumentException("Found Request with Query in Path, as well as specified within the params option.");
        }
        if (queryMark >= 0) {
            this.path = path.subSequence(0, queryMark);
            this.params = path.subSequence(queryMark + 1, path.length());
        } else {
            this.path = path;
            this.params = params2;
        }
        this.body = body;
    }

    @Override
    public Request.Method method() {
        return this.method;
    }

    @Override
    public CharSequence uri() {
        return this.uri;
    }

    @Override
    public CharSequence path() {
        return this.path;
    }

    @Override
    public CharSequence params() {
        return this.params;
    }

    @Override
    public ByteSequence body() {
        return this.body;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.method.name());
        sb.append("@");
        sb.append(this.uri);
        sb.append("/");
        sb.append(this.path);
        if (this.params != null) {
            sb.append("?");
            sb.append(this.params);
        }
        return sb.toString();
    }
}

