/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest;

import java.util.List;
import java.util.Map;
import org.elasticsearch.hadoop.rest.ErrorUtils;
import org.elasticsearch.hadoop.util.ByteSequence;
import org.elasticsearch.hadoop.util.EsMajorVersion;

public class ErrorExtractor {
    private final EsMajorVersion internalVersion;

    public ErrorExtractor(EsMajorVersion internalVersion) {
        this.internalVersion = internalVersion;
    }

    public String extractError(Map jsonMap) {
        Object err = jsonMap.get("error");
        String error = "";
        if (err != null) {
            Map nestedM;
            Object nested;
            Map m;
            error = err instanceof Map ? ((err = (m = (Map)err).get("root_cause")) == null ? (m.containsKey("reason") ? m.get("reason").toString() : (m.containsKey("caused_by") ? error + ";" + ((Map)m.get("caused_by")).get("reason") : m.toString())) : (err instanceof List ? ((nested = ((List)err).get(0)) instanceof Map ? ((nestedM = (Map)nested).containsKey("reason") ? nestedM.get("reason").toString() : nested.toString()) : nested.toString()) : err.toString())) : err.toString();
        }
        return error;
    }

    public String prettify(String error) {
        if (this.internalVersion.onOrAfter(EsMajorVersion.V_2_X)) {
            return error;
        }
        String invalidFragment = ErrorUtils.extractInvalidXContent(error);
        String header = invalidFragment != null ? "Invalid JSON fragment received[" + invalidFragment + "]" : "";
        return header + "[" + error + "]";
    }

    public String prettify(String error, ByteSequence body) {
        if (this.internalVersion.onOrAfter(EsMajorVersion.V_2_X)) {
            return error;
        }
        String message = ErrorUtils.extractJsonParse(error, body);
        return message != null ? error + "; fragment[" + message + "]" : error;
    }
}

