/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest.bulk;

import java.util.Collections;
import java.util.List;
import org.elasticsearch.hadoop.util.BytesArray;

public class BulkResponse {
    private final BulkStatus status;
    private final int httpStatus;
    private final long spent;
    private final int totalDocs;
    private final int docsSent;
    private final int docsSkipped;
    private final int docsAborted;
    private List<BulkError> documentErrors;

    public static BulkResponse complete() {
        return BulkResponse.complete(200, 0L, 0, 0, 0);
    }

    public static BulkResponse complete(int httpStatus, long spent, int totalWrites, int docsSent, int docsSkipped) {
        return new BulkResponse(BulkStatus.COMPLETE, httpStatus, spent, totalWrites, docsSent, docsSkipped, 0, Collections.<BulkError>emptyList());
    }

    public static BulkResponse partial(int httpStatus, long spent, int totalWrites, int docsSent, int docsSkipped, int docsAborted, List<BulkError> errors) {
        return new BulkResponse(BulkStatus.PARTIAL, httpStatus, spent, totalWrites, docsSent, docsSkipped, docsAborted, errors);
    }

    private BulkResponse(BulkStatus status, int httpStatus, long spent, int totalDocs, int docsSent, int docsSkipped, int docsAborted, List<BulkError> documentErrors) {
        this.status = status;
        this.httpStatus = httpStatus;
        this.spent = spent;
        this.totalDocs = totalDocs;
        this.docsSent = docsSent;
        this.docsSkipped = docsSkipped;
        this.docsAborted = docsAborted;
        this.documentErrors = documentErrors;
    }

    public BulkStatus getStatus() {
        return this.status;
    }

    public int getHttpStatus() {
        return this.httpStatus;
    }

    public long getClientTimeSpent() {
        return this.spent;
    }

    public int getTotalDocs() {
        return this.totalDocs;
    }

    public long getSpent() {
        return this.spent;
    }

    public int getDocsSent() {
        return this.docsSent;
    }

    public int getDocsSkipped() {
        return this.docsSkipped;
    }

    public int getDocsAborted() {
        return this.docsAborted;
    }

    public List<BulkError> getDocumentErrors() {
        return this.documentErrors;
    }

    public static class BulkError {
        private final int originalPosition;
        private final BytesArray document;
        private final int documentStatus;
        private final String errorMessage;

        public BulkError(int originalPosition, BytesArray document, int documentStatus, String errorMessage) {
            this.originalPosition = originalPosition;
            this.document = document;
            this.documentStatus = documentStatus;
            this.errorMessage = errorMessage;
        }

        public int getOriginalPosition() {
            return this.originalPosition;
        }

        public BytesArray getDocument() {
            return this.document;
        }

        public int getDocumentStatus() {
            return this.documentStatus;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }
    }

    public static enum BulkStatus {
        COMPLETE,
        PARTIAL;

    }
}

