/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.field;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.io.Text;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.serialization.field.ConstantFieldExtractor;
import org.elasticsearch.hadoop.serialization.field.FieldExplainer;

public class MapWritableFieldExtractor
extends ConstantFieldExtractor
implements FieldExplainer {
    private List<Text> fieldNames;

    @Override
    protected Object extractField(Object target) {
        for (int i = 0; i < this.fieldNames.size(); ++i) {
            Map map;
            if (target instanceof Map) {
                map = (Map)target;
                if (!map.containsKey(this.fieldNames.get(i))) {
                    return NOT_FOUND;
                }
            } else {
                return NOT_FOUND;
            }
            target = map.get(this.fieldNames.get(i));
        }
        return target;
    }

    @Override
    protected void processField(Settings settings, List<String> fldNames) {
        this.fieldNames = new ArrayList<Text>(fldNames.size());
        for (String string : fldNames) {
            this.fieldNames.add(new Text(string));
        }
    }

    @Override
    public String toString(Object field) {
        if (field instanceof Map) {
            return new LinkedHashMap((Map)field).toString();
        }
        return field.toString();
    }
}

