/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest.query;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.rest.query.QueryBuilder;
import org.elasticsearch.hadoop.serialization.Generator;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.JsonParser;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.map.ObjectMapper;

public class RawQueryBuilder
extends QueryBuilder {
    private static final ObjectMapper MAPPER = new ObjectMapper().configure(JsonParser.Feature.ALLOW_COMMENTS, true);
    private final String queryString;

    public RawQueryBuilder(String value, boolean isQuery) throws IOException {
        this(MAPPER.readValue(value, HashMap.class), isQuery);
    }

    public RawQueryBuilder(Map<String, Object> map, boolean isQuery) throws IOException {
        Object query = map;
        if (isQuery && map.containsKey("query")) {
            query = map.remove("query");
        }
        String raw = MAPPER.writeValueAsString(query);
        int begin = raw.indexOf(123);
        int end = raw.lastIndexOf(125);
        if (begin == -1 || end == -1) {
            throw new EsHadoopIllegalArgumentException("failed to parse query: " + raw);
        }
        this.queryString = raw.substring(begin + 1, end);
    }

    @Override
    public void toJson(Generator out) {
        out.writeRaw(this.queryString);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RawQueryBuilder that = (RawQueryBuilder)o;
        return this.queryString != null ? this.queryString.equals(that.queryString) : that.queryString == null;
    }

    public int hashCode() {
        return this.queryString.hashCode();
    }
}

