/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.hive;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.NullWritable;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.hive.HiveType;
import org.elasticsearch.hadoop.hive.HiveUtils;
import org.elasticsearch.hadoop.serialization.field.ConstantFieldExtractor;
import org.elasticsearch.hadoop.serialization.field.FieldExtractor;
import org.elasticsearch.hadoop.util.Assert;

public class HiveFieldExtractor
extends ConstantFieldExtractor {
    protected List<String> fieldNames;

    @Override
    protected Object extractField(Object target) {
        List<String> flNames = this.fieldNames;
        for (int i = 0; i < flNames.size(); ++i) {
            ObjectInspector inspector;
            HiveType type;
            String fl = flNames.get(i);
            if (target instanceof HiveType) {
                type = (HiveType)target;
                inspector = type.getObjectInspector();
                if (!(inspector instanceof StructObjectInspector)) {
                    return FieldExtractor.NOT_FOUND;
                }
            } else {
                return FieldExtractor.NOT_FOUND;
            }
            StructObjectInspector soi = (StructObjectInspector)inspector;
            StructField field = soi.getStructFieldRef(fl);
            ObjectInspector foi = field.getFieldObjectInspector();
            Assert.isTrue(foi.getCategory() == ObjectInspector.Category.PRIMITIVE, String.format("Field [%s] needs to be a primitive; found [%s]", fl, foi.getTypeName()));
            target = soi.getStructFieldData(type.getObject(), field);
        }
        if (target == null || target instanceof NullWritable) {
            return "";
        }
        return target.toString();
    }

    @Override
    public void processField(Settings settings, List<String> fl) {
        Map<String, String> columnNames = HiveUtils.columnMap(settings);
        this.fieldNames = new ArrayList<String>(fl.size());
        for (String string : fl) {
            this.fieldNames.add(columnNames.get(string.toLowerCase(Locale.ROOT)));
        }
        if (!settings.getInputAsJson() && fl.isEmpty()) {
            throw new EsHadoopIllegalArgumentException(String.format("Cannot find field [%s] in mapping %s ; maybe a value was specified without '<','>' or there is a typo?", fl, columnNames.keySet()));
        }
    }
}

