/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.mr;

import java.lang.reflect.Constructor;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Writable;
import org.elasticsearch.hadoop.EsHadoopIllegalStateException;

public abstract class WritableCompatUtil {
    private static final Class<Writable> SHORT_WRITABLE;
    private static final Constructor<Writable> SHORT_CTOR;

    public static Class<? extends Writable> availableShortType() {
        return SHORT_WRITABLE != null ? SHORT_WRITABLE : IntWritable.class;
    }

    public static Writable availableShortWritable(short value) {
        if (SHORT_CTOR != null) {
            try {
                return SHORT_CTOR.newInstance(value);
            }
            catch (Exception e) {
                throw new EsHadoopIllegalStateException(e);
            }
        }
        return new IntWritable((int)value);
    }

    public static short unwrap(Writable writable) {
        return Short.parseShort(writable.toString());
    }

    public static boolean isShortWritable(Writable writable) {
        return SHORT_WRITABLE != null && writable != null && SHORT_WRITABLE.isInstance(writable);
    }

    static {
        Class<?> clazz = null;
        Constructor<?> ctor = null;
        try {
            clazz = Class.forName("org.apache.hadoop.io.ShortWritable", false, IntWritable.class.getClassLoader());
            ctor = clazz.getConstructor(Short.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        SHORT_WRITABLE = clazz;
        SHORT_CTOR = ctor;
    }
}

