/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.spark.cfg;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.spark.SparkConf;
import org.apache.spark.package$;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.IOUtils;
import org.elasticsearch.hadoop.util.Version;
import scala.Option;
import scala.Tuple2;

public class SparkSettings
extends Settings {
    private final SparkConf cfg;

    public SparkSettings(SparkConf cfg) {
        String user;
        Assert.notNull(cfg, "non-null spark configuration expected");
        this.cfg = cfg;
        try {
            user = System.getenv("SPARK_USER") == null ? UserGroupInformation.getCurrentUser().getShortUserName() : System.getenv("SPARK_USER");
        }
        catch (IOException e) {
            user = "";
        }
        String appName = cfg.get("app.name", cfg.get("spark.app.name", ""));
        String appId = cfg.get("spark.app.id", "");
        String opaqueId = String.format(Locale.ROOT, "[spark] [%s] [%s] [%s]", user, appName, appId);
        this.setOpaqueId(opaqueId);
        this.setUserAgent(String.format(Locale.ROOT, "elasticsearch-hadoop/%s spark/%s", Version.versionNumber(), package$.MODULE$.SPARK_VERSION()));
    }

    @Override
    public InputStream loadResource(String location) {
        return IOUtils.open(location);
    }

    @Override
    public Settings copy() {
        return new SparkSettings(this.cfg.clone());
    }

    @Override
    public String getProperty(String name) {
        Option op = this.cfg.getOption(name);
        if (!op.isDefined()) {
            op = this.cfg.getOption("spark." + name);
        }
        return op.isDefined() ? (String)op.get() : null;
    }

    @Override
    public void setProperty(String name, String value) {
        this.cfg.set(name, value);
    }

    @Override
    public Properties asProperties() {
        Properties props = new Properties();
        if (this.cfg != null) {
            String sparkPrefix = "spark.";
            for (Tuple2 tuple : this.cfg.getAll()) {
                String simpleKey;
                String key = (String)tuple._1;
                props.setProperty(key, (String)tuple._2);
                if (!key.startsWith(sparkPrefix) || props.containsKey(simpleKey = key.substring(sparkPrefix.length()))) continue;
                props.setProperty(simpleKey, (String)tuple._2);
            }
        }
        return props;
    }
}

