/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.storm.security;

import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.security.EsToken;
import org.elasticsearch.hadoop.security.UserProvider;
import org.elasticsearch.hadoop.util.ClusterInfo;
import org.elasticsearch.hadoop.util.ClusterName;

public class EsClusterInfoSelector {
    private static final Log LOG = LogFactory.getLog(EsClusterInfoSelector.class);

    public static void populate(Settings settings) {
        Iterator<EsToken> iterator;
        Iterable<EsToken> esTokens = UserProvider.create(settings).getUser().getAllEsTokens();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Found list of tokens on worker: " + esTokens));
        }
        if ((iterator = esTokens.iterator()).hasNext()) {
            EsToken esToken = iterator.next();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Using token: " + esToken));
            }
            ClusterInfo clusterInfo = new ClusterInfo(new ClusterName(esToken.getClusterName(), null), esToken.getMajorVersion());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Using clusterInfo : " + clusterInfo));
            }
            settings.setInternalClusterInfo(clusterInfo);
        } else {
            LOG.debug((Object)"Could not locate any tokens");
        }
    }
}

