/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest;

import java.util.List;
import java.util.Map;
import org.elasticsearch.hadoop.EsHadoopException;
import org.elasticsearch.hadoop.rest.ErrorUtils;
import org.elasticsearch.hadoop.rest.EsHadoopRemoteException;
import org.elasticsearch.hadoop.util.ByteSequence;
import org.elasticsearch.hadoop.util.EsMajorVersion;

public class ErrorExtractor {
    private final EsMajorVersion internalVersion;

    public ErrorExtractor(EsMajorVersion internalVersion) {
        this.internalVersion = internalVersion;
    }

    public EsHadoopException extractErrorWithCause(Map m) {
        Object type = m.get("type");
        Object reason = m.get("reason");
        Object causedBy = m.get("caused_by");
        EsHadoopException ex = null;
        if (reason != null) {
            ex = type != null ? new EsHadoopRemoteException(type.toString(), reason.toString()) : new EsHadoopRemoteException(reason.toString());
        }
        if (causedBy != null) {
            if (ex == null) {
                ex = this.extractErrorWithCause((Map)causedBy);
            } else {
                ex.initCause(this.extractErrorWithCause((Map)causedBy));
            }
        }
        if (ex == null) {
            ex = new EsHadoopRemoteException(m.toString());
        }
        return ex;
    }

    public EsHadoopException extractError(Map jsonMap) {
        Object err = jsonMap.get("error");
        EsHadoopException error = null;
        if (err != null) {
            Map nestedM;
            Object nested;
            Map m;
            error = err instanceof Map ? ((err = (m = (Map)err).get("root_cause")) == null ? this.extractErrorWithCause(m) : (err instanceof List ? ((nested = ((List)err).get(0)) instanceof Map ? ((nestedM = (Map)nested).containsKey("reason") ? this.extractErrorWithCause(nestedM) : new EsHadoopRemoteException(nested.toString())) : new EsHadoopRemoteException(nested.toString())) : new EsHadoopRemoteException(err.toString()))) : new EsHadoopRemoteException(err.toString());
        }
        return error;
    }

    public String prettify(String error) {
        if (this.internalVersion.onOrAfter(EsMajorVersion.V_2_X)) {
            return error;
        }
        String invalidFragment = ErrorUtils.extractInvalidXContent(error);
        String header = invalidFragment != null ? "Invalid JSON fragment received[" + invalidFragment + "]" : "";
        return header + "[" + error + "]";
    }

    public String prettify(String error, ByteSequence body) {
        if (this.internalVersion.onOrAfter(EsMajorVersion.V_2_X)) {
            return error;
        }
        String message = ErrorUtils.extractJsonParse(error, body);
        return message != null ? error + "; fragment[" + message + "]" : error;
    }
}

