/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.vec.internal;

import java.io.IOException;
import java.lang.foreign.MemorySegment;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.quantization.ScalarQuantizedVectorSimilarity;
import org.elasticsearch.vec.internal.AbstractScalarQuantizedVectorScorer;

public final class MaximumInnerProduct
extends AbstractScalarQuantizedVectorScorer {
    public MaximumInnerProduct(int dims, int maxOrd, float scoreCorrectionConstant, IndexInput input) {
        super(dims, maxOrd, scoreCorrectionConstant, input, ScalarQuantizedVectorSimilarity.fromVectorSimilarity((VectorSimilarityFunction)VectorSimilarityFunction.MAXIMUM_INNER_PRODUCT, (float)scoreCorrectionConstant));
    }

    @Override
    public float score(int firstOrd, int secondOrd) throws IOException {
        this.checkOrdinal(firstOrd);
        this.checkOrdinal(secondOrd);
        int length = this.dims;
        long firstByteOffset = (long)firstOrd * (long)(length + 4);
        long secondByteOffset = (long)secondOrd * (long)(length + 4);
        MemorySegment firstSeg = this.segmentSlice(firstByteOffset, length);
        this.input.seek(firstByteOffset + (long)length);
        float firstOffset = Float.intBitsToFloat(this.input.readInt());
        MemorySegment secondSeg = this.segmentSlice(secondByteOffset, length);
        this.input.seek(secondByteOffset + (long)length);
        float secondOffset = Float.intBitsToFloat(this.input.readInt());
        if (firstSeg != null && secondSeg != null) {
            int dotProduct = MaximumInnerProduct.dotProduct(firstSeg, secondSeg, length);
            float adjustedDistance = (float)dotProduct * this.scoreCorrectionConstant + firstOffset + secondOffset;
            return MaximumInnerProduct.scaleMaxInnerProductScore(adjustedDistance);
        }
        return this.fallbackScore(firstByteOffset, secondByteOffset);
    }

    static float scaleMaxInnerProductScore(float rawSimilarity) {
        if (rawSimilarity < 0.0f) {
            return 1.0f / (1.0f + -1.0f * rawSimilarity);
        }
        return rawSimilarity + 1.0f;
    }

    @Override
    public MaximumInnerProduct copy() {
        return new MaximumInnerProduct(this.dims, this.maxOrd, this.scoreCorrectionConstant, this.input.clone());
    }
}

