/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.elasticsearch.Version;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.TermBasedFieldType;
import org.elasticsearch.index.query.QueryShardContext;

public class MockFieldMapper
extends FieldMapper {
    static Settings dummySettings = Settings.builder().put("index.version.created", Version.CURRENT.id).build();

    public MockFieldMapper(String fullName) {
        this(fullName, (MappedFieldType)new FakeFieldType());
    }

    public MockFieldMapper(String fullName, MappedFieldType fieldType) {
        super(MockFieldMapper.findSimpleName(fullName), MockFieldMapper.setName(fullName, fieldType), MockFieldMapper.setName(fullName, fieldType), dummySettings, FieldMapper.MultiFields.empty(), new FieldMapper.CopyTo.Builder().build());
    }

    static MappedFieldType setName(String fullName, MappedFieldType fieldType) {
        fieldType.setName(fullName);
        return fieldType;
    }

    static String findSimpleName(String fullName) {
        int ndx = fullName.lastIndexOf(46);
        return fullName.substring(ndx + 1);
    }

    protected String contentType() {
        return null;
    }

    protected void parseCreateField(ParseContext context, List list) throws IOException {
    }

    public static class FakeFieldType
    extends TermBasedFieldType {
        public FakeFieldType() {
        }

        protected FakeFieldType(FakeFieldType ref) {
            super((MappedFieldType)ref);
        }

        public MappedFieldType clone() {
            return new FakeFieldType(this);
        }

        public String typeName() {
            return "faketype";
        }

        public Query existsQuery(QueryShardContext context) {
            if (this.hasDocValues()) {
                return new DocValuesFieldExistsQuery(this.name());
            }
            return new TermQuery(new Term("_field_names", this.name()));
        }
    }
}

