/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.transport;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.apache.lucene.util.LuceneTestCase;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterModule;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.component.LifecycleListener;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.test.transport.StubbableConnectionManager;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.CloseableConnection;
import org.elasticsearch.transport.ConnectionManager;
import org.elasticsearch.transport.ConnectionProfile;
import org.elasticsearch.transport.RemoteTransportException;
import org.elasticsearch.transport.RequestHandlerRegistry;
import org.elasticsearch.transport.SendRequestTransportException;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportInterceptor;
import org.elasticsearch.transport.TransportMessageListener;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.TransportStats;

public class MockTransport
implements Transport,
LifecycleComponent {
    private volatile Map<String, RequestHandlerRegistry> requestHandlers = Collections.emptyMap();
    private final Object requestHandlerMutex = new Object();
    private final Transport.ResponseHandlers responseHandlers = new Transport.ResponseHandlers();
    private TransportMessageListener listener;
    private ConcurrentMap<Long, Tuple<DiscoveryNode, String>> requests = new ConcurrentHashMap<Long, Tuple<DiscoveryNode, String>>();

    public TransportService createTransportService(Settings settings, ThreadPool threadPool, TransportInterceptor interceptor, Function<BoundTransportAddress, DiscoveryNode> localNodeFactory, @Nullable ClusterSettings clusterSettings, Set<String> taskHeaders) {
        StubbableConnectionManager connectionManager = new StubbableConnectionManager(new ConnectionManager(settings, (Transport)this), settings, this, threadPool);
        connectionManager.setDefaultNodeConnectedBehavior((cm, discoveryNode) -> this.nodeConnected(discoveryNode));
        connectionManager.setDefaultGetConnectionBehavior((cm, discoveryNode) -> this.createConnection(discoveryNode));
        return new TransportService(settings, (Transport)this, threadPool, interceptor, localNodeFactory, clusterSettings, taskHeaders, (ConnectionManager)connectionManager);
    }

    public <Response extends TransportResponse> void handleResponse(long requestId, Response response) {
        TransportResponseHandler transportResponseHandler = this.responseHandlers.onResponseReceived(requestId, this.listener);
        if (transportResponseHandler != null) {
            TransportResponse deliveredResponse;
            try (BytesStreamOutput output = new BytesStreamOutput();){
                response.writeTo((StreamOutput)output);
                deliveredResponse = (TransportResponse)transportResponseHandler.read((StreamInput)new NamedWriteableAwareStreamInput(output.bytes().streamInput(), this.writeableRegistry()));
            }
            catch (IOException | UnsupportedOperationException e) {
                throw new AssertionError("failed to serialize/deserialize response " + response, e);
            }
            transportResponseHandler.handleResponse(deliveredResponse);
        }
    }

    public void handleLocalError(long requestId, Throwable t) {
        Tuple request = (Tuple)this.requests.get(requestId);
        assert (request != null);
        this.handleError(requestId, (TransportException)new SendRequestTransportException((DiscoveryNode)request.v1(), (String)request.v2(), t));
    }

    public void handleRemoteError(long requestId, Throwable t) {
        RemoteTransportException remoteException;
        if (LuceneTestCase.rarely((Random)Randomness.get())) {
            remoteException = new RemoteTransportException("remote failure, coming from local node", t);
        } else {
            try (BytesStreamOutput output = new BytesStreamOutput();){
                output.writeException(t);
                remoteException = new RemoteTransportException("remote failure", (Throwable)output.bytes().streamInput().readException());
            }
            catch (IOException ioException) {
                throw new AssertionError("failed to serialize/deserialize supplied exception " + t, ioException);
            }
        }
        this.handleError(requestId, (TransportException)remoteException);
    }

    public void handleError(long requestId, TransportException e) {
        TransportResponseHandler transportResponseHandler = this.responseHandlers.onResponseReceived(requestId, this.listener);
        if (transportResponseHandler != null) {
            transportResponseHandler.handleException(e);
        }
    }

    public Releasable openConnection(DiscoveryNode node, ConnectionProfile profile, ActionListener<Transport.Connection> listener) {
        listener.onResponse((Object)this.createConnection(node));
        return () -> {};
    }

    public Transport.Connection createConnection(final DiscoveryNode node) {
        return new CloseableConnection(){

            public DiscoveryNode getNode() {
                return node;
            }

            public void sendRequest(long requestId, String action, TransportRequest request, TransportRequestOptions options) throws TransportException {
                MockTransport.this.requests.put(requestId, Tuple.tuple((Object)node, (Object)action));
                MockTransport.this.onSendRequest(requestId, action, request, node);
            }
        };
    }

    protected void onSendRequest(long requestId, String action, TransportRequest request, DiscoveryNode node) {
    }

    protected boolean nodeConnected(DiscoveryNode discoveryNode) {
        return true;
    }

    public TransportStats getStats() {
        throw new UnsupportedOperationException();
    }

    public BoundTransportAddress boundAddress() {
        return null;
    }

    public Map<String, BoundTransportAddress> profileBoundAddresses() {
        return null;
    }

    public TransportAddress[] addressesFromString(String address, int perAddressLimit) {
        return new TransportAddress[0];
    }

    public Lifecycle.State lifecycleState() {
        return null;
    }

    public void addLifecycleListener(LifecycleListener listener) {
    }

    public void removeLifecycleListener(LifecycleListener listener) {
    }

    public void start() {
    }

    public void stop() {
    }

    public void close() {
    }

    public List<String> getLocalAddresses() {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <Request extends TransportRequest> void registerRequestHandler(RequestHandlerRegistry<Request> reg) {
        Object object = this.requestHandlerMutex;
        synchronized (object) {
            if (this.requestHandlers.containsKey(reg.getAction())) {
                throw new IllegalArgumentException("transport handlers for action " + reg.getAction() + " is already registered");
            }
            this.requestHandlers = MapBuilder.newMapBuilder(this.requestHandlers).put((Object)reg.getAction(), reg).immutableMap();
        }
    }

    public Transport.ResponseHandlers getResponseHandlers() {
        return this.responseHandlers;
    }

    public RequestHandlerRegistry<TransportRequest> getRequestHandler(String action) {
        return this.requestHandlers.get(action);
    }

    public void addMessageListener(TransportMessageListener listener) {
        if (this.listener != null) {
            throw new IllegalStateException("listener already set");
        }
        this.listener = listener;
    }

    public boolean removeMessageListener(TransportMessageListener listener) {
        if (listener == this.listener) {
            this.listener = null;
            return true;
        }
        return false;
    }

    protected NamedWriteableRegistry writeableRegistry() {
        return new NamedWriteableRegistry(ClusterModule.getNamedWriteables());
    }
}

