/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.util.CollectionUtil;
import org.apache.lucene.util.Constants;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.CheckedRunnable;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.network.CloseableChannel;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.network.NetworkUtils;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.breaker.NoneCircuitBreakerService;
import org.elasticsearch.mocksocket.MockServerSocket;
import org.elasticsearch.node.Node;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.VersionUtils;
import org.elasticsearch.test.transport.MockTransportService;
import org.elasticsearch.test.transport.StubbableTransport;
import org.elasticsearch.threadpool.TestThreadPool;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.ConnectionProfile;
import org.elasticsearch.transport.EmptyTransportResponseHandler;
import org.elasticsearch.transport.InboundMessage;
import org.elasticsearch.transport.NodeDisconnectedException;
import org.elasticsearch.transport.NodeNotConnectedException;
import org.elasticsearch.transport.ReceiveTimeoutTransportException;
import org.elasticsearch.transport.SendRequestTransportException;
import org.elasticsearch.transport.TcpChannel;
import org.elasticsearch.transport.TcpTransport;
import org.elasticsearch.transport.TestProfiles;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportConnectionListener;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportFuture;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.TransportSettings;
import org.elasticsearch.transport.TransportStats;
import org.elasticsearch.transport.nio.MockNioTransport;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class AbstractSimpleTransportTestCase
extends ESTestCase {
    protected ThreadPool threadPool;
    private static final Version CURRENT_VERSION = Version.fromString((String)(String.valueOf(Version.CURRENT.major) + ".0.0"));
    protected static final Version version0 = CURRENT_VERSION.minimumCompatibilityVersion();
    private ClusterSettings clusterSettings;
    protected volatile DiscoveryNode nodeA;
    protected volatile MockTransportService serviceA;
    protected static final Version version1 = Version.fromId((int)(AbstractSimpleTransportTestCase.CURRENT_VERSION.id + 1));
    protected volatile DiscoveryNode nodeB;
    protected volatile MockTransportService serviceB;

    protected abstract MockTransportService build(Settings var1, Version var2, ClusterSettings var3, boolean var4);

    protected int channelsPerNodeConnection() {
        return 6;
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.threadPool = new TestThreadPool(((Object)((Object)this)).getClass().getName());
        this.clusterSettings = new ClusterSettings(Settings.EMPTY, ClusterSettings.BUILT_IN_CLUSTER_SETTINGS);
        Settings connectionSettings = Settings.builder().put(TransportSettings.CONNECTIONS_PER_NODE_RECOVERY.getKey(), 1).put(TransportSettings.CONNECTIONS_PER_NODE_BULK.getKey(), 1).put(TransportSettings.CONNECTIONS_PER_NODE_REG.getKey(), 2).put(TransportSettings.CONNECTIONS_PER_NODE_STATE.getKey(), 1).put(TransportSettings.CONNECTIONS_PER_NODE_PING.getKey(), 1).build();
        this.serviceA = this.buildService("TS_A", version0, this.clusterSettings, connectionSettings);
        this.nodeA = this.serviceA.getLocalNode();
        this.serviceB = this.buildService("TS_B", version1, null, connectionSettings);
        this.nodeB = this.serviceB.getLocalNode();
        final CountDownLatch latch = new CountDownLatch(2);
        TransportConnectionListener waitForConnection = new TransportConnectionListener(){

            public void onNodeConnected(DiscoveryNode node) {
                latch.countDown();
            }

            public void onNodeDisconnected(DiscoveryNode node) {
                Assert.fail((String)("disconnect should not be called " + node));
            }
        };
        this.serviceA.addConnectionListener(waitForConnection);
        this.serviceB.addConnectionListener(waitForConnection);
        int numHandshakes = 1;
        this.serviceA.connectToNode(this.nodeB);
        this.serviceB.connectToNode(this.nodeA);
        this.assertNumHandshakes(numHandshakes, this.serviceA.getOriginalTransport());
        this.assertNumHandshakes(numHandshakes, this.serviceB.getOriginalTransport());
        AbstractSimpleTransportTestCase.assertThat((String)"failed to wait for all nodes to connect", (Object)latch.await(5L, TimeUnit.SECONDS), (Matcher)Matchers.equalTo((Object)true));
        this.serviceA.removeConnectionListener(waitForConnection);
        this.serviceB.removeConnectionListener(waitForConnection);
    }

    private MockTransportService buildService(String name, Version version, ClusterSettings clusterSettings, Settings settings, boolean acceptRequests, boolean doHandshake) {
        MockTransportService service = this.build(Settings.builder().put(settings).put(Node.NODE_NAME_SETTING.getKey(), name).put(TransportSettings.TRACE_LOG_INCLUDE_SETTING.getKey(), "").put(TransportSettings.TRACE_LOG_EXCLUDE_SETTING.getKey(), "NOTHING").build(), version, clusterSettings, doHandshake);
        if (acceptRequests) {
            service.acceptIncomingRequests();
        }
        return service;
    }

    protected MockTransportService buildService(String name, Version version, ClusterSettings clusterSettings) {
        return this.buildService(name, version, clusterSettings, Settings.EMPTY);
    }

    protected MockTransportService buildService(String name, Version version, ClusterSettings clusterSettings, Settings settings) {
        return this.buildService(name, version, clusterSettings, settings, true, true);
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
        try {
            this.assertNoPendingHandshakes(this.serviceA.getOriginalTransport());
            this.assertNoPendingHandshakes(this.serviceB.getOriginalTransport());
        }
        catch (Throwable throwable) {
            IOUtils.close((Closeable[])new Closeable[]{this.serviceA, this.serviceB, () -> AbstractSimpleTransportTestCase.terminate(this.threadPool)});
            throw throwable;
        }
        IOUtils.close((Closeable[])new Closeable[]{this.serviceA, this.serviceB, () -> AbstractSimpleTransportTestCase.terminate(this.threadPool)});
    }

    public void assertNumHandshakes(long expected, Transport transport) {
        if (transport instanceof TcpTransport) {
            AbstractSimpleTransportTestCase.assertEquals((long)expected, (long)((TcpTransport)transport).getNumHandshakes());
        }
    }

    public void assertNoPendingHandshakes(Transport transport) {
        if (transport instanceof TcpTransport) {
            AbstractSimpleTransportTestCase.assertEquals((long)0L, (long)((TcpTransport)transport).getNumPendingHandshakes());
        }
    }

    public void testHelloWorld() {
        StringMessageResponse message;
        this.serviceA.registerRequestHandler("internal:sayHello", StringMessageRequest::new, "generic", (request, channel, task) -> {
            AbstractSimpleTransportTestCase.assertThat((Object)"moshe", (Matcher)Matchers.equalTo((Object)((StringMessageRequest)request).message));
            try {
                channel.sendResponse((TransportResponse)new StringMessageResponse("hello " + ((StringMessageRequest)request).message));
            }
            catch (IOException e) {
                this.logger.error("Unexpected failure", (Throwable)e);
                AbstractSimpleTransportTestCase.fail((String)e.getMessage());
            }
        });
        TransportFuture res = this.serviceB.submitRequest(this.nodeA, "internal:sayHello", new StringMessageRequest("moshe"), (TransportResponseHandler)new TransportResponseHandler<StringMessageResponse>(){

            public StringMessageResponse read(StreamInput in) throws IOException {
                return new StringMessageResponse(in);
            }

            public String executor() {
                return "generic";
            }

            public void handleResponse(StringMessageResponse response) {
                Assert.assertThat((Object)"hello moshe", (Matcher)Matchers.equalTo((Object)response.message));
            }

            public void handleException(TransportException exp) {
                AbstractSimpleTransportTestCase.this.logger.error("Unexpected failure", (Throwable)exp);
                Assert.fail((String)("got exception instead of a response: " + exp.getMessage()));
            }
        });
        try {
            message = (StringMessageResponse)((Object)res.get());
            AbstractSimpleTransportTestCase.assertThat((Object)"hello moshe", (Matcher)Matchers.equalTo((Object)message.message));
        }
        catch (Exception e) {
            AbstractSimpleTransportTestCase.assertThat((String)e.getMessage(), (Object)false, (Matcher)Matchers.equalTo((Object)true));
        }
        res = this.serviceB.submitRequest(this.nodeA, "internal:sayHello", new StringMessageRequest("moshe"), TransportRequestOptions.EMPTY, (TransportResponseHandler)new TransportResponseHandler<StringMessageResponse>(){

            public StringMessageResponse read(StreamInput in) throws IOException {
                return new StringMessageResponse(in);
            }

            public String executor() {
                return "generic";
            }

            public void handleResponse(StringMessageResponse response) {
                Assert.assertThat((Object)"hello moshe", (Matcher)Matchers.equalTo((Object)response.message));
            }

            public void handleException(TransportException exp) {
                AbstractSimpleTransportTestCase.this.logger.error("Unexpected failure", (Throwable)exp);
                Assert.fail((String)("got exception instead of a response: " + exp.getMessage()));
            }
        });
        try {
            message = (StringMessageResponse)((Object)res.get());
            AbstractSimpleTransportTestCase.assertThat((Object)"hello moshe", (Matcher)Matchers.equalTo((Object)message.message));
        }
        catch (Exception e) {
            AbstractSimpleTransportTestCase.assertThat((String)e.getMessage(), (Object)false, (Matcher)Matchers.equalTo((Object)true));
        }
    }

    public void testThreadContext() throws ExecutionException, InterruptedException {
        this.serviceA.registerRequestHandler("internal:ping_pong", StringMessageRequest::new, "generic", (request, channel, task) -> {
            AbstractSimpleTransportTestCase.assertEquals((Object)"ping_user", (Object)this.threadPool.getThreadContext().getHeader("test.ping.user"));
            AbstractSimpleTransportTestCase.assertNull((Object)this.threadPool.getThreadContext().getTransient("my_private_context"));
            try {
                StringMessageResponse response = new StringMessageResponse("pong");
                this.threadPool.getThreadContext().putHeader("test.pong.user", "pong_user");
                channel.sendResponse((TransportResponse)response);
            }
            catch (IOException e) {
                this.logger.error("Unexpected failure", (Throwable)e);
                AbstractSimpleTransportTestCase.fail((String)e.getMessage());
            }
        });
        final Object context = new Object();
        final String executor = AbstractSimpleTransportTestCase.randomFrom(ThreadPool.THREAD_POOL_TYPES.keySet().toArray(new String[0]));
        TransportResponseHandler<StringMessageResponse> responseHandler = new TransportResponseHandler<StringMessageResponse>(){

            public StringMessageResponse read(StreamInput in) throws IOException {
                return new StringMessageResponse(in);
            }

            public String executor() {
                return executor;
            }

            public void handleResponse(StringMessageResponse response) {
                Assert.assertThat((Object)"pong", (Matcher)Matchers.equalTo((Object)response.message));
                Assert.assertEquals((Object)"ping_user", (Object)AbstractSimpleTransportTestCase.this.threadPool.getThreadContext().getHeader("test.ping.user"));
                Assert.assertNull((Object)AbstractSimpleTransportTestCase.this.threadPool.getThreadContext().getHeader("test.pong.user"));
                Assert.assertSame((Object)context, (Object)AbstractSimpleTransportTestCase.this.threadPool.getThreadContext().getTransient("my_private_context"));
                AbstractSimpleTransportTestCase.this.threadPool.getThreadContext().putHeader("some.temp.header", "booooom");
            }

            public void handleException(TransportException exp) {
                AbstractSimpleTransportTestCase.this.logger.error("Unexpected failure", (Throwable)exp);
                Assert.fail((String)("got exception instead of a response: " + exp.getMessage()));
            }
        };
        StringMessageRequest ping = new StringMessageRequest("ping");
        this.threadPool.getThreadContext().putHeader("test.ping.user", "ping_user");
        this.threadPool.getThreadContext().putTransient("my_private_context", context);
        TransportFuture res = this.serviceB.submitRequest(this.nodeA, "internal:ping_pong", ping, (TransportResponseHandler)responseHandler);
        StringMessageResponse message = (StringMessageResponse)((Object)res.get());
        AbstractSimpleTransportTestCase.assertThat((Object)"pong", (Matcher)Matchers.equalTo((Object)message.message));
        AbstractSimpleTransportTestCase.assertEquals((Object)"ping_user", (Object)this.threadPool.getThreadContext().getHeader("test.ping.user"));
        AbstractSimpleTransportTestCase.assertSame((Object)context, (Object)this.threadPool.getThreadContext().getTransient("my_private_context"));
        AbstractSimpleTransportTestCase.assertNull((String)"this header is only visible in the handler context", (Object)this.threadPool.getThreadContext().getHeader("some.temp.header"));
    }

    public void testLocalNodeConnection() throws InterruptedException {
        AbstractSimpleTransportTestCase.assertTrue((String)"serviceA is not connected to nodeA", (boolean)this.serviceA.nodeConnected(this.nodeA));
        this.serviceA.disconnectFromNode(this.nodeA);
        final AtomicReference exception = new AtomicReference();
        this.serviceA.registerRequestHandler("internal:localNode", StringMessageRequest::new, "generic", (request, channel, task) -> {
            try {
                channel.sendResponse((TransportResponse)new StringMessageResponse(((StringMessageRequest)request).message));
            }
            catch (IOException e) {
                exception.set(e);
            }
        });
        final AtomicReference responseString = new AtomicReference();
        final CountDownLatch responseLatch = new CountDownLatch(1);
        this.serviceA.sendRequest(this.nodeA, "internal:localNode", new StringMessageRequest("test"), (TransportResponseHandler)new TransportResponseHandler<StringMessageResponse>(){

            public StringMessageResponse read(StreamInput in) throws IOException {
                return new StringMessageResponse(in);
            }

            public void handleResponse(StringMessageResponse response) {
                responseString.set(response.message);
                responseLatch.countDown();
            }

            public void handleException(TransportException exp) {
                exception.set(exp);
                responseLatch.countDown();
            }

            public String executor() {
                return "generic";
            }
        });
        responseLatch.await();
        AbstractSimpleTransportTestCase.assertNull(exception.get());
        AbstractSimpleTransportTestCase.assertThat((Object)((String)responseString.get()), (Matcher)Matchers.equalTo((Object)"test"));
    }

    public void testAdapterSendReceiveCallbacks() throws Exception {
        TransportRequestHandler requestHandler = (request, channel, task) -> {
            try {
                if (AbstractSimpleTransportTestCase.randomBoolean()) {
                    channel.sendResponse((TransportResponse)TransportResponse.Empty.INSTANCE);
                } else {
                    channel.sendResponse((Exception)new ElasticsearchException("simulated", new Object[0]));
                }
            }
            catch (IOException e) {
                this.logger.error("Unexpected failure", (Throwable)e);
                AbstractSimpleTransportTestCase.fail((String)e.getMessage());
            }
        };
        String ACTION = "internal:action";
        this.serviceA.registerRequestHandler("internal:action", TransportRequest.Empty::new, "generic", requestHandler);
        this.serviceB.registerRequestHandler("internal:action", TransportRequest.Empty::new, "generic", requestHandler);
        class CountingTracer
        extends MockTransportService.Tracer {
            AtomicInteger requestsReceived = new AtomicInteger();
            AtomicInteger requestsSent = new AtomicInteger();
            AtomicInteger responseReceived = new AtomicInteger();
            AtomicInteger responseSent = new AtomicInteger();

            CountingTracer() {
            }

            @Override
            public void receivedRequest(long requestId, String action) {
                if (action.equals("internal:action")) {
                    this.requestsReceived.incrementAndGet();
                }
            }

            @Override
            public void responseSent(long requestId, String action) {
                if (action.equals("internal:action")) {
                    this.responseSent.incrementAndGet();
                }
            }

            @Override
            public void responseSent(long requestId, String action, Throwable t) {
                if (action.equals("internal:action")) {
                    this.responseSent.incrementAndGet();
                }
            }

            @Override
            public void receivedResponse(long requestId, DiscoveryNode sourceNode, String action) {
                if (action.equals("internal:action")) {
                    this.responseReceived.incrementAndGet();
                }
            }

            @Override
            public void requestSent(DiscoveryNode node, long requestId, String action, TransportRequestOptions options) {
                if (action.equals("internal:action")) {
                    this.requestsSent.incrementAndGet();
                }
            }
        }
        CountingTracer tracerA = new CountingTracer();
        CountingTracer tracerB = new CountingTracer();
        this.serviceA.addTracer(tracerA);
        this.serviceB.addTracer(tracerB);
        try {
            this.serviceA.submitRequest(this.nodeB, "internal:action", (TransportRequest)TransportRequest.Empty.INSTANCE, (TransportResponseHandler)EmptyTransportResponseHandler.INSTANCE_SAME).get();
        }
        catch (ExecutionException e) {
            AbstractSimpleTransportTestCase.assertThat((Object)e.getCause(), (Matcher)Matchers.instanceOf(ElasticsearchException.class));
            AbstractSimpleTransportTestCase.assertThat((Object)ExceptionsHelper.unwrapCause((Throwable)e.getCause()).getMessage(), (Matcher)Matchers.equalTo((Object)"simulated"));
        }
        AbstractSimpleTransportTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            AbstractSimpleTransportTestCase.assertThat((Object)tracerA.requestsReceived.get(), (Matcher)Matchers.equalTo((Object)0));
            AbstractSimpleTransportTestCase.assertThat((Object)tracerA.requestsSent.get(), (Matcher)Matchers.equalTo((Object)1));
            AbstractSimpleTransportTestCase.assertThat((Object)tracerA.responseReceived.get(), (Matcher)Matchers.equalTo((Object)1));
            AbstractSimpleTransportTestCase.assertThat((Object)tracerA.responseSent.get(), (Matcher)Matchers.equalTo((Object)0));
            AbstractSimpleTransportTestCase.assertThat((Object)tracerB.requestsReceived.get(), (Matcher)Matchers.equalTo((Object)1));
            AbstractSimpleTransportTestCase.assertThat((Object)tracerB.requestsSent.get(), (Matcher)Matchers.equalTo((Object)0));
            AbstractSimpleTransportTestCase.assertThat((Object)tracerB.responseReceived.get(), (Matcher)Matchers.equalTo((Object)0));
            AbstractSimpleTransportTestCase.assertThat((Object)tracerB.responseSent.get(), (Matcher)Matchers.equalTo((Object)1));
        }));
        try {
            this.serviceA.submitRequest(this.nodeA, "internal:action", (TransportRequest)TransportRequest.Empty.INSTANCE, (TransportResponseHandler)EmptyTransportResponseHandler.INSTANCE_SAME).get();
        }
        catch (ExecutionException e) {
            AbstractSimpleTransportTestCase.assertThat((Object)e.getCause(), (Matcher)Matchers.instanceOf(ElasticsearchException.class));
            AbstractSimpleTransportTestCase.assertThat((Object)ExceptionsHelper.unwrapCause((Throwable)e.getCause()).getMessage(), (Matcher)Matchers.equalTo((Object)"simulated"));
        }
        AbstractSimpleTransportTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            AbstractSimpleTransportTestCase.assertThat((Object)tracerA.requestsReceived.get(), (Matcher)Matchers.equalTo((Object)1));
            AbstractSimpleTransportTestCase.assertThat((Object)tracerA.requestsSent.get(), (Matcher)Matchers.equalTo((Object)2));
            AbstractSimpleTransportTestCase.assertThat((Object)tracerA.responseReceived.get(), (Matcher)Matchers.equalTo((Object)2));
            AbstractSimpleTransportTestCase.assertThat((Object)tracerA.responseSent.get(), (Matcher)Matchers.equalTo((Object)1));
            AbstractSimpleTransportTestCase.assertThat((Object)tracerB.requestsReceived.get(), (Matcher)Matchers.equalTo((Object)1));
            AbstractSimpleTransportTestCase.assertThat((Object)tracerB.requestsSent.get(), (Matcher)Matchers.equalTo((Object)0));
            AbstractSimpleTransportTestCase.assertThat((Object)tracerB.responseReceived.get(), (Matcher)Matchers.equalTo((Object)0));
            AbstractSimpleTransportTestCase.assertThat((Object)tracerB.responseSent.get(), (Matcher)Matchers.equalTo((Object)1));
        }));
    }

    public void testVoidMessageCompressed() {
        try (MockTransportService serviceC = this.build(Settings.EMPTY, CURRENT_VERSION, null, true);){
            serviceC.start();
            serviceC.acceptIncomingRequests();
            this.serviceA.registerRequestHandler("internal:sayHello", TransportRequest.Empty::new, "generic", (request, channel, task) -> {
                try {
                    channel.sendResponse((TransportResponse)TransportResponse.Empty.INSTANCE);
                }
                catch (IOException e) {
                    this.logger.error("Unexpected failure", (Throwable)e);
                    AbstractSimpleTransportTestCase.fail((String)e.getMessage());
                }
            });
            Settings settingsWithCompress = Settings.builder().put(TransportSettings.TRANSPORT_COMPRESS.getKey(), true).build();
            ConnectionProfile connectionProfile = ConnectionProfile.buildDefaultConnectionProfile((Settings)settingsWithCompress);
            serviceC.connectToNode(this.serviceA.getLocalDiscoNode(), connectionProfile);
            TransportFuture res = serviceC.submitRequest(this.nodeA, "internal:sayHello", (TransportRequest)TransportRequest.Empty.INSTANCE, TransportRequestOptions.EMPTY, (TransportResponseHandler)new TransportResponseHandler<TransportResponse.Empty>(){

                public TransportResponse.Empty read(StreamInput in) {
                    return TransportResponse.Empty.INSTANCE;
                }

                public String executor() {
                    return "generic";
                }

                public void handleResponse(TransportResponse.Empty response) {
                }

                public void handleException(TransportException exp) {
                    AbstractSimpleTransportTestCase.this.logger.error("Unexpected failure", (Throwable)exp);
                    Assert.fail((String)("got exception instead of a response: " + exp.getMessage()));
                }
            });
            try {
                TransportResponse.Empty message = (TransportResponse.Empty)res.get();
                AbstractSimpleTransportTestCase.assertThat((Object)message, (Matcher)Matchers.notNullValue());
            }
            catch (Exception e) {
                AbstractSimpleTransportTestCase.assertThat((String)e.getMessage(), (Object)false, (Matcher)Matchers.equalTo((Object)true));
            }
        }
    }

    public void testHelloWorldCompressed() throws IOException {
        try (MockTransportService serviceC = this.build(Settings.EMPTY, CURRENT_VERSION, null, true);){
            serviceC.start();
            serviceC.acceptIncomingRequests();
            this.serviceA.registerRequestHandler("internal:sayHello", StringMessageRequest::new, "generic", (request, channel, task) -> {
                AbstractSimpleTransportTestCase.assertThat((Object)"moshe", (Matcher)Matchers.equalTo((Object)((StringMessageRequest)request).message));
                try {
                    channel.sendResponse((TransportResponse)new StringMessageResponse("hello " + ((StringMessageRequest)request).message));
                }
                catch (IOException e) {
                    this.logger.error("Unexpected failure", (Throwable)e);
                    AbstractSimpleTransportTestCase.fail((String)e.getMessage());
                }
            });
            Settings settingsWithCompress = Settings.builder().put(TransportSettings.TRANSPORT_COMPRESS.getKey(), true).build();
            ConnectionProfile connectionProfile = ConnectionProfile.buildDefaultConnectionProfile((Settings)settingsWithCompress);
            serviceC.connectToNode(this.serviceA.getLocalDiscoNode(), connectionProfile);
            TransportFuture res = serviceC.submitRequest(this.nodeA, "internal:sayHello", new StringMessageRequest("moshe"), TransportRequestOptions.EMPTY, (TransportResponseHandler)new TransportResponseHandler<StringMessageResponse>(){

                public StringMessageResponse read(StreamInput in) throws IOException {
                    return new StringMessageResponse(in);
                }

                public String executor() {
                    return "generic";
                }

                public void handleResponse(StringMessageResponse response) {
                    Assert.assertThat((Object)"hello moshe", (Matcher)Matchers.equalTo((Object)response.message));
                }

                public void handleException(TransportException exp) {
                    AbstractSimpleTransportTestCase.this.logger.error("Unexpected failure", (Throwable)exp);
                    Assert.fail((String)("got exception instead of a response: " + exp.getMessage()));
                }
            });
            try {
                StringMessageResponse message = (StringMessageResponse)((Object)res.get());
                AbstractSimpleTransportTestCase.assertThat((Object)"hello moshe", (Matcher)Matchers.equalTo((Object)message.message));
            }
            catch (Exception e) {
                AbstractSimpleTransportTestCase.assertThat((String)e.getMessage(), (Object)false, (Matcher)Matchers.equalTo((Object)true));
            }
        }
    }

    public void testErrorMessage() {
        this.serviceA.registerRequestHandler("internal:sayHelloException", StringMessageRequest::new, "generic", (request, channel, task) -> {
            AbstractSimpleTransportTestCase.assertThat((Object)"moshe", (Matcher)Matchers.equalTo((Object)((StringMessageRequest)request).message));
            throw new RuntimeException("bad message !!!");
        });
        TransportFuture res = this.serviceB.submitRequest(this.nodeA, "internal:sayHelloException", new StringMessageRequest("moshe"), (TransportResponseHandler)new TransportResponseHandler<StringMessageResponse>(){

            public StringMessageResponse read(StreamInput in) throws IOException {
                return new StringMessageResponse(in);
            }

            public String executor() {
                return "generic";
            }

            public void handleResponse(StringMessageResponse response) {
                Assert.fail((String)"got response instead of exception");
            }

            public void handleException(TransportException exp) {
                Assert.assertThat((Object)"runtime_exception: bad message !!!", (Matcher)Matchers.equalTo((Object)exp.getCause().getMessage()));
            }
        });
        try {
            res.txGet();
            AbstractSimpleTransportTestCase.fail((String)"exception should be thrown");
        }
        catch (Exception e) {
            AbstractSimpleTransportTestCase.assertThat((Object)e.getCause().getMessage(), (Matcher)Matchers.equalTo((Object)"runtime_exception: bad message !!!"));
        }
    }

    public void testDisconnectListener() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        TransportConnectionListener disconnectListener = new TransportConnectionListener(){

            public void onNodeConnected(DiscoveryNode node) {
                Assert.fail((String)("node connected should not be called, all connection have been done previously, node: " + node));
            }

            public void onNodeDisconnected(DiscoveryNode node) {
                latch.countDown();
            }
        };
        this.serviceA.addConnectionListener(disconnectListener);
        this.serviceB.close();
        AbstractSimpleTransportTestCase.assertThat((Object)latch.await(5L, TimeUnit.SECONDS), (Matcher)Matchers.equalTo((Object)true));
    }

    public void testConcurrentSendRespondAndDisconnect() throws BrokenBarrierException, InterruptedException {
        int sender;
        final Set sendingErrors = ConcurrentCollections.newConcurrentSet();
        Set responseErrors = ConcurrentCollections.newConcurrentSet();
        this.serviceA.registerRequestHandler("internal:test", TestRequest::new, AbstractSimpleTransportTestCase.randomBoolean() ? "same" : "generic", (request, channel, task) -> {
            try {
                channel.sendResponse((TransportResponse)new TestResponse((String)null));
            }
            catch (Exception e) {
                this.logger.info("caught exception while responding", (Throwable)e);
                responseErrors.add(e);
            }
        });
        TransportRequestHandler ignoringRequestHandler = (request, channel, task) -> {
            try {
                channel.sendResponse((TransportResponse)new TestResponse((String)null));
            }
            catch (Exception e) {
                this.logger.trace("caught exception while responding from node B", (Throwable)e);
            }
        };
        this.serviceB.registerRequestHandler("internal:test", TestRequest::new, "same", ignoringRequestHandler);
        int halfSenders = AbstractSimpleTransportTestCase.scaledRandomIntBetween(3, 10);
        final CyclicBarrier go = new CyclicBarrier(halfSenders * 2 + 1);
        final CountDownLatch done = new CountDownLatch(halfSenders * 2);
        int i = 0;
        while (i < halfSenders) {
            sender = i++;
            this.threadPool.executor("generic").execute((Runnable)new AbstractRunnable(){

                public void onFailure(Exception e) {
                    AbstractSimpleTransportTestCase.this.logger.trace("caught exception while sending from B", (Throwable)e);
                }

                protected void doRun() throws Exception {
                    go.await();
                    for (int iter = 0; iter < 10; ++iter) {
                        PlainActionFuture listener = new PlainActionFuture();
                        String info = sender + "_B_" + iter;
                        AbstractSimpleTransportTestCase.this.serviceB.sendRequest(AbstractSimpleTransportTestCase.this.nodeA, "test", new TestRequest(info), (TransportResponseHandler)new ActionListenerResponseHandler((ActionListener)listener, TestResponse::new));
                        try {
                            listener.actionGet();
                            continue;
                        }
                        catch (Exception e) {
                            AbstractSimpleTransportTestCase.this.logger.trace(() -> new ParameterizedMessage("caught exception while sending to node {}", (Object)AbstractSimpleTransportTestCase.this.nodeA), (Throwable)e);
                        }
                    }
                }

                public void onAfter() {
                    done.countDown();
                }
            });
        }
        i = 0;
        while (i < halfSenders) {
            sender = i++;
            this.threadPool.executor("generic").execute((Runnable)new AbstractRunnable(){

                public void onFailure(Exception e) {
                    AbstractSimpleTransportTestCase.this.logger.error("unexpected error", (Throwable)e);
                    sendingErrors.add(e);
                }

                protected void doRun() throws Exception {
                    go.await();
                    for (int iter = 0; iter < 10; ++iter) {
                        PlainActionFuture listener = new PlainActionFuture();
                        String info = sender + "_" + iter;
                        DiscoveryNode node = AbstractSimpleTransportTestCase.this.nodeB;
                        try {
                            AbstractSimpleTransportTestCase.this.serviceA.sendRequest(node, "internal:test", new TestRequest(info), (TransportResponseHandler)new ActionListenerResponseHandler((ActionListener)listener, TestResponse::new));
                            try {
                                listener.actionGet();
                            }
                            catch (ConnectTransportException connectTransportException) {
                            }
                            catch (Exception e) {
                                AbstractSimpleTransportTestCase.this.logger.error(() -> new ParameterizedMessage("caught exception while sending to node {}", (Object)node), (Throwable)e);
                                sendingErrors.add(e);
                            }
                            continue;
                        }
                        catch (NodeNotConnectedException nodeNotConnectedException) {
                            // empty catch block
                        }
                    }
                }

                public void onAfter() {
                    done.countDown();
                }
            });
        }
        go.await();
        for (i = 0; i <= 10; ++i) {
            if (i % 3 == 0) {
                this.serviceB.close();
                MockTransportService newService = this.buildService("TS_B_" + i, version1, null);
                newService.registerRequestHandler("internal:test", TestRequest::new, "same", ignoringRequestHandler);
                this.serviceB = newService;
                this.nodeB = newService.getLocalDiscoNode();
                this.serviceB.connectToNode(this.nodeA);
                this.serviceA.connectToNode(this.nodeB);
                continue;
            }
            if (this.serviceA.nodeConnected(this.nodeB)) {
                this.serviceA.disconnectFromNode(this.nodeB);
                continue;
            }
            this.serviceA.connectToNode(this.nodeB);
        }
        done.await();
        AbstractSimpleTransportTestCase.assertThat((String)"found non connection errors while sending", (Object)sendingErrors, (Matcher)Matchers.empty());
        AbstractSimpleTransportTestCase.assertThat((String)"found non connection errors while responding", (Object)responseErrors, (Matcher)Matchers.empty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNotifyOnShutdown() throws Exception {
        CountDownLatch latch2 = new CountDownLatch(1);
        CountDownLatch latch3 = new CountDownLatch(1);
        try {
            this.serviceA.registerRequestHandler("internal:foobar", StringMessageRequest::new, "generic", (request, channel, task) -> {
                try {
                    latch2.await();
                    this.logger.info("Stop ServiceB now");
                    this.serviceB.stop();
                }
                catch (Exception e) {
                    AbstractSimpleTransportTestCase.fail((String)e.getMessage());
                }
                finally {
                    latch3.countDown();
                }
            });
            TransportFuture foobar = this.serviceB.submitRequest(this.nodeA, "internal:foobar", new StringMessageRequest(""), TransportRequestOptions.EMPTY, (TransportResponseHandler)EmptyTransportResponseHandler.INSTANCE_SAME);
            latch2.countDown();
            try {
                foobar.txGet();
                AbstractSimpleTransportTestCase.fail((String)"TransportException expected");
            }
            catch (TransportException transportException) {
                // empty catch block
            }
            latch3.await();
        }
        finally {
            this.serviceB.close();
            this.serviceA.disconnectFromNode(this.nodeB);
        }
    }

    public void testTimeoutSendExceptionWithNeverSendingBackResponse() throws Exception {
        this.serviceA.registerRequestHandler("internal:sayHelloTimeoutNoResponse", StringMessageRequest::new, "generic", (TransportRequestHandler)new TransportRequestHandler<StringMessageRequest>(){

            public void messageReceived(StringMessageRequest request, TransportChannel channel, Task task) {
                Assert.assertThat((Object)"moshe", (Matcher)Matchers.equalTo((Object)request.message));
            }
        });
        TransportFuture res = this.serviceB.submitRequest(this.nodeA, "internal:sayHelloTimeoutNoResponse", new StringMessageRequest("moshe"), TransportRequestOptions.builder().withTimeout(100L).build(), (TransportResponseHandler)new TransportResponseHandler<StringMessageResponse>(){

            public StringMessageResponse read(StreamInput in) throws IOException {
                return new StringMessageResponse(in);
            }

            public String executor() {
                return "generic";
            }

            public void handleResponse(StringMessageResponse response) {
                Assert.fail((String)"got response instead of exception");
            }

            public void handleException(TransportException exp) {
                Assert.assertThat((Object)exp, (Matcher)Matchers.instanceOf(ReceiveTimeoutTransportException.class));
            }
        });
        try {
            res.txGet();
            AbstractSimpleTransportTestCase.fail((String)"exception should be thrown");
        }
        catch (Exception e) {
            AbstractSimpleTransportTestCase.assertThat((Object)e, (Matcher)Matchers.instanceOf(ReceiveTimeoutTransportException.class));
        }
    }

    public void testTimeoutSendExceptionWithDelayedResponse() throws Exception {
        final CountDownLatch waitForever = new CountDownLatch(1);
        final CountDownLatch doneWaitingForever = new CountDownLatch(1);
        final Semaphore inFlight = new Semaphore(Integer.MAX_VALUE);
        this.serviceA.registerRequestHandler("internal:sayHelloTimeoutDelayedResponse", StringMessageRequest::new, "generic", (TransportRequestHandler)new TransportRequestHandler<StringMessageRequest>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void messageReceived(StringMessageRequest request, TransportChannel channel, Task task) throws InterruptedException {
                String message = request.message;
                inFlight.acquireUninterruptibly();
                try {
                    if ("forever".equals(message)) {
                        waitForever.await();
                    } else {
                        TimeValue sleep = TimeValue.parseTimeValue((String)message, null, (String)"sleep");
                        Thread.sleep(sleep.millis());
                    }
                    try {
                        channel.sendResponse((TransportResponse)new StringMessageResponse("hello " + request.message));
                    }
                    catch (IOException e) {
                        AbstractSimpleTransportTestCase.this.logger.error("Unexpected failure", (Throwable)e);
                        Assert.fail((String)e.getMessage());
                    }
                }
                finally {
                    inFlight.release();
                    if ("forever".equals(message)) {
                        doneWaitingForever.countDown();
                    }
                }
            }
        });
        final CountDownLatch latch = new CountDownLatch(1);
        TransportFuture res = this.serviceB.submitRequest(this.nodeA, "internal:sayHelloTimeoutDelayedResponse", new StringMessageRequest("forever"), TransportRequestOptions.builder().withTimeout(100L).build(), (TransportResponseHandler)new TransportResponseHandler<StringMessageResponse>(){

            public StringMessageResponse read(StreamInput in) throws IOException {
                return new StringMessageResponse(in);
            }

            public String executor() {
                return "generic";
            }

            public void handleResponse(StringMessageResponse response) {
                latch.countDown();
                Assert.fail((String)"got response instead of exception");
            }

            public void handleException(TransportException exp) {
                latch.countDown();
                Assert.assertThat((Object)exp, (Matcher)Matchers.instanceOf(ReceiveTimeoutTransportException.class));
            }
        });
        try {
            res.txGet();
            AbstractSimpleTransportTestCase.fail((String)"exception should be thrown");
        }
        catch (Exception e) {
            AbstractSimpleTransportTestCase.assertThat((Object)e, (Matcher)Matchers.instanceOf(ReceiveTimeoutTransportException.class));
        }
        latch.await();
        ArrayList<Runnable> assertions = new ArrayList<Runnable>();
        int i = 0;
        while (i < 10) {
            final int counter = i++;
            TransportFuture result = this.serviceB.submitRequest(this.nodeA, "internal:sayHelloTimeoutDelayedResponse", new StringMessageRequest(counter + "ms"), TransportRequestOptions.builder().withTimeout(3000L).build(), (TransportResponseHandler)new TransportResponseHandler<StringMessageResponse>(){

                public StringMessageResponse read(StreamInput in) throws IOException {
                    return new StringMessageResponse(in);
                }

                public String executor() {
                    return "generic";
                }

                public void handleResponse(StringMessageResponse response) {
                    Assert.assertThat((Object)("hello " + counter + "ms"), (Matcher)Matchers.equalTo((Object)response.message));
                }

                public void handleException(TransportException exp) {
                    AbstractSimpleTransportTestCase.this.logger.error("Unexpected failure", (Throwable)exp);
                    Assert.fail((String)("got exception instead of a response for " + counter + ": " + exp.getDetailedMessage()));
                }
            });
            assertions.add(() -> {
                StringMessageResponse message = (StringMessageResponse)((Object)((Object)result.txGet()));
                AbstractSimpleTransportTestCase.assertThat((Object)message.message, (Matcher)Matchers.equalTo((Object)("hello " + counter + "ms")));
            });
        }
        for (Runnable runnable : assertions) {
            runnable.run();
        }
        waitForever.countDown();
        doneWaitingForever.await();
        AbstractSimpleTransportTestCase.assertTrue((boolean)inFlight.tryAcquire(Integer.MAX_VALUE, 10L, TimeUnit.SECONDS));
    }

    public void testTracerLog() throws InterruptedException {
        String excludeSettings;
        String includeSettings;
        TransportRequestHandler handler = (request, channel, task) -> channel.sendResponse((TransportResponse)new StringMessageResponse(""));
        TransportRequestHandler<StringMessageRequest> handlerWithError = new TransportRequestHandler<StringMessageRequest>(){

            public void messageReceived(StringMessageRequest request, TransportChannel channel, Task task) throws Exception {
                if (request.timeout() > 0L) {
                    Thread.sleep(request.timeout);
                }
                channel.sendResponse((Exception)new RuntimeException(""));
            }
        };
        final Semaphore requestCompleted = new Semaphore(0);
        TransportResponseHandler<StringMessageResponse> noopResponseHandler = new TransportResponseHandler<StringMessageResponse>(){

            public StringMessageResponse read(StreamInput in) throws IOException {
                return new StringMessageResponse(in);
            }

            public void handleResponse(StringMessageResponse response) {
                requestCompleted.release();
            }

            public void handleException(TransportException exp) {
                requestCompleted.release();
            }

            public String executor() {
                return "same";
            }
        };
        this.serviceA.registerRequestHandler("internal:test", StringMessageRequest::new, "same", handler);
        this.serviceA.registerRequestHandler("internal:testError", StringMessageRequest::new, "same", (TransportRequestHandler)handlerWithError);
        this.serviceB.registerRequestHandler("internal:test", StringMessageRequest::new, "same", handler);
        this.serviceB.registerRequestHandler("internal:testError", StringMessageRequest::new, "same", (TransportRequestHandler)handlerWithError);
        Tracer tracer = new Tracer(new HashSet<String>(Arrays.asList("internal:test", "internal:testError")));
        this.serviceA.addTracer(tracer);
        this.serviceB.addTracer(tracer);
        tracer.reset(4);
        boolean timeout = AbstractSimpleTransportTestCase.randomBoolean();
        TransportRequestOptions options = timeout ? TransportRequestOptions.builder().withTimeout(1L).build() : TransportRequestOptions.EMPTY;
        this.serviceA.sendRequest(this.nodeB, "internal:test", new StringMessageRequest("", 10L), options, (TransportResponseHandler)noopResponseHandler);
        requestCompleted.acquire();
        tracer.expectedEvents.get().await();
        AbstractSimpleTransportTestCase.assertThat((String)"didn't see request sent", (Object)tracer.sawRequestSent, (Matcher)Matchers.equalTo((Object)true));
        AbstractSimpleTransportTestCase.assertThat((String)"didn't see request received", (Object)tracer.sawRequestReceived, (Matcher)Matchers.equalTo((Object)true));
        AbstractSimpleTransportTestCase.assertThat((String)"didn't see response sent", (Object)tracer.sawResponseSent, (Matcher)Matchers.equalTo((Object)true));
        AbstractSimpleTransportTestCase.assertThat((String)"didn't see response received", (Object)tracer.sawResponseReceived, (Matcher)Matchers.equalTo((Object)true));
        AbstractSimpleTransportTestCase.assertThat((String)"saw error sent", (Object)tracer.sawErrorSent, (Matcher)Matchers.equalTo((Object)false));
        tracer.reset(4);
        this.serviceA.sendRequest(this.nodeB, "internal:testError", new StringMessageRequest(""), (TransportResponseHandler)noopResponseHandler);
        requestCompleted.acquire();
        tracer.expectedEvents.get().await();
        AbstractSimpleTransportTestCase.assertThat((String)"didn't see request sent", (Object)tracer.sawRequestSent, (Matcher)Matchers.equalTo((Object)true));
        AbstractSimpleTransportTestCase.assertThat((String)"didn't see request received", (Object)tracer.sawRequestReceived, (Matcher)Matchers.equalTo((Object)true));
        AbstractSimpleTransportTestCase.assertThat((String)"saw response sent", (Object)tracer.sawResponseSent, (Matcher)Matchers.equalTo((Object)false));
        AbstractSimpleTransportTestCase.assertThat((String)"didn't see response received", (Object)tracer.sawResponseReceived, (Matcher)Matchers.equalTo((Object)true));
        AbstractSimpleTransportTestCase.assertThat((String)"didn't see error sent", (Object)tracer.sawErrorSent, (Matcher)Matchers.equalTo((Object)true));
        if (AbstractSimpleTransportTestCase.randomBoolean()) {
            includeSettings = AbstractSimpleTransportTestCase.randomBoolean() ? "*" : "";
            excludeSettings = "*Error";
        } else {
            includeSettings = "internal:test";
            excludeSettings = "DOESN'T_MATCH";
        }
        this.clusterSettings.applySettings(Settings.builder().put(TransportSettings.TRACE_LOG_INCLUDE_SETTING.getKey(), includeSettings).put(TransportSettings.TRACE_LOG_EXCLUDE_SETTING.getKey(), excludeSettings).build());
        tracer.reset(4);
        this.serviceA.sendRequest(this.nodeB, "internal:test", new StringMessageRequest(""), (TransportResponseHandler)noopResponseHandler);
        requestCompleted.acquire();
        tracer.expectedEvents.get().await();
        AbstractSimpleTransportTestCase.assertThat((String)"didn't see request sent", (Object)tracer.sawRequestSent, (Matcher)Matchers.equalTo((Object)true));
        AbstractSimpleTransportTestCase.assertThat((String)"didn't see request received", (Object)tracer.sawRequestReceived, (Matcher)Matchers.equalTo((Object)true));
        AbstractSimpleTransportTestCase.assertThat((String)"didn't see response sent", (Object)tracer.sawResponseSent, (Matcher)Matchers.equalTo((Object)true));
        AbstractSimpleTransportTestCase.assertThat((String)"didn't see response received", (Object)tracer.sawResponseReceived, (Matcher)Matchers.equalTo((Object)true));
        AbstractSimpleTransportTestCase.assertThat((String)"saw error sent", (Object)tracer.sawErrorSent, (Matcher)Matchers.equalTo((Object)false));
        tracer.reset(2);
        this.serviceA.sendRequest(this.nodeB, "internal:testError", new StringMessageRequest(""), (TransportResponseHandler)noopResponseHandler);
        requestCompleted.acquire();
        tracer.expectedEvents.get().await();
        AbstractSimpleTransportTestCase.assertThat((String)"saw request sent", (Object)tracer.sawRequestSent, (Matcher)Matchers.equalTo((Object)false));
        AbstractSimpleTransportTestCase.assertThat((String)"didn't see request received", (Object)tracer.sawRequestReceived, (Matcher)Matchers.equalTo((Object)true));
        AbstractSimpleTransportTestCase.assertThat((String)"saw response sent", (Object)tracer.sawResponseSent, (Matcher)Matchers.equalTo((Object)false));
        AbstractSimpleTransportTestCase.assertThat((String)"saw response received", (Object)tracer.sawResponseReceived, (Matcher)Matchers.equalTo((Object)false));
        AbstractSimpleTransportTestCase.assertThat((String)"didn't see error sent", (Object)tracer.sawErrorSent, (Matcher)Matchers.equalTo((Object)true));
    }

    public void testVersionFrom0to1() throws Exception {
        this.serviceB.registerRequestHandler("internal:version", Version1Request::new, "same", (TransportRequestHandler)new TransportRequestHandler<Version1Request>(){

            public void messageReceived(Version1Request request, TransportChannel channel, Task task) throws Exception {
                Assert.assertThat((Object)request.value1, (Matcher)Matchers.equalTo((Object)1));
                Assert.assertThat((Object)request.value2, (Matcher)Matchers.equalTo((Object)0));
                Version1Response response = new Version1Response(1, 2);
                channel.sendResponse((TransportResponse)response);
                Assert.assertEquals((Object)version0, (Object)channel.getVersion());
            }
        });
        Version0Request version0Request = new Version0Request();
        version0Request.value1 = 1;
        Version0Response version0Response = (Version0Response)((Object)this.serviceA.submitRequest(this.nodeB, "internal:version", version0Request, (TransportResponseHandler)new TransportResponseHandler<Version0Response>(){

            public Version0Response read(StreamInput in) throws IOException {
                return new Version0Response(in);
            }

            public void handleResponse(Version0Response response) {
                Assert.assertThat((Object)response.value1, (Matcher)Matchers.equalTo((Object)1));
            }

            public void handleException(TransportException exp) {
                AbstractSimpleTransportTestCase.this.logger.error("Unexpected failure", (Throwable)exp);
                Assert.fail((String)("got exception instead of a response: " + exp.getMessage()));
            }

            public String executor() {
                return "same";
            }
        }).txGet());
        AbstractSimpleTransportTestCase.assertThat((Object)version0Response.value1, (Matcher)Matchers.equalTo((Object)1));
    }

    public void testVersionFrom1to0() throws Exception {
        this.serviceA.registerRequestHandler("internal:version", Version0Request::new, "same", (TransportRequestHandler)new TransportRequestHandler<Version0Request>(){

            public void messageReceived(Version0Request request, TransportChannel channel, Task task) throws Exception {
                Assert.assertThat((Object)request.value1, (Matcher)Matchers.equalTo((Object)1));
                Version0Response response = new Version0Response(1);
                channel.sendResponse((TransportResponse)response);
                Assert.assertEquals((Object)version0, (Object)channel.getVersion());
            }
        });
        Version1Request version1Request = new Version1Request();
        version1Request.value1 = 1;
        version1Request.value2 = 2;
        Version1Response version1Response = (Version1Response)((Object)this.serviceB.submitRequest(this.nodeA, "internal:version", version1Request, (TransportResponseHandler)new TransportResponseHandler<Version1Response>(){

            public Version1Response read(StreamInput in) throws IOException {
                return new Version1Response(in);
            }

            public void handleResponse(Version1Response response) {
                Assert.assertThat((Object)response.value1, (Matcher)Matchers.equalTo((Object)1));
                Assert.assertThat((Object)response.value2, (Matcher)Matchers.equalTo((Object)0));
            }

            public void handleException(TransportException exp) {
                AbstractSimpleTransportTestCase.this.logger.error("Unexpected failure", (Throwable)exp);
                Assert.fail((String)("got exception instead of a response: " + exp.getMessage()));
            }

            public String executor() {
                return "same";
            }
        }).txGet());
        AbstractSimpleTransportTestCase.assertThat((Object)version1Response.value1, (Matcher)Matchers.equalTo((Object)1));
        AbstractSimpleTransportTestCase.assertThat((Object)version1Response.value2, (Matcher)Matchers.equalTo((Object)0));
    }

    public void testVersionFrom1to1() throws Exception {
        this.serviceB.registerRequestHandler("internal:version", Version1Request::new, "same", (request, channel, task) -> {
            AbstractSimpleTransportTestCase.assertThat((Object)request.value1, (Matcher)Matchers.equalTo((Object)1));
            AbstractSimpleTransportTestCase.assertThat((Object)request.value2, (Matcher)Matchers.equalTo((Object)2));
            Version1Response response = new Version1Response(1, 2);
            channel.sendResponse((TransportResponse)response);
            AbstractSimpleTransportTestCase.assertEquals((Object)version1, (Object)channel.getVersion());
        });
        Version1Request version1Request = new Version1Request();
        version1Request.value1 = 1;
        version1Request.value2 = 2;
        Version1Response version1Response = (Version1Response)((Object)this.serviceB.submitRequest(this.nodeB, "internal:version", version1Request, (TransportResponseHandler)new TransportResponseHandler<Version1Response>(){

            public Version1Response read(StreamInput in) throws IOException {
                return new Version1Response(in);
            }

            public void handleResponse(Version1Response response) {
                Assert.assertThat((Object)response.value1, (Matcher)Matchers.equalTo((Object)1));
                Assert.assertThat((Object)response.value2, (Matcher)Matchers.equalTo((Object)2));
            }

            public void handleException(TransportException exp) {
                AbstractSimpleTransportTestCase.this.logger.error("Unexpected failure", (Throwable)exp);
                Assert.fail((String)("got exception instead of a response: " + exp.getMessage()));
            }

            public String executor() {
                return "same";
            }
        }).txGet());
        AbstractSimpleTransportTestCase.assertThat((Object)version1Response.value1, (Matcher)Matchers.equalTo((Object)1));
        AbstractSimpleTransportTestCase.assertThat((Object)version1Response.value2, (Matcher)Matchers.equalTo((Object)2));
    }

    public void testVersionFrom0to0() throws Exception {
        this.serviceA.registerRequestHandler("internal:version", Version0Request::new, "same", (request, channel, task) -> {
            AbstractSimpleTransportTestCase.assertThat((Object)request.value1, (Matcher)Matchers.equalTo((Object)1));
            Version0Response response = new Version0Response(1);
            channel.sendResponse((TransportResponse)response);
            AbstractSimpleTransportTestCase.assertEquals((Object)version0, (Object)channel.getVersion());
        });
        Version0Request version0Request = new Version0Request();
        version0Request.value1 = 1;
        Version0Response version0Response = (Version0Response)((Object)this.serviceA.submitRequest(this.nodeA, "internal:version", version0Request, (TransportResponseHandler)new TransportResponseHandler<Version0Response>(){

            public Version0Response read(StreamInput in) throws IOException {
                return new Version0Response(in);
            }

            public void handleResponse(Version0Response response) {
                Assert.assertThat((Object)response.value1, (Matcher)Matchers.equalTo((Object)1));
            }

            public void handleException(TransportException exp) {
                AbstractSimpleTransportTestCase.this.logger.error("Unexpected failure", (Throwable)exp);
                Assert.fail((String)("got exception instead of a response: " + exp.getMessage()));
            }

            public String executor() {
                return "same";
            }
        }).txGet());
        AbstractSimpleTransportTestCase.assertThat((Object)version0Response.value1, (Matcher)Matchers.equalTo((Object)1));
    }

    public void testMockFailToSendNoConnectRule() throws Exception {
        this.serviceA.registerRequestHandler("internal:sayHello", StringMessageRequest::new, "generic", (request, channel, task) -> {
            AbstractSimpleTransportTestCase.assertThat((Object)"moshe", (Matcher)Matchers.equalTo((Object)((StringMessageRequest)request).message));
            throw new RuntimeException("bad message !!!");
        });
        this.serviceB.addFailToSendNoConnectRule(this.serviceA);
        TransportFuture res = this.serviceB.submitRequest(this.nodeA, "internal:sayHello", new StringMessageRequest("moshe"), (TransportResponseHandler)new TransportResponseHandler<StringMessageResponse>(){

            public StringMessageResponse read(StreamInput in) throws IOException {
                return new StringMessageResponse(in);
            }

            public String executor() {
                return "generic";
            }

            public void handleResponse(StringMessageResponse response) {
                Assert.fail((String)"got response instead of exception");
            }

            public void handleException(TransportException exp) {
                Throwable cause = ExceptionsHelper.unwrapCause((Throwable)exp);
                Assert.assertThat((Object)cause, (Matcher)Matchers.instanceOf(ConnectTransportException.class));
                Assert.assertThat((Object)((ConnectTransportException)cause).node(), (Matcher)Matchers.equalTo((Object)AbstractSimpleTransportTestCase.this.nodeA));
            }
        });
        try {
            res.txGet();
            AbstractSimpleTransportTestCase.fail((String)"exception should be thrown");
        }
        catch (Exception e) {
            Throwable cause = ExceptionsHelper.unwrapCause((Throwable)e);
            AbstractSimpleTransportTestCase.assertThat((Object)cause, (Matcher)Matchers.instanceOf(ConnectTransportException.class));
            AbstractSimpleTransportTestCase.assertThat((Object)((ConnectTransportException)cause).node(), (Matcher)Matchers.equalTo((Object)this.nodeA));
        }
        AbstractSimpleTransportTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> AbstractSimpleTransportTestCase.assertFalse((boolean)this.serviceB.nodeConnected(this.nodeA))));
        try {
            this.serviceB.connectToNode(this.nodeA);
            AbstractSimpleTransportTestCase.fail((String)"exception should be thrown");
        }
        catch (ConnectTransportException connectTransportException) {
            // empty catch block
        }
        AbstractSimpleTransportTestCase.expectThrows(ConnectTransportException.class, () -> this.serviceB.openConnection(this.nodeA, TestProfiles.LIGHT_PROFILE));
    }

    public void testMockUnresponsiveRule() throws IOException {
        this.serviceA.registerRequestHandler("internal:sayHello", StringMessageRequest::new, "generic", (request, channel, task) -> {
            AbstractSimpleTransportTestCase.assertThat((Object)"moshe", (Matcher)Matchers.equalTo((Object)((StringMessageRequest)request).message));
            throw new RuntimeException("bad message !!!");
        });
        this.serviceB.addUnresponsiveRule(this.serviceA);
        TransportFuture res = this.serviceB.submitRequest(this.nodeA, "internal:sayHello", new StringMessageRequest("moshe"), TransportRequestOptions.builder().withTimeout(100L).build(), (TransportResponseHandler)new TransportResponseHandler<StringMessageResponse>(){

            public StringMessageResponse read(StreamInput in) throws IOException {
                return new StringMessageResponse(in);
            }

            public String executor() {
                return "generic";
            }

            public void handleResponse(StringMessageResponse response) {
                Assert.fail((String)"got response instead of exception");
            }

            public void handleException(TransportException exp) {
                Assert.assertThat((Object)exp, (Matcher)Matchers.instanceOf(ReceiveTimeoutTransportException.class));
            }
        });
        try {
            res.txGet();
            AbstractSimpleTransportTestCase.fail((String)"exception should be thrown");
        }
        catch (Exception e) {
            AbstractSimpleTransportTestCase.assertThat((Object)e, (Matcher)Matchers.instanceOf(ReceiveTimeoutTransportException.class));
        }
        try {
            this.serviceB.disconnectFromNode(this.nodeA);
            this.serviceB.connectToNode(this.nodeA);
            AbstractSimpleTransportTestCase.fail((String)"exception should be thrown");
        }
        catch (ConnectTransportException connectTransportException) {
            // empty catch block
        }
        AbstractSimpleTransportTestCase.expectThrows(ConnectTransportException.class, () -> this.serviceB.openConnection(this.nodeA, TestProfiles.LIGHT_PROFILE));
    }

    public void testHostOnMessages() throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(2);
        AtomicReference addressA = new AtomicReference();
        final AtomicReference addressB = new AtomicReference();
        this.serviceB.registerRequestHandler("internal:action1", TestRequest::new, "same", (request, channel, task) -> {
            addressA.set(request.remoteAddress());
            channel.sendResponse((TransportResponse)new TestResponse((String)null));
            latch.countDown();
        });
        this.serviceA.sendRequest(this.nodeB, "internal:action1", new TestRequest(), (TransportResponseHandler)new TransportResponseHandler<TestResponse>(){

            public TestResponse read(StreamInput in) throws IOException {
                return new TestResponse(in);
            }

            public void handleResponse(TestResponse response) {
                addressB.set(response.remoteAddress());
                latch.countDown();
            }

            public void handleException(TransportException exp) {
                latch.countDown();
            }

            public String executor() {
                return "same";
            }
        });
        if (!latch.await(10L, TimeUnit.SECONDS)) {
            AbstractSimpleTransportTestCase.fail((String)"message round trip did not complete within a sensible time frame");
        }
        AbstractSimpleTransportTestCase.assertTrue((boolean)this.nodeA.getAddress().getAddress().equals(((TransportAddress)addressA.get()).getAddress()));
        AbstractSimpleTransportTestCase.assertTrue((boolean)this.nodeB.getAddress().getAddress().equals(((TransportAddress)addressB.get()).getAddress()));
    }

    public void testBlockingIncomingRequests() throws Exception {
        try (MockTransportService service = this.buildService("TS_TEST", version0, null, Settings.EMPTY, false, false);){
            AtomicBoolean requestProcessed = new AtomicBoolean(false);
            service.registerRequestHandler("internal:action", TestRequest::new, "same", (request, channel, task) -> {
                requestProcessed.set(true);
                channel.sendResponse((TransportResponse)TransportResponse.Empty.INSTANCE);
            });
            DiscoveryNode node = service.getLocalNode();
            this.serviceA.close();
            this.serviceA = this.buildService("TS_A", version0, null, Settings.EMPTY, true, false);
            try (Transport.Connection connection = this.serviceA.openConnection(node, null);){
                final CountDownLatch latch = new CountDownLatch(1);
                this.serviceA.sendRequest(connection, "internal:action", new TestRequest(), TransportRequestOptions.EMPTY, (TransportResponseHandler)new TransportResponseHandler<TestResponse>(){

                    public TestResponse read(StreamInput in) throws IOException {
                        return new TestResponse(in);
                    }

                    public void handleResponse(TestResponse response) {
                        latch.countDown();
                    }

                    public void handleException(TransportException exp) {
                        latch.countDown();
                    }

                    public String executor() {
                        return "same";
                    }
                });
                AbstractSimpleTransportTestCase.assertFalse((boolean)requestProcessed.get());
                service.acceptIncomingRequests();
                AbstractSimpleTransportTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> AbstractSimpleTransportTestCase.assertTrue((boolean)requestProcessed.get())));
                latch.await();
            }
        }
    }

    public void testSendRandomRequests() throws InterruptedException {
        MockTransportService serviceC = this.build(Settings.builder().put("name", "TS_TEST").put(TransportSettings.TRACE_LOG_INCLUDE_SETTING.getKey(), "").put(TransportSettings.TRACE_LOG_EXCLUDE_SETTING.getKey(), "NOTHING").build(), version0, null, true);
        final DiscoveryNode nodeC = serviceC.getLocalNode();
        serviceC.acceptIncomingRequests();
        final CountDownLatch latch = new CountDownLatch(4);
        TransportConnectionListener waitForConnection = new TransportConnectionListener(){

            public void onNodeConnected(DiscoveryNode node) {
                latch.countDown();
            }

            public void onNodeDisconnected(DiscoveryNode node) {
                Assert.fail((String)("disconnect should not be called " + node));
            }
        };
        this.serviceA.addConnectionListener(waitForConnection);
        this.serviceB.addConnectionListener(waitForConnection);
        serviceC.addConnectionListener(waitForConnection);
        serviceC.connectToNode(this.nodeA);
        serviceC.connectToNode(this.nodeB);
        this.serviceA.connectToNode(nodeC);
        this.serviceB.connectToNode(nodeC);
        latch.await();
        this.serviceA.removeConnectionListener(waitForConnection);
        this.serviceB.removeConnectionListener(waitForConnection);
        serviceC.removeConnectionListener(waitForConnection);
        final HashMap<MockTransportService, DiscoveryNode> toNodeMap = new HashMap<MockTransportService, DiscoveryNode>();
        toNodeMap.put(this.serviceA, this.nodeA);
        toNodeMap.put(this.serviceB, this.nodeB);
        toNodeMap.put(serviceC, nodeC);
        final AtomicBoolean fail = new AtomicBoolean(false);
        class TestRequestHandler
        implements TransportRequestHandler<TestRequest> {
            private final TransportService service;

            TestRequestHandler(TransportService service) {
                this.service = service;
            }

            public void messageReceived(final TestRequest request, final TransportChannel channel, Task task) throws Exception {
                if (ESTestCase.randomBoolean()) {
                    Thread.sleep(ESTestCase.randomIntBetween(10, 50));
                }
                if (fail.get()) {
                    throw new IOException("forced failure");
                }
                if (ESTestCase.randomBoolean() && request.resendCount++ < 20) {
                    DiscoveryNode node = ESTestCase.randomFrom(AbstractSimpleTransportTestCase.this.nodeA, AbstractSimpleTransportTestCase.this.nodeB, nodeC);
                    AbstractSimpleTransportTestCase.this.logger.debug("send secondary request from {} to {} - {}", toNodeMap.get(this.service), (Object)node, (Object)request.info);
                    this.service.sendRequest(node, "internal:action1", (TransportRequest)new TestRequest("secondary " + request.info), TransportRequestOptions.EMPTY, (TransportResponseHandler)new TransportResponseHandler<TestResponse>(){

                        public TestResponse read(StreamInput in) throws IOException {
                            return new TestResponse(in);
                        }

                        public void handleResponse(TestResponse response) {
                            try {
                                if (ESTestCase.randomBoolean()) {
                                    Thread.sleep(ESTestCase.randomIntBetween(10, 50));
                                }
                                AbstractSimpleTransportTestCase.this.logger.debug("send secondary response {}", (Object)response.info);
                                channel.sendResponse((TransportResponse)response);
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        }

                        public void handleException(TransportException exp) {
                            try {
                                AbstractSimpleTransportTestCase.this.logger.debug("send secondary exception response for request {}", (Object)request.info);
                                channel.sendResponse((Exception)exp);
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        }

                        public String executor() {
                            return ESTestCase.randomBoolean() ? "same" : "generic";
                        }
                    });
                } else {
                    AbstractSimpleTransportTestCase.this.logger.debug("send response for {}", (Object)request.info);
                    channel.sendResponse((TransportResponse)new TestResponse("Response for: " + request.info));
                }
            }
        }
        this.serviceB.registerRequestHandler("internal:action1", TestRequest::new, AbstractSimpleTransportTestCase.randomFrom("same", "generic"), new TestRequestHandler(this.serviceB));
        serviceC.registerRequestHandler("internal:action1", TestRequest::new, AbstractSimpleTransportTestCase.randomFrom("same", "generic"), new TestRequestHandler(serviceC));
        this.serviceA.registerRequestHandler("internal:action1", TestRequest::new, AbstractSimpleTransportTestCase.randomFrom("same", "generic"), new TestRequestHandler(this.serviceA));
        int iters = AbstractSimpleTransportTestCase.randomIntBetween(30, 60);
        final CountDownLatch allRequestsDone = new CountDownLatch(iters);
        for (int i = 0; i < iters; ++i) {
            TransportService service = AbstractSimpleTransportTestCase.randomFrom(new TransportService[]{serviceC, this.serviceB, this.serviceA});
            DiscoveryNode node = AbstractSimpleTransportTestCase.randomFrom(nodeC, this.nodeB, this.nodeA);
            this.logger.debug("send from {} to {}", toNodeMap.get(service), (Object)node);
            class TestResponseHandler
            implements TransportResponseHandler<TestResponse> {
                private final int id;

                TestResponseHandler(int id) {
                    this.id = id;
                }

                public TestResponse read(StreamInput in) throws IOException {
                    return new TestResponse(in);
                }

                public void handleResponse(TestResponse response) {
                    AbstractSimpleTransportTestCase.this.logger.debug("---> received response: {}", (Object)response.info);
                    allRequestsDone.countDown();
                }

                public void handleException(TransportException exp) {
                    AbstractSimpleTransportTestCase.this.logger.debug(() -> new ParameterizedMessage("---> received exception for id {}", (Object)this.id), (Throwable)exp);
                    allRequestsDone.countDown();
                    Throwable unwrap = ExceptionsHelper.unwrap((Throwable)exp, (Class[])new Class[]{IOException.class});
                    Assert.assertNotNull((Object)unwrap);
                    Assert.assertEquals(IOException.class, unwrap.getClass());
                    Assert.assertEquals((Object)"forced failure", (Object)unwrap.getMessage());
                }

                public String executor() {
                    return ESTestCase.randomBoolean() ? "same" : "generic";
                }
            }
            service.sendRequest(node, "internal:action1", (TransportRequest)new TestRequest("REQ[" + i + "]"), TransportRequestOptions.EMPTY, (TransportResponseHandler)new TestResponseHandler(i));
        }
        this.logger.debug("waiting for response");
        fail.set(AbstractSimpleTransportTestCase.randomBoolean());
        boolean await = allRequestsDone.await(5L, TimeUnit.SECONDS);
        if (!await) {
            this.logger.debug("now failing forcefully");
            fail.set(true);
            AbstractSimpleTransportTestCase.assertTrue((boolean)allRequestsDone.await(5L, TimeUnit.SECONDS));
        }
        this.logger.debug("DONE");
        serviceC.close();
        this.serviceB.disconnectFromNode(nodeC);
        this.serviceA.disconnectFromNode(nodeC);
    }

    public void testRegisterHandlerTwice() {
        this.serviceB.registerRequestHandler("internal:action1", TestRequest::new, AbstractSimpleTransportTestCase.randomFrom("same", "generic"), (request, message, task) -> {
            throw new AssertionError((Object)"boom");
        });
        AbstractSimpleTransportTestCase.expectThrows(IllegalArgumentException.class, () -> this.serviceB.registerRequestHandler("internal:action1", TestRequest::new, AbstractSimpleTransportTestCase.randomFrom("same", "generic"), (request, message, task) -> {
            throw new AssertionError((Object)"boom");
        }));
        this.serviceA.registerRequestHandler("internal:action1", TestRequest::new, AbstractSimpleTransportTestCase.randomFrom("same", "generic"), (request, message, task) -> {
            throw new AssertionError((Object)"boom");
        });
    }

    public void testTimeoutPerConnection() throws IOException {
        AbstractSimpleTransportTestCase.assumeTrue((String)"Works only on BSD network stacks and apparently windows", (Constants.MAC_OS_X || Constants.FREE_BSD || Constants.WINDOWS ? 1 : 0) != 0);
        try (MockServerSocket socket = new MockServerSocket();){
            socket.bind(this.getLocalEphemeral(), 1);
            socket.setReuseAddress(true);
            DiscoveryNode first = new DiscoveryNode("TEST", new TransportAddress(socket.getInetAddress(), socket.getLocalPort()), Collections.emptyMap(), Collections.emptySet(), version0);
            DiscoveryNode second = new DiscoveryNode("TEST", new TransportAddress(socket.getInetAddress(), socket.getLocalPort()), Collections.emptyMap(), Collections.emptySet(), version0);
            ConnectionProfile.Builder builder = new ConnectionProfile.Builder();
            builder.addConnections(1, new TransportRequestOptions.Type[]{TransportRequestOptions.Type.BULK, TransportRequestOptions.Type.PING, TransportRequestOptions.Type.RECOVERY, TransportRequestOptions.Type.REG, TransportRequestOptions.Type.STATE});
            try (MockTransportService service = this.buildService("TS_TPC", Version.CURRENT, null, Settings.EMPTY, true, false);){
                IOUtils.close((Closeable[])new Closeable[]{service.openConnection(first, builder.build())});
                builder.setConnectTimeout(TimeValue.timeValueMillis((long)1L));
                ConnectionProfile profile = builder.build();
                long startTime = System.nanoTime();
                ConnectTransportException ex = (ConnectTransportException)AbstractSimpleTransportTestCase.expectThrows(ConnectTransportException.class, () -> service.openConnection(second, profile));
                long now = System.nanoTime();
                long timeTaken = TimeValue.nsecToMSec((long)(now - startTime));
                AbstractSimpleTransportTestCase.assertTrue((String)("test didn't timeout quick enough, time taken: [" + timeTaken + "]"), (timeTaken < TimeValue.timeValueSeconds((long)5L).millis() ? 1 : 0) != 0);
                AbstractSimpleTransportTestCase.assertEquals((Object)ex.getMessage(), (Object)("[][" + second.getAddress() + "] connect_timeout[1ms]"));
            }
        }
    }

    public void testHandshakeWithIncompatVersion() {
        AbstractSimpleTransportTestCase.assumeTrue((String)"only tcp transport has a handshake method", (boolean)(this.serviceA.getOriginalTransport() instanceof TcpTransport));
        Version version = Version.fromString((String)"2.0.0");
        try (MockTransportService service = this.build(Settings.EMPTY, version, null, true);){
            service.start();
            service.acceptIncomingRequests();
            TransportAddress address = service.boundAddress().publishAddress();
            DiscoveryNode node = new DiscoveryNode("TS_TPC", "TS_TPC", address, Collections.emptyMap(), Collections.emptySet(), version0);
            ConnectionProfile.Builder builder = new ConnectionProfile.Builder();
            builder.addConnections(1, new TransportRequestOptions.Type[]{TransportRequestOptions.Type.BULK, TransportRequestOptions.Type.PING, TransportRequestOptions.Type.RECOVERY, TransportRequestOptions.Type.REG, TransportRequestOptions.Type.STATE});
            AbstractSimpleTransportTestCase.expectThrows(ConnectTransportException.class, () -> this.serviceA.openConnection(node, builder.build()));
        }
    }

    public void testHandshakeUpdatesVersion() throws IOException {
        AbstractSimpleTransportTestCase.assumeTrue((String)"only tcp transport has a handshake method", (boolean)(this.serviceA.getOriginalTransport() instanceof TcpTransport));
        Version version = VersionUtils.randomVersionBetween(AbstractSimpleTransportTestCase.random(), Version.CURRENT.minimumCompatibilityVersion(), Version.CURRENT);
        try (MockTransportService service = this.build(Settings.EMPTY, version, null, true);){
            service.start();
            service.acceptIncomingRequests();
            TransportAddress address = service.boundAddress().publishAddress();
            DiscoveryNode node = new DiscoveryNode("TS_TPC", "TS_TPC", address, Collections.emptyMap(), Collections.emptySet(), Version.fromString((String)"2.0.0"));
            ConnectionProfile.Builder builder = new ConnectionProfile.Builder();
            builder.addConnections(1, new TransportRequestOptions.Type[]{TransportRequestOptions.Type.BULK, TransportRequestOptions.Type.PING, TransportRequestOptions.Type.RECOVERY, TransportRequestOptions.Type.REG, TransportRequestOptions.Type.STATE});
            try (Transport.Connection connection = this.serviceA.openConnection(node, builder.build());){
                AbstractSimpleTransportTestCase.assertEquals((Object)connection.getVersion(), (Object)version);
            }
        }
    }

    public void testKeepAlivePings() throws Exception {
        AbstractSimpleTransportTestCase.assumeTrue((String)"only tcp transport has keep alive pings", (boolean)(this.serviceA.getOriginalTransport() instanceof TcpTransport));
        TcpTransport originalTransport = (TcpTransport)this.serviceA.getOriginalTransport();
        ConnectionProfile defaultProfile = ConnectionProfile.buildDefaultConnectionProfile((Settings)Settings.EMPTY);
        ConnectionProfile connectionProfile = new ConnectionProfile.Builder(defaultProfile).setPingInterval(TimeValue.timeValueMillis((long)50L)).build();
        try (MockTransportService service = this.buildService("TS_TPC", Version.CURRENT, null);){
            PlainActionFuture future = PlainActionFuture.newFuture();
            DiscoveryNode node = new DiscoveryNode("TS_TPC", "TS_TPC", service.boundAddress().publishAddress(), Collections.emptyMap(), Collections.emptySet(), version0);
            originalTransport.openConnection(node, connectionProfile, (ActionListener)future);
            try (Transport.Connection connection = (Transport.Connection)future.actionGet();){
                AbstractSimpleTransportTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> AbstractSimpleTransportTestCase.assertTrue((originalTransport.getKeepAlive().successfulPingCount() > 30L ? 1 : 0) != 0)));
                AbstractSimpleTransportTestCase.assertEquals((long)0L, (long)originalTransport.getKeepAlive().failedPingCount());
            }
        }
    }

    public void testTcpHandshake() {
        AbstractSimpleTransportTestCase.assumeTrue((String)"only tcp transport has a handshake method", (boolean)(this.serviceA.getOriginalTransport() instanceof TcpTransport));
        TcpTransport originalTransport = (TcpTransport)this.serviceA.getOriginalTransport();
        NamedWriteableRegistry namedWriteableRegistry = new NamedWriteableRegistry(Collections.emptyList());
        MockNioTransport transport = new MockNioTransport(Settings.EMPTY, Version.CURRENT, this.threadPool, new NetworkService(Collections.emptyList()), PageCacheRecycler.NON_RECYCLING_INSTANCE, namedWriteableRegistry, (CircuitBreakerService)new NoneCircuitBreakerService()){

            protected void handleRequest(TcpChannel channel, InboundMessage.RequestMessage request, int messageLengthBytes) throws IOException {
                byte status = (byte)(request.status & 0xFFFFFFF7);
                Version version = request.getVersion();
                InboundMessage.RequestMessage nonHandshakeRequest = new InboundMessage.RequestMessage(request.threadContext, version, status, request.getRequestId(), request.getActionName(), request.getFeatures(), request.getStreamInput());
                super.handleRequest(channel, nonHandshakeRequest, messageLengthBytes);
            }
        };
        try (MockTransportService service = MockTransportService.createNewService(Settings.EMPTY, (Transport)transport, Version.CURRENT, this.threadPool, null, Collections.emptySet());){
            service.start();
            service.acceptIncomingRequests();
            DiscoveryNode node = new DiscoveryNode("TS_TPC", "TS_TPC", transport.boundAddress().publishAddress(), Collections.emptyMap(), Collections.emptySet(), version0);
            ConnectTransportException exception = (ConnectTransportException)AbstractSimpleTransportTestCase.expectThrows(ConnectTransportException.class, () -> this.serviceA.connectToNode(node));
            AbstractSimpleTransportTestCase.assertTrue((boolean)(exception.getCause() instanceof IllegalStateException));
            AbstractSimpleTransportTestCase.assertEquals((Object)"handshake failed", (Object)exception.getCause().getMessage());
        }
        ConnectionProfile connectionProfile = ConnectionProfile.buildDefaultConnectionProfile((Settings)Settings.EMPTY);
        try (MockTransportService service = this.buildService("TS_TPC", Version.CURRENT, null);){
            DiscoveryNode node = new DiscoveryNode("TS_TPC", "TS_TPC", service.boundAddress().publishAddress(), Collections.emptyMap(), Collections.emptySet(), version0);
            PlainActionFuture future = PlainActionFuture.newFuture();
            originalTransport.openConnection(node, connectionProfile, (ActionListener)future);
            try (Transport.Connection connection = (Transport.Connection)future.actionGet();){
                AbstractSimpleTransportTestCase.assertEquals((Object)connection.getVersion(), (Object)Version.CURRENT);
            }
        }
    }

    public void testTcpHandshakeTimeout() throws IOException {
        try (MockServerSocket socket = new MockServerSocket();){
            socket.bind(this.getLocalEphemeral(), 1);
            socket.setReuseAddress(true);
            DiscoveryNode dummy = new DiscoveryNode("TEST", new TransportAddress(socket.getInetAddress(), socket.getLocalPort()), Collections.emptyMap(), Collections.emptySet(), version0);
            ConnectionProfile.Builder builder = new ConnectionProfile.Builder();
            builder.addConnections(1, new TransportRequestOptions.Type[]{TransportRequestOptions.Type.BULK, TransportRequestOptions.Type.PING, TransportRequestOptions.Type.RECOVERY, TransportRequestOptions.Type.REG, TransportRequestOptions.Type.STATE});
            builder.setHandshakeTimeout(TimeValue.timeValueMillis((long)1L));
            ConnectTransportException ex = (ConnectTransportException)AbstractSimpleTransportTestCase.expectThrows(ConnectTransportException.class, () -> this.serviceA.connectToNode(dummy, builder.build()));
            AbstractSimpleTransportTestCase.assertEquals((Object)("[][" + dummy.getAddress() + "] handshake_timeout[1ms]"), (Object)ex.getMessage());
        }
    }

    public void testTcpHandshakeConnectionReset() throws IOException, InterruptedException {
        try (MockServerSocket socket = new MockServerSocket();){
            socket.bind(this.getLocalEphemeral(), 1);
            socket.setReuseAddress(true);
            DiscoveryNode dummy = new DiscoveryNode("TEST", new TransportAddress(socket.getInetAddress(), socket.getLocalPort()), Collections.emptyMap(), Collections.emptySet(), version0);
            Thread t = new Thread((ServerSocket)socket){
                final /* synthetic */ ServerSocket val$socket;
                {
                    this.val$socket = serverSocket;
                }

                @Override
                public void run() {
                    try (Socket accept = this.val$socket.accept();){
                        if (ESTestCase.randomBoolean()) {
                            accept.getInputStream().read();
                        }
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            };
            t.start();
            ConnectionProfile.Builder builder = new ConnectionProfile.Builder();
            builder.addConnections(1, new TransportRequestOptions.Type[]{TransportRequestOptions.Type.BULK, TransportRequestOptions.Type.PING, TransportRequestOptions.Type.RECOVERY, TransportRequestOptions.Type.REG, TransportRequestOptions.Type.STATE});
            builder.setHandshakeTimeout(TimeValue.timeValueHours((long)1L));
            ConnectTransportException ex = (ConnectTransportException)AbstractSimpleTransportTestCase.expectThrows(ConnectTransportException.class, () -> this.serviceA.connectToNode(dummy, builder.build()));
            AbstractSimpleTransportTestCase.assertEquals((Object)ex.getMessage(), (Object)("[][" + dummy.getAddress() + "] general node connection failure"));
            AbstractSimpleTransportTestCase.assertThat((Object)ex.getCause().getMessage(), (Matcher)Matchers.startsWith((String)"handshake failed"));
            t.join();
        }
    }

    public void testResponseHeadersArePreserved() throws InterruptedException {
        final ArrayList executors = new ArrayList(ThreadPool.THREAD_POOL_TYPES.keySet());
        CollectionUtil.timSort(executors);
        this.serviceA.registerRequestHandler("internal:action", TestRequest::new, "same", (request, channel, task) -> {
            this.threadPool.getThreadContext().putTransient("boom", new Object());
            this.threadPool.getThreadContext().addResponseHeader("foo.bar", "baz");
            if ("fail".equals(request.info)) {
                throw new RuntimeException("boom");
            }
            channel.sendResponse((TransportResponse)TransportResponse.Empty.INSTANCE);
        });
        final CountDownLatch latch = new CountDownLatch(2);
        TransportResponseHandler<TransportResponse> transportResponseHandler = new TransportResponseHandler<TransportResponse>(){

            public TransportResponse read(StreamInput in) {
                return TransportResponse.Empty.INSTANCE;
            }

            public void handleResponse(TransportResponse response) {
                try {
                    Assert.assertSame((Object)response, (Object)TransportResponse.Empty.INSTANCE);
                    Assert.assertTrue((boolean)AbstractSimpleTransportTestCase.this.threadPool.getThreadContext().getResponseHeaders().containsKey("foo.bar"));
                    Assert.assertEquals((long)1L, (long)((List)AbstractSimpleTransportTestCase.this.threadPool.getThreadContext().getResponseHeaders().get("foo.bar")).size());
                    Assert.assertEquals((Object)"baz", ((List)AbstractSimpleTransportTestCase.this.threadPool.getThreadContext().getResponseHeaders().get("foo.bar")).get(0));
                    Assert.assertNull((Object)AbstractSimpleTransportTestCase.this.threadPool.getThreadContext().getTransient("boom"));
                }
                finally {
                    latch.countDown();
                }
            }

            public void handleException(TransportException exp) {
                try {
                    Assert.assertTrue((boolean)AbstractSimpleTransportTestCase.this.threadPool.getThreadContext().getResponseHeaders().containsKey("foo.bar"));
                    Assert.assertEquals((long)1L, (long)((List)AbstractSimpleTransportTestCase.this.threadPool.getThreadContext().getResponseHeaders().get("foo.bar")).size());
                    Assert.assertEquals((Object)"baz", ((List)AbstractSimpleTransportTestCase.this.threadPool.getThreadContext().getResponseHeaders().get("foo.bar")).get(0));
                    Assert.assertNull((Object)AbstractSimpleTransportTestCase.this.threadPool.getThreadContext().getTransient("boom"));
                }
                finally {
                    latch.countDown();
                }
            }

            public String executor() {
                return (String)ESTestCase.randomFrom(executors);
            }
        };
        this.serviceB.sendRequest(this.nodeA, "internal:action", new TestRequest(AbstractSimpleTransportTestCase.randomFrom("fail", "pass")), (TransportResponseHandler)transportResponseHandler);
        this.serviceA.sendRequest(this.nodeA, "internal:action", new TestRequest(AbstractSimpleTransportTestCase.randomFrom("fail", "pass")), (TransportResponseHandler)transportResponseHandler);
        latch.await();
    }

    public void testHandlerIsInvokedOnConnectionClose() throws IOException, InterruptedException {
        final ArrayList executors = new ArrayList(ThreadPool.THREAD_POOL_TYPES.keySet());
        CollectionUtil.timSort(executors);
        MockTransportService serviceC = this.build(Settings.builder().put("name", "TS_TEST").build(), version0, null, true);
        serviceC.registerRequestHandler("internal:action", TestRequest::new, "same", (request, channel, task) -> {});
        serviceC.start();
        serviceC.acceptIncomingRequests();
        final CountDownLatch latch = new CountDownLatch(1);
        TransportResponseHandler<TransportResponse> transportResponseHandler = new TransportResponseHandler<TransportResponse>(){

            public TransportResponse read(StreamInput in) {
                return TransportResponse.Empty.INSTANCE;
            }

            public void handleResponse(TransportResponse response) {
                try {
                    Assert.fail((String)"no response expected");
                }
                finally {
                    latch.countDown();
                }
            }

            public void handleException(TransportException exp) {
                try {
                    if (exp instanceof SendRequestTransportException) {
                        Assert.assertTrue((String)exp.getCause().getClass().toString(), (boolean)(exp.getCause() instanceof NodeNotConnectedException));
                    } else {
                        Assert.assertTrue((String)exp.getClass().toString(), (boolean)(exp instanceof NodeDisconnectedException));
                    }
                }
                finally {
                    latch.countDown();
                }
            }

            public String executor() {
                return (String)ESTestCase.randomFrom(executors);
            }
        };
        ConnectionProfile.Builder builder = new ConnectionProfile.Builder();
        builder.addConnections(1, new TransportRequestOptions.Type[]{TransportRequestOptions.Type.BULK, TransportRequestOptions.Type.PING, TransportRequestOptions.Type.RECOVERY, TransportRequestOptions.Type.REG, TransportRequestOptions.Type.STATE});
        try (Transport.Connection connection = this.serviceB.openConnection(serviceC.getLocalNode(), builder.build());){
            serviceC.close();
            this.serviceB.sendRequest(connection, "internal:action", new TestRequest("boom"), TransportRequestOptions.EMPTY, (TransportResponseHandler)transportResponseHandler);
        }
        latch.await();
    }

    public void testConcurrentDisconnectOnNonPublishedConnection() throws IOException, InterruptedException {
        MockTransportService serviceC = this.build(Settings.builder().put("name", "TS_TEST").build(), version0, null, true);
        final CountDownLatch receivedLatch = new CountDownLatch(1);
        final CountDownLatch sendResponseLatch = new CountDownLatch(1);
        serviceC.registerRequestHandler("internal:action", TestRequest::new, "same", (request, channel, task) -> this.threadPool.generic().execute((Runnable)new AbstractRunnable(){

            public void onFailure(Exception e) {
                try {
                    channel.sendResponse(e);
                }
                catch (IOException e1) {
                    throw new UncheckedIOException(e1);
                }
            }

            protected void doRun() throws Exception {
                receivedLatch.countDown();
                sendResponseLatch.await();
                channel.sendResponse((TransportResponse)TransportResponse.Empty.INSTANCE);
            }
        }));
        serviceC.start();
        serviceC.acceptIncomingRequests();
        final CountDownLatch responseLatch = new CountDownLatch(1);
        TransportResponseHandler<TransportResponse> transportResponseHandler = new TransportResponseHandler<TransportResponse>(){

            public TransportResponse read(StreamInput in) {
                return TransportResponse.Empty.INSTANCE;
            }

            public void handleResponse(TransportResponse response) {
                responseLatch.countDown();
            }

            public void handleException(TransportException exp) {
                responseLatch.countDown();
            }

            public String executor() {
                return "same";
            }
        };
        ConnectionProfile.Builder builder = new ConnectionProfile.Builder();
        builder.addConnections(1, new TransportRequestOptions.Type[]{TransportRequestOptions.Type.BULK, TransportRequestOptions.Type.PING, TransportRequestOptions.Type.RECOVERY, TransportRequestOptions.Type.REG, TransportRequestOptions.Type.STATE});
        try (Transport.Connection connection = this.serviceB.openConnection(serviceC.getLocalNode(), builder.build());){
            this.serviceB.sendRequest(connection, "internal:action", new TestRequest("hello world"), TransportRequestOptions.EMPTY, (TransportResponseHandler)transportResponseHandler);
            receivedLatch.await();
            serviceC.close();
            sendResponseLatch.countDown();
            responseLatch.await();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTransportStats() throws Exception {
        MockTransportService serviceC = this.build(Settings.builder().put("name", "TS_TEST").build(), version0, null, true);
        final CountDownLatch receivedLatch = new CountDownLatch(1);
        final CountDownLatch sendResponseLatch = new CountDownLatch(1);
        this.serviceB.registerRequestHandler("internal:action", TestRequest::new, "same", (request, channel, task) -> this.threadPool.generic().execute((Runnable)new AbstractRunnable(){

            public void onFailure(Exception e) {
                try {
                    channel.sendResponse(e);
                }
                catch (IOException e1) {
                    throw new UncheckedIOException(e1);
                }
            }

            protected void doRun() throws Exception {
                receivedLatch.countDown();
                sendResponseLatch.await();
                channel.sendResponse((TransportResponse)TransportResponse.Empty.INSTANCE);
            }
        }));
        serviceC.start();
        serviceC.acceptIncomingRequests();
        final CountDownLatch responseLatch = new CountDownLatch(1);
        TransportResponseHandler<TransportResponse> transportResponseHandler = new TransportResponseHandler<TransportResponse>(){

            public TransportResponse read(StreamInput in) {
                return TransportResponse.Empty.INSTANCE;
            }

            public void handleResponse(TransportResponse response) {
                responseLatch.countDown();
            }

            public void handleException(TransportException exp) {
                responseLatch.countDown();
            }

            public String executor() {
                return "same";
            }
        };
        TransportStats stats = serviceC.transport.getStats();
        AbstractSimpleTransportTestCase.assertEquals((long)0L, (long)stats.getRxCount());
        AbstractSimpleTransportTestCase.assertEquals((long)0L, (long)stats.getTxCount());
        AbstractSimpleTransportTestCase.assertEquals((long)0L, (long)stats.getRxSize().getBytes());
        AbstractSimpleTransportTestCase.assertEquals((long)0L, (long)stats.getTxSize().getBytes());
        ConnectionProfile.Builder builder = new ConnectionProfile.Builder();
        builder.addConnections(1, new TransportRequestOptions.Type[]{TransportRequestOptions.Type.BULK, TransportRequestOptions.Type.PING, TransportRequestOptions.Type.RECOVERY, TransportRequestOptions.Type.REG, TransportRequestOptions.Type.STATE});
        try (Transport.Connection connection = serviceC.openConnection(this.serviceB.getLocalNode(), builder.build());){
            AbstractSimpleTransportTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
                TransportStats transportStats = serviceC.transport.getStats();
                AbstractSimpleTransportTestCase.assertEquals((long)1L, (long)transportStats.getRxCount());
                AbstractSimpleTransportTestCase.assertEquals((long)1L, (long)transportStats.getTxCount());
                AbstractSimpleTransportTestCase.assertEquals((long)25L, (long)transportStats.getRxSize().getBytes());
                AbstractSimpleTransportTestCase.assertEquals((long)50L, (long)transportStats.getTxSize().getBytes());
            }));
            serviceC.sendRequest(connection, "internal:action", new TestRequest("hello world"), TransportRequestOptions.EMPTY, (TransportResponseHandler)transportResponseHandler);
            receivedLatch.await();
            AbstractSimpleTransportTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
                TransportStats transportStats = serviceC.transport.getStats();
                AbstractSimpleTransportTestCase.assertEquals((long)1L, (long)transportStats.getRxCount());
                AbstractSimpleTransportTestCase.assertEquals((long)2L, (long)transportStats.getTxCount());
                AbstractSimpleTransportTestCase.assertEquals((long)25L, (long)transportStats.getRxSize().getBytes());
                AbstractSimpleTransportTestCase.assertEquals((long)106L, (long)transportStats.getTxSize().getBytes());
            }));
            sendResponseLatch.countDown();
            responseLatch.await();
            stats = serviceC.transport.getStats();
            AbstractSimpleTransportTestCase.assertEquals((long)2L, (long)stats.getRxCount());
            AbstractSimpleTransportTestCase.assertEquals((long)2L, (long)stats.getTxCount());
            AbstractSimpleTransportTestCase.assertEquals((long)46L, (long)stats.getRxSize().getBytes());
            AbstractSimpleTransportTestCase.assertEquals((long)106L, (long)stats.getTxSize().getBytes());
        }
        finally {
            serviceC.close();
        }
    }

    public void testAcceptedChannelCount() throws Exception {
        AbstractSimpleTransportTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            TransportStats transportStats = this.serviceA.transport.getStats();
            AbstractSimpleTransportTestCase.assertEquals((long)this.channelsPerNodeConnection(), (long)transportStats.getServerOpen());
        }));
        AbstractSimpleTransportTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            TransportStats transportStats = this.serviceB.transport.getStats();
            AbstractSimpleTransportTestCase.assertEquals((long)this.channelsPerNodeConnection(), (long)transportStats.getServerOpen());
        }));
        this.serviceA.close();
        AbstractSimpleTransportTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            TransportStats transportStats = this.serviceB.transport.getStats();
            AbstractSimpleTransportTestCase.assertEquals((long)0L, (long)transportStats.getServerOpen());
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTransportStatsWithException() throws Exception {
        MockTransportService serviceC = this.build(Settings.builder().put("name", "TS_TEST").build(), version0, null, true);
        final CountDownLatch receivedLatch = new CountDownLatch(1);
        final CountDownLatch sendResponseLatch = new CountDownLatch(1);
        final RuntimeException ex = new RuntimeException("boom");
        ex.setStackTrace(new StackTraceElement[0]);
        this.serviceB.registerRequestHandler("internal:action", TestRequest::new, "same", (request, channel, task) -> this.threadPool.generic().execute((Runnable)new AbstractRunnable(){

            public void onFailure(Exception e) {
                try {
                    channel.sendResponse(e);
                }
                catch (IOException e1) {
                    throw new UncheckedIOException(e1);
                }
            }

            protected void doRun() throws Exception {
                receivedLatch.countDown();
                sendResponseLatch.await();
                this.onFailure(ex);
            }
        }));
        serviceC.start();
        serviceC.acceptIncomingRequests();
        final CountDownLatch responseLatch = new CountDownLatch(1);
        final AtomicReference<Object> receivedException = new AtomicReference<Object>(null);
        TransportResponseHandler<TransportResponse> transportResponseHandler = new TransportResponseHandler<TransportResponse>(){

            public TransportResponse read(StreamInput in) {
                return TransportResponse.Empty.INSTANCE;
            }

            public void handleResponse(TransportResponse response) {
                responseLatch.countDown();
            }

            public void handleException(TransportException exp) {
                receivedException.set(exp);
                responseLatch.countDown();
            }

            public String executor() {
                return "same";
            }
        };
        TransportStats stats = serviceC.transport.getStats();
        AbstractSimpleTransportTestCase.assertEquals((long)0L, (long)stats.getRxCount());
        AbstractSimpleTransportTestCase.assertEquals((long)0L, (long)stats.getTxCount());
        AbstractSimpleTransportTestCase.assertEquals((long)0L, (long)stats.getRxSize().getBytes());
        AbstractSimpleTransportTestCase.assertEquals((long)0L, (long)stats.getTxSize().getBytes());
        ConnectionProfile.Builder builder = new ConnectionProfile.Builder();
        builder.addConnections(1, new TransportRequestOptions.Type[]{TransportRequestOptions.Type.BULK, TransportRequestOptions.Type.PING, TransportRequestOptions.Type.RECOVERY, TransportRequestOptions.Type.REG, TransportRequestOptions.Type.STATE});
        try (Transport.Connection connection = serviceC.openConnection(this.serviceB.getLocalNode(), builder.build());){
            AbstractSimpleTransportTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
                TransportStats transportStats = serviceC.transport.getStats();
                AbstractSimpleTransportTestCase.assertEquals((long)1L, (long)transportStats.getRxCount());
                AbstractSimpleTransportTestCase.assertEquals((long)1L, (long)transportStats.getTxCount());
                AbstractSimpleTransportTestCase.assertEquals((long)25L, (long)transportStats.getRxSize().getBytes());
                AbstractSimpleTransportTestCase.assertEquals((long)50L, (long)transportStats.getTxSize().getBytes());
            }));
            serviceC.sendRequest(connection, "internal:action", new TestRequest("hello world"), TransportRequestOptions.EMPTY, (TransportResponseHandler)transportResponseHandler);
            receivedLatch.await();
            AbstractSimpleTransportTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
                TransportStats transportStats = serviceC.transport.getStats();
                AbstractSimpleTransportTestCase.assertEquals((long)1L, (long)transportStats.getRxCount());
                AbstractSimpleTransportTestCase.assertEquals((long)2L, (long)transportStats.getTxCount());
                AbstractSimpleTransportTestCase.assertEquals((long)25L, (long)transportStats.getRxSize().getBytes());
                AbstractSimpleTransportTestCase.assertEquals((long)106L, (long)transportStats.getTxSize().getBytes());
            }));
            sendResponseLatch.countDown();
            responseLatch.await();
            stats = serviceC.transport.getStats();
            AbstractSimpleTransportTestCase.assertEquals((long)2L, (long)stats.getRxCount());
            AbstractSimpleTransportTestCase.assertEquals((long)2L, (long)stats.getTxCount());
            TransportException exception = receivedException.get();
            AbstractSimpleTransportTestCase.assertNotNull((Object)((Object)exception));
            BytesStreamOutput streamOutput = new BytesStreamOutput();
            exception.writeTo((StreamOutput)streamOutput);
            String failedMessage = "Unexpected read bytes size. The transport exception that was received=" + (Object)((Object)exception);
            AbstractSimpleTransportTestCase.assertEquals((String)failedMessage, (long)(49 + streamOutput.bytes().length()), (long)stats.getRxSize().getBytes());
            AbstractSimpleTransportTestCase.assertEquals((long)106L, (long)stats.getTxSize().getBytes());
        }
        finally {
            serviceC.close();
        }
    }

    public void testTransportProfilesWithPortAndHost() {
        boolean doIPV6 = NetworkUtils.SUPPORTS_V6;
        List<String> hosts = doIPV6 ? Arrays.asList("_local:ipv6_", "_local:ipv4_") : Arrays.asList("_local:ipv4_");
        try (MockTransportService serviceC = this.build(Settings.builder().put("name", "TS_TEST").put("transport.profiles.default.bind_host", "_local:ipv4_").put("transport.profiles.some_profile.port", "8900-9000").put("transport.profiles.some_profile.bind_host", "_local:ipv4_").put("transport.profiles.some_other_profile.port", "8700-8800").putList("transport.profiles.some_other_profile.bind_host", hosts).putList("transport.profiles.some_other_profile.publish_host", new String[]{"_local:ipv4_"}).build(), version0, null, true);){
            serviceC.start();
            serviceC.acceptIncomingRequests();
            Map profileBoundAddresses = serviceC.transport.profileBoundAddresses();
            AbstractSimpleTransportTestCase.assertTrue((boolean)profileBoundAddresses.containsKey("some_profile"));
            AbstractSimpleTransportTestCase.assertTrue((boolean)profileBoundAddresses.containsKey("some_other_profile"));
            AbstractSimpleTransportTestCase.assertTrue((((BoundTransportAddress)profileBoundAddresses.get("some_profile")).publishAddress().getPort() >= 8900 ? 1 : 0) != 0);
            AbstractSimpleTransportTestCase.assertTrue((((BoundTransportAddress)profileBoundAddresses.get("some_profile")).publishAddress().getPort() < 9000 ? 1 : 0) != 0);
            AbstractSimpleTransportTestCase.assertTrue((((BoundTransportAddress)profileBoundAddresses.get("some_other_profile")).publishAddress().getPort() >= 8700 ? 1 : 0) != 0);
            AbstractSimpleTransportTestCase.assertTrue((((BoundTransportAddress)profileBoundAddresses.get("some_other_profile")).publishAddress().getPort() < 8800 ? 1 : 0) != 0);
            AbstractSimpleTransportTestCase.assertEquals((long)((BoundTransportAddress)profileBoundAddresses.get("some_profile")).boundAddresses().length, (long)1L);
            if (doIPV6) {
                AbstractSimpleTransportTestCase.assertTrue((((BoundTransportAddress)profileBoundAddresses.get("some_other_profile")).boundAddresses().length >= 2 ? 1 : 0) != 0);
                int ipv4 = 0;
                int ipv6 = 0;
                for (TransportAddress addr : ((BoundTransportAddress)profileBoundAddresses.get("some_other_profile")).boundAddresses()) {
                    if (addr.address().getAddress() instanceof Inet4Address) {
                        ++ipv4;
                        continue;
                    }
                    if (addr.address().getAddress() instanceof Inet6Address) {
                        ++ipv6;
                        continue;
                    }
                    AbstractSimpleTransportTestCase.fail((String)("what kind of address is this: " + addr.address().getAddress()));
                }
                AbstractSimpleTransportTestCase.assertTrue((String)("num ipv4 is wrong: " + ipv4), (ipv4 >= 1 ? 1 : 0) != 0);
                AbstractSimpleTransportTestCase.assertTrue((String)("num ipv6 is wrong: " + ipv6), (ipv6 >= 1 ? 1 : 0) != 0);
            } else {
                AbstractSimpleTransportTestCase.assertEquals((long)((BoundTransportAddress)profileBoundAddresses.get("some_other_profile")).boundAddresses().length, (long)1L);
            }
            AbstractSimpleTransportTestCase.assertTrue((boolean)(((BoundTransportAddress)profileBoundAddresses.get("some_other_profile")).publishAddress().address().getAddress() instanceof Inet4Address));
        }
    }

    public void testProfileSettings() {
        boolean enable = AbstractSimpleTransportTestCase.randomBoolean();
        Settings globalSettings = Settings.builder().put("network.tcp.no_delay", enable).put("network.tcp.keep_alive", enable).put("network.tcp.reuse_address", enable).put("network.tcp.send_buffer_size", "43000b").put("network.tcp.receive_buffer_size", "42000b").put("network.publish_host", "the_publish_host").put("network.bind_host", "the_bind_host").build();
        Settings globalSettings2 = Settings.builder().put("network.tcp.no_delay", !enable).put("network.tcp.keep_alive", !enable).put("network.tcp.reuse_address", !enable).put("network.tcp.send_buffer_size", "4b").put("network.tcp.receive_buffer_size", "3b").put("network.publish_host", "another_publish_host").put("network.bind_host", "another_bind_host").build();
        Settings transportSettings = Settings.builder().put("transport.tcp.no_delay", enable).put("transport.tcp.keep_alive", enable).put("transport.tcp.reuse_address", enable).put("transport.tcp.send_buffer_size", "43000b").put("transport.tcp.receive_buffer_size", "42000b").put("transport.publish_host", "the_publish_host").put("transport.port", "9700-9800").put("transport.bind_host", "the_bind_host").put(globalSettings2).build();
        Settings transportSettings2 = Settings.builder().put("transport.tcp.no_delay", !enable).put("transport.tcp.keep_alive", !enable).put("transport.tcp.reuse_address", !enable).put("transport.tcp.send_buffer_size", "5b").put("transport.tcp.receive_buffer_size", "6b").put("transport.publish_host", "another_publish_host").put("transport.port", "9702-9802").put("transport.bind_host", "another_bind_host").put(globalSettings2).build();
        Settings defaultProfileSettings = Settings.builder().put("transport.profiles.default.tcp.no_delay", enable).put("transport.profiles.default.tcp.keep_alive", enable).put("transport.profiles.default.reuse_address", enable).put("transport.profiles.default.tcp.send_buffer_size", "43000b").put("transport.profiles.default.tcp.receive_buffer_size", "42000b").put("transport.profiles.default.port", "9700-9800").put("transport.profiles.default.publish_host", "the_publish_host").put("transport.profiles.default.bind_host", "the_bind_host").put("transport.profiles.default.publish_port", 42).put(AbstractSimpleTransportTestCase.randomBoolean() ? transportSettings2 : globalSettings2).build();
        Settings profileSettings = Settings.builder().put("transport.profiles.some_profile.tcp.no_delay", enable).put("transport.profiles.some_profile.tcp.keep_alive", enable).put("transport.profiles.some_profile.reuse_address", enable).put("transport.profiles.some_profile.tcp.send_buffer_size", "43000b").put("transport.profiles.some_profile.tcp.receive_buffer_size", "42000b").put("transport.profiles.some_profile.port", "9700-9800").put("transport.profiles.some_profile.publish_host", "the_publish_host").put("transport.profiles.some_profile.bind_host", "the_bind_host").put("transport.profiles.some_profile.publish_port", 42).put(AbstractSimpleTransportTestCase.randomBoolean() ? transportSettings2 : globalSettings2).put(AbstractSimpleTransportTestCase.randomBoolean() ? defaultProfileSettings : Settings.EMPTY).build();
        Settings randomSettings = AbstractSimpleTransportTestCase.randomFrom(AbstractSimpleTransportTestCase.random(), new Settings[]{globalSettings, transportSettings, profileSettings});
        ClusterSettings clusterSettings = new ClusterSettings(randomSettings, ClusterSettings.BUILT_IN_CLUSTER_SETTINGS);
        clusterSettings.validate(randomSettings, false);
        TcpTransport.ProfileSettings settings = new TcpTransport.ProfileSettings(Settings.builder().put(randomSettings).put("transport.profiles.some_profile.port", "9700-9800").build(), "some_profile");
        AbstractSimpleTransportTestCase.assertEquals((Object)enable, (Object)settings.tcpNoDelay);
        AbstractSimpleTransportTestCase.assertEquals((Object)enable, (Object)settings.tcpKeepAlive);
        AbstractSimpleTransportTestCase.assertEquals((Object)enable, (Object)settings.reuseAddress);
        AbstractSimpleTransportTestCase.assertEquals((long)43000L, (long)settings.sendBufferSize.getBytes());
        AbstractSimpleTransportTestCase.assertEquals((long)42000L, (long)settings.receiveBufferSize.getBytes());
        if (randomSettings == profileSettings) {
            AbstractSimpleTransportTestCase.assertEquals((long)42L, (long)settings.publishPort);
        } else {
            AbstractSimpleTransportTestCase.assertEquals((long)-1L, (long)settings.publishPort);
        }
        if (randomSettings == globalSettings) {
            AbstractSimpleTransportTestCase.assertEquals(Collections.emptyList(), (Object)settings.publishHosts);
        } else {
            AbstractSimpleTransportTestCase.assertEquals(Collections.singletonList("the_publish_host"), (Object)settings.publishHosts);
        }
        AbstractSimpleTransportTestCase.assertEquals((Object)"9700-9800", (Object)settings.portOrRange);
        AbstractSimpleTransportTestCase.assertEquals(Collections.singletonList("the_bind_host"), (Object)settings.bindHosts);
    }

    public void testProfilesIncludesDefault() {
        Set profileSettings = TcpTransport.getProfileSettings((Settings)Settings.EMPTY);
        AbstractSimpleTransportTestCase.assertEquals((long)1L, (long)profileSettings.size());
        AbstractSimpleTransportTestCase.assertEquals((Object)"default", (Object)((TcpTransport.ProfileSettings)profileSettings.stream().findAny().get()).profileName);
        profileSettings = TcpTransport.getProfileSettings((Settings)Settings.builder().put("transport.profiles.test.port", "0").build());
        AbstractSimpleTransportTestCase.assertEquals((long)2L, (long)profileSettings.size());
        AbstractSimpleTransportTestCase.assertEquals(new HashSet<String>(Arrays.asList("default", "test")), profileSettings.stream().map(s -> s.profileName).collect(Collectors.toSet()));
        profileSettings = TcpTransport.getProfileSettings((Settings)Settings.builder().put("transport.profiles.test.port", "0").put("transport.profiles.default.port", "0").build());
        AbstractSimpleTransportTestCase.assertEquals((long)2L, (long)profileSettings.size());
        AbstractSimpleTransportTestCase.assertEquals(new HashSet<String>(Arrays.asList("default", "test")), profileSettings.stream().map(s -> s.profileName).collect(Collectors.toSet()));
    }

    public void testChannelCloseWhileConnecting() {
        try (MockTransportService service = this.build(Settings.builder().put("name", "close").build(), version0, null, true);){
            final AtomicBoolean connectionClosedListenerCalled = new AtomicBoolean(false);
            service.addConnectionListener(new TransportConnectionListener(){

                public void onConnectionOpened(Transport.Connection connection) {
                    AbstractSimpleTransportTestCase.this.closeConnectionChannel(connection);
                    try {
                        ESTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> Assert.assertTrue((boolean)connection.isClosed())));
                    }
                    catch (Exception e) {
                        throw new AssertionError((Object)e);
                    }
                }

                public void onConnectionClosed(Transport.Connection connection) {
                    connectionClosedListenerCalled.set(true);
                }
            });
            ConnectionProfile.Builder builder = new ConnectionProfile.Builder();
            builder.addConnections(1, new TransportRequestOptions.Type[]{TransportRequestOptions.Type.BULK, TransportRequestOptions.Type.PING, TransportRequestOptions.Type.RECOVERY, TransportRequestOptions.Type.REG, TransportRequestOptions.Type.STATE});
            ConnectTransportException e = (ConnectTransportException)AbstractSimpleTransportTestCase.expectThrows(ConnectTransportException.class, () -> service.openConnection(this.nodeA, builder.build()));
            AbstractSimpleTransportTestCase.assertThat((Object)((Object)e), (Matcher)Matchers.hasToString((Matcher)Matchers.containsString((String)"a channel closed while connecting")));
            AbstractSimpleTransportTestCase.assertTrue((boolean)connectionClosedListenerCalled.get());
        }
    }

    private void closeConnectionChannel(Transport.Connection connection) {
        StubbableTransport.WrappedConnection wrappedConnection = (StubbableTransport.WrappedConnection)connection;
        TcpTransport.NodeChannels channels = (TcpTransport.NodeChannels)wrappedConnection.getConnection();
        CloseableChannel.closeChannels(channels.getChannels().subList(0, AbstractSimpleTransportTestCase.randomIntBetween(1, channels.getChannels().size())), (boolean)true);
    }

    @SuppressForbidden(reason="need local ephemeral port")
    protected InetSocketAddress getLocalEphemeral() throws UnknownHostException {
        return new InetSocketAddress(InetAddress.getLocalHost(), 0);
    }

    private static class TestResponse
    extends TransportResponse {
        final String info;

        TestResponse(StreamInput in) throws IOException {
            this.info = in.readOptionalString();
        }

        TestResponse(String info) {
            this.info = info;
        }

        public void readFrom(StreamInput in) throws IOException {
            throw new UnsupportedOperationException("usage of Streamable is to be replaced by Writeable");
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeOptionalString(this.info);
        }

        public String toString() {
            return "TestResponse{info='" + this.info + '\'' + '}';
        }
    }

    public static class TestRequest
    extends TransportRequest {
        String info;
        int resendCount;

        public TestRequest() {
        }

        public TestRequest(String info) {
            this.info = info;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.info = in.readOptionalString();
            this.resendCount = in.readInt();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeOptionalString(this.info);
            out.writeInt(this.resendCount);
        }

        public String toString() {
            return "TestRequest{info='" + this.info + '\'' + '}';
        }
    }

    static class Version1Response
    extends Version0Response {
        final int value2;

        Version1Response(int value1, int value2) {
            super(value1);
            this.value2 = value2;
        }

        Version1Response(StreamInput in) throws IOException {
            super(in);
            this.value2 = in.getVersion().onOrAfter(version1) ? in.readInt() : 0;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            throw new UnsupportedOperationException("usage of Streamable is to be replaced by Writeable");
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            if (out.getVersion().onOrAfter(version1)) {
                out.writeInt(this.value2);
            }
        }
    }

    static class Version0Response
    extends TransportResponse {
        final int value1;

        Version0Response(int value1) {
            this.value1 = value1;
        }

        Version0Response(StreamInput in) throws IOException {
            this.value1 = in.readInt();
        }

        public void readFrom(StreamInput in) throws IOException {
            throw new UnsupportedOperationException("usage of Streamable is to be replaced by Writeable");
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeInt(this.value1);
        }
    }

    public static class Version1Request
    extends Version0Request {
        int value2;

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            if (in.getVersion().onOrAfter(version1)) {
                this.value2 = in.readInt();
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            if (out.getVersion().onOrAfter(version1)) {
                out.writeInt(this.value2);
            }
        }
    }

    public static class Version0Request
    extends TransportRequest {
        int value1;

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.value1 = in.readInt();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeInt(this.value1);
        }
    }

    static class StringMessageResponse
    extends TransportResponse {
        private final String message;

        StringMessageResponse(String message) {
            this.message = message;
        }

        StringMessageResponse(StreamInput in) throws IOException {
            this.message = in.readString();
        }

        public void readFrom(StreamInput in) throws IOException {
            throw new UnsupportedOperationException("usage of Streamable is to be replaced by Writeable");
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.message);
        }
    }

    public static class StringMessageRequest
    extends TransportRequest {
        private String message;
        private long timeout;

        StringMessageRequest(String message, long timeout) {
            this.message = message;
            this.timeout = timeout;
        }

        public StringMessageRequest() {
        }

        public StringMessageRequest(String message) {
            this(message, -1L);
        }

        public long timeout() {
            return this.timeout;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.message = in.readString();
            this.timeout = in.readLong();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.message);
            out.writeLong(this.timeout);
        }
    }

    private static class Tracer
    extends MockTransportService.Tracer {
        private final Set<String> actions;
        public volatile boolean sawRequestSent;
        public volatile boolean sawRequestReceived;
        public volatile boolean sawResponseSent;
        public volatile boolean sawErrorSent;
        public volatile boolean sawResponseReceived;
        public AtomicReference<CountDownLatch> expectedEvents = new AtomicReference();

        Tracer(Set<String> actions) {
            this.actions = actions;
        }

        @Override
        public void receivedRequest(long requestId, String action) {
            super.receivedRequest(requestId, action);
            if (this.actions.contains(action)) {
                this.sawRequestReceived = true;
                this.expectedEvents.get().countDown();
            }
        }

        @Override
        public void requestSent(DiscoveryNode node, long requestId, String action, TransportRequestOptions options) {
            super.requestSent(node, requestId, action, options);
            if (this.actions.contains(action)) {
                this.sawRequestSent = true;
                this.expectedEvents.get().countDown();
            }
        }

        @Override
        public void responseSent(long requestId, String action) {
            super.responseSent(requestId, action);
            if (this.actions.contains(action)) {
                this.sawResponseSent = true;
                this.expectedEvents.get().countDown();
            }
        }

        @Override
        public void responseSent(long requestId, String action, Throwable t) {
            super.responseSent(requestId, action, t);
            if (this.actions.contains(action)) {
                this.sawErrorSent = true;
                this.expectedEvents.get().countDown();
            }
        }

        @Override
        public void receivedResponse(long requestId, DiscoveryNode sourceNode, String action) {
            super.receivedResponse(requestId, sourceNode, action);
            if (this.actions.contains(action)) {
                this.sawResponseReceived = true;
                this.expectedEvents.get().countDown();
            }
        }

        public void reset(int expectedCount) {
            this.sawRequestSent = false;
            this.sawRequestReceived = false;
            this.sawResponseSent = false;
            this.sawErrorSent = false;
            this.sawResponseReceived = false;
            this.expectedEvents.set(new CountDownLatch(expectedCount));
        }
    }
}

