/*
 * Decompiled with CFR 0.152.
 */
package org.eluder.coveralls.maven.plugin.domain;

import java.util.Date;
import java.util.Properties;
import org.eluder.coveralls.maven.plugin.domain.Git;
import org.eluder.coveralls.maven.plugin.validation.JobValidator;
import org.eluder.coveralls.maven.plugin.validation.ValidationErrors;

public class Job {
    private String repoToken;
    private String serviceName;
    private String serviceJobId;
    private String serviceBuildNumber;
    private String serviceBuildUrl;
    private Properties serviceEnvironment;
    private Date timestamp;
    private boolean dryRun;
    private String branch;
    private String pullRequest;
    private Git git;

    public Job withRepoToken(String repoToken) {
        this.repoToken = repoToken;
        return this;
    }

    public Job withServiceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    public Job withServiceJobId(String serviceJobId) {
        this.serviceJobId = serviceJobId;
        return this;
    }

    public Job withServiceBuildNumber(String serviceBuildNumber) {
        this.serviceBuildNumber = serviceBuildNumber;
        return this;
    }

    public Job withServiceBuildUrl(String serviceBuildUrl) {
        this.serviceBuildUrl = serviceBuildUrl;
        return this;
    }

    public Job withServiceEnvironment(Properties serviceEnvironment) {
        this.serviceEnvironment = serviceEnvironment;
        return this;
    }

    public Job withTimestamp(Date timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public Job withDryRun(boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    public Job withBranch(String branch) {
        this.branch = branch;
        return this;
    }

    public Job withPullRequest(String pullRequest) {
        this.pullRequest = pullRequest;
        return this;
    }

    public Job withGit(Git git) {
        this.git = git;
        return this;
    }

    public String getRepoToken() {
        return this.repoToken;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServiceJobId() {
        return this.serviceJobId;
    }

    public String getServiceBuildNumber() {
        return this.serviceBuildNumber;
    }

    public String getServiceBuildUrl() {
        return this.serviceBuildUrl;
    }

    public Properties getServiceEnvironment() {
        return this.serviceEnvironment;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public String getBranch() {
        if (this.branch != null && this.getGit() != null && this.getGit().getRemotes() != null) {
            for (Git.Remote remote : this.getGit().getRemotes()) {
                if (!this.branch.startsWith(remote.getName() + "/")) continue;
                return this.branch.substring(remote.getName().length() + 1);
            }
        }
        return this.branch;
    }

    public String getPullRequest() {
        return this.pullRequest;
    }

    public Git getGit() {
        return this.git;
    }

    public ValidationErrors validate() {
        JobValidator validator = new JobValidator(this);
        return validator.validate();
    }
}

