/*
 * Decompiled with CFR 0.152.
 */
package org.eluder.coveralls.maven.plugin.parser;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.eluder.coveralls.maven.plugin.CoverageParser;
import org.eluder.coveralls.maven.plugin.ProcessingException;
import org.eluder.coveralls.maven.plugin.domain.Source;
import org.eluder.coveralls.maven.plugin.source.SourceCallback;
import org.eluder.coveralls.maven.plugin.source.SourceLoader;

public abstract class AbstractXmlEventParser
implements CoverageParser {
    private final File coverageFile;
    private final SourceLoader sourceLoader;

    public AbstractXmlEventParser(File coverageFile, SourceLoader sourceLoader) {
        this.coverageFile = coverageFile;
        this.sourceLoader = sourceLoader;
    }

    @Override
    public final void parse(SourceCallback callback) throws ProcessingException, IOException {
        XmlStreamReader reader = ReaderFactory.newXmlReader((File)this.coverageFile);
        XMLStreamReader xml = this.createEventReader((Reader)reader);
        try {
            while (xml.hasNext()) {
                xml.next();
                this.onEvent(xml, callback);
            }
        }
        catch (XMLStreamException ex) {
            throw new ProcessingException(ex);
        }
        finally {
            this.close(xml);
            IOUtil.close((Reader)reader);
        }
    }

    @Override
    public final File getCoverageFile() {
        return this.coverageFile;
    }

    protected XMLStreamReader createEventReader(Reader reader) throws ProcessingException {
        try {
            XMLInputFactory xmlif = XMLInputFactory.newInstance();
            xmlif.setProperty("javax.xml.stream.supportDTD", false);
            xmlif.setProperty("javax.xml.stream.isNamespaceAware", false);
            xmlif.setProperty("javax.xml.stream.isValidating", false);
            return xmlif.createXMLStreamReader(reader);
        }
        catch (FactoryConfigurationError ex) {
            throw new IllegalArgumentException(ex);
        }
        catch (XMLStreamException ex) {
            throw new ProcessingException(ex);
        }
    }

    private void close(XMLStreamReader xml) throws ProcessingException {
        if (xml != null) {
            try {
                xml.close();
            }
            catch (XMLStreamException ex) {
                throw new ProcessingException(ex);
            }
        }
    }

    protected abstract void onEvent(XMLStreamReader var1, SourceCallback var2) throws XMLStreamException, ProcessingException, IOException;

    protected final Source loadSource(String sourceFile) throws IOException {
        return this.sourceLoader.load(sourceFile);
    }

    protected final boolean isStartElement(XMLStreamReader xml, String name) {
        return 1 == xml.getEventType() && xml.getLocalName().equals(name);
    }

    protected final boolean isEndElement(XMLStreamReader xml, String name) {
        return 2 == xml.getEventType() && xml.getLocalName().equals(name);
    }
}

