/*
 * Decompiled with CFR 0.152.
 */
package org.eluder.coveralls.maven.plugin.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.codehaus.plexus.util.StringUtils;
import org.eluder.coveralls.maven.plugin.ProcessingException;

public class TimestampParser {
    public static final String DEFAULT_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private final DateFormat format;

    public TimestampParser(String format) {
        try {
            this.format = StringUtils.isNotBlank((String)format) ? new SimpleDateFormat(format) : new SimpleDateFormat(DEFAULT_FORMAT);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Invalid timestamp format \"" + format + "\"", ex);
        }
    }

    public synchronized Date parse(String timestamp) throws ProcessingException {
        if (StringUtils.isBlank((String)timestamp)) {
            return null;
        }
        try {
            return this.format.parse(timestamp);
        }
        catch (ParseException ex) {
            throw new ProcessingException("Unable to parse timestamp \"" + timestamp + "\"", ex);
        }
    }
}

