/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.AbstractConnection;
import com.ericsson.otp.erlang.GenericQueue;
import com.ericsson.otp.erlang.OtpAuthException;
import com.ericsson.otp.erlang.OtpErlangAtom;
import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpErlangExit;
import com.ericsson.otp.erlang.OtpErlangList;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangPid;
import com.ericsson.otp.erlang.OtpErlangTuple;
import com.ericsson.otp.erlang.OtpInputStream;
import com.ericsson.otp.erlang.OtpLocalNode;
import com.ericsson.otp.erlang.OtpMsg;
import com.ericsson.otp.erlang.OtpOutputStream;
import com.ericsson.otp.erlang.OtpPeer;
import com.ericsson.otp.erlang.OtpSelf;
import java.io.IOException;
import java.net.Socket;

public class OtpConnection
extends AbstractConnection {
    protected OtpSelf self;
    protected GenericQueue queue;

    OtpConnection(OtpSelf self, Socket s) throws IOException, OtpAuthException {
        super((OtpLocalNode)self, s);
        this.self = self;
        this.queue = new GenericQueue();
        this.start();
    }

    OtpConnection(OtpSelf self, OtpPeer other) throws IOException, OtpAuthException {
        super((OtpLocalNode)self, other);
        this.self = self;
        this.queue = new GenericQueue();
        this.start();
    }

    public void deliver(Exception e) {
        this.queue.put(e);
    }

    public void deliver(OtpMsg msg) {
        this.queue.put(msg);
    }

    public OtpPeer peer() {
        return this.peer;
    }

    public OtpSelf self() {
        return this.self;
    }

    public int msgCount() {
        return this.queue.getCount();
    }

    public OtpErlangObject receive() throws IOException, OtpErlangExit, OtpAuthException {
        try {
            return this.receiveMsg().getMsg();
        }
        catch (OtpErlangDecodeException e) {
            this.close();
            throw new IOException(e.getMessage());
        }
    }

    public OtpErlangObject receive(long timeout) throws InterruptedException, IOException, OtpErlangExit, OtpAuthException {
        try {
            return this.receiveMsg(timeout).getMsg();
        }
        catch (OtpErlangDecodeException e) {
            this.close();
            throw new IOException(e.getMessage());
        }
    }

    public OtpInputStream receiveBuf() throws IOException, OtpErlangExit, OtpAuthException {
        return this.receiveMsg().getMsgBuf();
    }

    public OtpInputStream receiveBuf(long timeout) throws InterruptedException, IOException, OtpErlangExit, OtpAuthException {
        return this.receiveMsg(timeout).getMsgBuf();
    }

    public OtpMsg receiveMsg() throws IOException, OtpErlangExit, OtpAuthException {
        Object o = this.queue.get();
        if (o instanceof OtpMsg) {
            return (OtpMsg)o;
        }
        if (o instanceof IOException) {
            throw (IOException)o;
        }
        if (o instanceof OtpErlangExit) {
            throw (OtpErlangExit)o;
        }
        if (o instanceof OtpAuthException) {
            throw (OtpAuthException)o;
        }
        return null;
    }

    public OtpMsg receiveMsg(long timeout) throws InterruptedException, IOException, OtpErlangExit, OtpAuthException {
        Object o = this.queue.get(timeout);
        if (o instanceof OtpMsg) {
            return (OtpMsg)o;
        }
        if (o instanceof IOException) {
            throw (IOException)o;
        }
        if (o instanceof OtpErlangExit) {
            throw (OtpErlangExit)o;
        }
        if (o instanceof OtpAuthException) {
            throw (OtpAuthException)o;
        }
        return null;
    }

    public void send(OtpErlangPid dest, OtpErlangObject msg) throws IOException {
        super.sendBuf(this.self.pid(), dest, new OtpOutputStream(msg));
    }

    public void send(String dest, OtpErlangObject msg) throws IOException {
        super.sendBuf(this.self.pid(), dest, new OtpOutputStream(msg));
    }

    public void sendBuf(String dest, OtpOutputStream payload) throws IOException {
        super.sendBuf(this.self.pid(), dest, payload);
    }

    public void sendBuf(OtpErlangPid dest, OtpOutputStream payload) throws IOException {
        super.sendBuf(this.self.pid(), dest, payload);
    }

    public void sendRPC(String mod, String fun, OtpErlangObject[] args) throws IOException {
        this.sendRPC(mod, fun, new OtpErlangList(args));
    }

    public void sendRPC(String mod, String fun, OtpErlangList args) throws IOException {
        OtpErlangObject[] rpc = new OtpErlangObject[2];
        OtpErlangObject[] call = new OtpErlangObject[]{new OtpErlangAtom("call"), new OtpErlangAtom(mod), new OtpErlangAtom(fun), args, new OtpErlangAtom("user")};
        rpc[0] = this.self.pid();
        rpc[1] = new OtpErlangTuple(call);
        this.send("rex", (OtpErlangObject)new OtpErlangTuple(rpc));
    }

    public OtpErlangObject receiveRPC() throws IOException, OtpErlangExit, OtpAuthException {
        OtpErlangTuple t;
        OtpErlangObject msg = this.receive();
        if (msg instanceof OtpErlangTuple && (t = (OtpErlangTuple)msg).arity() == 2) {
            return t.elementAt(1);
        }
        return null;
    }

    public void link(OtpErlangPid dest) throws IOException {
        super.sendLink(this.self.pid(), dest);
    }

    public void unlink(OtpErlangPid dest) throws IOException {
        super.sendUnlink(this.self.pid(), dest);
    }

    public void exit(OtpErlangPid dest, OtpErlangObject reason) throws IOException {
        super.sendExit2(this.self.pid(), dest, reason);
    }
}

