/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangRangeException;
import com.ericsson.otp.erlang.OtpInputStream;
import com.ericsson.otp.erlang.OtpOutputStream;
import java.io.Serializable;
import java.math.BigInteger;

public class OtpErlangLong
extends OtpErlangObject
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1610466859236755096L;
    private long val;
    private BigInteger bigVal = null;

    public OtpErlangLong(long l) {
        this.val = l;
    }

    public OtpErlangLong(BigInteger v) {
        if (v == null) {
            throw new NullPointerException();
        }
        if (v.bitLength() < 64) {
            this.val = v.longValue();
        } else {
            this.bigVal = v;
        }
    }

    public OtpErlangLong(OtpInputStream buf) throws OtpErlangDecodeException {
        byte[] b = buf.read_integer_byte_array();
        try {
            this.val = OtpInputStream.byte_array_to_long(b, false);
        }
        catch (OtpErlangDecodeException e) {
            this.bigVal = new BigInteger(b);
        }
    }

    public BigInteger bigIntegerValue() {
        if (this.bigVal != null) {
            return this.bigVal;
        }
        return BigInteger.valueOf(this.val);
    }

    public long longValue() {
        if (this.bigVal != null) {
            return this.bigVal.longValue();
        }
        return this.val;
    }

    public boolean isLong() {
        if (this.bigVal != null) {
            return this.bigVal.bitLength() < 64;
        }
        return true;
    }

    public boolean isULong() {
        if (this.bigVal != null) {
            return this.bigVal.signum() >= 0 && this.bigVal.bitLength() <= 64;
        }
        return this.val >= 0L;
    }

    public int bitLength() {
        if (this.bigVal != null) {
            return this.bigVal.bitLength();
        }
        if (this.val == 0L || this.val == -1L) {
            return 0;
        }
        int i = 32;
        long m = (1L << i) - 1L;
        if (this.val < 0L) {
            m ^= 0xFFFFFFFFFFFFFFFFL;
            for (int j = i >> 1; j > 0; j >>= 1) {
                if ((this.val | m) == this.val) {
                    i -= j;
                    m >>= j;
                    continue;
                }
                i += j;
                m <<= j;
            }
            if ((this.val | m) != this.val) {
                ++i;
            }
        } else {
            for (int j = i >> 1; j > 0; j >>= 1) {
                if ((this.val & m) == this.val) {
                    i -= j;
                    m >>= j;
                    continue;
                }
                i += j;
                m = m << j | m;
            }
            if ((this.val & m) != this.val) {
                ++i;
            }
        }
        return i;
    }

    public int signum() {
        if (this.bigVal != null) {
            return this.bigVal.signum();
        }
        return this.val > 0L ? 1 : (this.val < 0L ? -1 : 0);
    }

    public int intValue() throws OtpErlangRangeException {
        long l = this.longValue();
        int i = (int)l;
        if ((long)i != l) {
            throw new OtpErlangRangeException("Value too large for int: " + this.val);
        }
        return i;
    }

    public int uIntValue() throws OtpErlangRangeException {
        long l = this.longValue();
        int i = (int)l;
        if ((long)i != l) {
            throw new OtpErlangRangeException("Value too large for int: " + this.val);
        }
        if (i < 0) {
            throw new OtpErlangRangeException("Value not positive: " + this.val);
        }
        return i;
    }

    public short shortValue() throws OtpErlangRangeException {
        long l = this.longValue();
        short i = (short)l;
        if ((long)i != l) {
            throw new OtpErlangRangeException("Value too large for short: " + this.val);
        }
        return i;
    }

    public short uShortValue() throws OtpErlangRangeException {
        long l = this.longValue();
        short i = (short)l;
        if ((long)i != l) {
            throw new OtpErlangRangeException("Value too large for short: " + this.val);
        }
        if (i < 0) {
            throw new OtpErlangRangeException("Value not positive: " + this.val);
        }
        return i;
    }

    public char charValue() throws OtpErlangRangeException {
        long l = this.longValue();
        char i = (char)l;
        if ((long)i != l) {
            throw new OtpErlangRangeException("Value too large for char: " + this.val);
        }
        return i;
    }

    public byte byteValue() throws OtpErlangRangeException {
        long l = this.longValue();
        byte i = (byte)l;
        if ((long)i != l) {
            throw new OtpErlangRangeException("Value too large for byte: " + this.val);
        }
        return i;
    }

    public String toString() {
        if (this.bigVal != null) {
            return "" + this.bigVal;
        }
        return "" + this.val;
    }

    public void encode(OtpOutputStream buf) {
        if (this.bigVal != null) {
            buf.write_big_integer(this.bigVal);
        } else {
            buf.write_long(this.val);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof OtpErlangLong)) {
            return false;
        }
        OtpErlangLong that = (OtpErlangLong)o;
        if (this.bigVal != null && that.bigVal != null) {
            return this.bigVal.equals(that.bigVal);
        }
        if (this.bigVal == null && that.bigVal == null) {
            return this.val == that.val;
        }
        return false;
    }

    protected int doHashCode() {
        if (this.bigVal != null) {
            return this.bigVal.hashCode();
        }
        return BigInteger.valueOf(this.val).hashCode();
    }
}

