/*
 * Decompiled with CFR 0.152.
 */
package org.everit.http.client;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import org.everit.http.client.MediaType;
import org.everit.http.client.Part;
import org.everit.http.client.async.AsyncContentProvider;
import org.everit.http.client.async.ByteArrayAsyncContentProvider;
import org.everit.http.client.async.ConcatenatedAsyncContentProvider;

public final class MultiPartAsyncContentProvider
extends ConcatenatedAsyncContentProvider {
    public static MultiPartAsyncContentProvider create(Optional<String> boundary, Part ... parts) {
        String finalBoundary = boundary.isPresent() ? boundary.get() : MultiPartAsyncContentProvider.makeBoundary();
        AsyncContentProvider[] contentProviders = MultiPartAsyncContentProvider.resolveContentProviders(parts, finalBoundary);
        return new MultiPartAsyncContentProvider(finalBoundary, contentProviders);
    }

    private static String makeBoundary() {
        Random random = new Random();
        StringBuilder builder = new StringBuilder("EveritHttpClientBoundary");
        int length = builder.length();
        int lengthOfStringRepresentationOfLong = 16;
        while (builder.length() < length + 16) {
            long rnd = random.nextLong();
            int radix = 36;
            builder.append(Long.toString(rnd < 0L ? -rnd : rnd, 36));
        }
        builder.setLength(length + 16);
        return builder.toString();
    }

    private static AsyncContentProvider[] resolveContentProviders(Part[] parts, String boundary) {
        Charset charset = StandardCharsets.US_ASCII;
        String onlyBoundaryLine = "--" + boundary + "--\r\n";
        if (parts.length == 0) {
            return new AsyncContentProvider[]{new ByteArrayAsyncContentProvider(onlyBoundaryLine.getBytes(charset), Optional.empty())};
        }
        ArrayList<AsyncContentProvider> result = new ArrayList<AsyncContentProvider>();
        String firstBoundaryLine = "--" + boundary + "\r\n";
        result.add(new ByteArrayAsyncContentProvider(firstBoundaryLine.getBytes(charset), Optional.empty()));
        int n = parts.length;
        for (int i = 0; i < n; ++i) {
            Part part = parts[i];
            result.add(new ByteArrayAsyncContentProvider(part.getHeaders().getBytes(StandardCharsets.UTF_8), Optional.empty()));
            result.add(part.getContent());
            if (i >= n - 1) continue;
            String middleBoundaryLine = "\r\n" + firstBoundaryLine;
            result.add(new ByteArrayAsyncContentProvider(middleBoundaryLine.getBytes(charset), Optional.empty()));
        }
        String lastBoundaryLine = "\r\n" + onlyBoundaryLine;
        result.add(new ByteArrayAsyncContentProvider(lastBoundaryLine.getBytes(charset), Optional.empty()));
        return result.toArray(new AsyncContentProvider[result.size()]);
    }

    private MultiPartAsyncContentProvider(String boundary, AsyncContentProvider ... contentProviders) {
        super(Optional.of(MediaType.parse("multipart/form-data; boundary=" + boundary)), contentProviders);
    }
}

