/*
 * Decompiled with CFR 0.152.
 */
package org.everit.http.client.async;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Consumer;
import org.everit.http.client.MediaType;
import org.everit.http.client.async.AsyncContentListener;
import org.everit.http.client.async.AsyncContentProvider;
import org.everit.http.client.async.ClosingProviderAutomaticallyException;

public class AutoCloseAsyncContentProvider
implements AsyncContentProvider {
    private final Closeable[] additionalCloseables;
    private final AsyncContentProvider wrapped;

    public AutoCloseAsyncContentProvider(AsyncContentProvider wrapped, Closeable ... additionalCloseables) {
        this.wrapped = wrapped;
        this.additionalCloseables = (Closeable[])additionalCloseables.clone();
    }

    @Override
    public void close() {
        ArrayList<Closeable> allCloseables = new ArrayList<Closeable>(this.additionalCloseables.length + 1);
        allCloseables.add(this.wrapped);
        allCloseables.addAll(Arrays.asList(this.additionalCloseables));
        Throwable error = null;
        for (Closeable closeable : allCloseables) {
            try {
                closeable.close();
            }
            catch (Throwable e) {
                if (error == null) {
                    error = e;
                    continue;
                }
                error.addSuppressed(e);
            }
        }
        if (error != null) {
            this.throwAsUnchecked(error);
        }
        this.wrapped.close();
    }

    @Override
    public Optional<Long> getContentLength() {
        return this.wrapped.getContentLength();
    }

    @Override
    public Optional<MediaType> getContentType() {
        return this.wrapped.getContentType();
    }

    @Override
    public Optional<Throwable> getFailure() {
        return this.wrapped.getFailure();
    }

    @Override
    public boolean isClosed() {
        return this.wrapped.isClosed();
    }

    @Override
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_NO_SIDE_EFFECT"})
    public AsyncContentProvider onContent(AsyncContentListener listener) {
        this.wrapped.onContent(listener);
        return this;
    }

    @Override
    public AsyncContentProvider onError(Consumer<Throwable> action) {
        this.wrapped.onError(error -> {
            boolean alreadyClosed = error instanceof ClosingProviderAutomaticallyException;
            Throwable newError = null;
            try {
                action.accept((Throwable)error);
            }
            catch (Throwable e) {
                newError = e;
            }
            finally {
                try {
                    if (!alreadyClosed) {
                        this.close();
                    }
                }
                catch (Throwable e2) {
                    if (newError == null) {
                        newError = e2;
                    } else {
                        newError.addSuppressed(e2);
                    }
                }
                finally {
                    if (newError != null) {
                        this.throwAsUnchecked(newError);
                    }
                }
            }
        });
        return this;
    }

    @Override
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_NO_SIDE_EFFECT"})
    public AsyncContentProvider onSuccess(Runnable action) {
        this.wrapped.onSuccess(() -> {
            action.run();
            try {
                this.close();
            }
            catch (Throwable e) {
                throw new ClosingProviderAutomaticallyException(e);
            }
        });
        return this;
    }

    private void throwAsUnchecked(Throwable error) {
        if (error instanceof RuntimeException) {
            throw (RuntimeException)error;
        }
        if (error instanceof Error) {
            throw (Error)error;
        }
        throw new RuntimeException(error);
    }
}

