/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.spring.boot.web.api.resources;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.ff4j.services.MonitoringServices;
import org.ff4j.services.domain.EventRepositoryApiBean;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"Monitoring"}, description="The API for monitoring related operations")
@RestController
@RequestMapping(value={"/api/ff4j/monitoring"})
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\nH\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lorg/ff4j/spring/boot/web/api/resources/MonitoringResource;", "", "monitoringServices", "Lorg/ff4j/services/MonitoringServices;", "(Lorg/ff4j/services/MonitoringServices;)V", "getMonitoringServices", "()Lorg/ff4j/services/MonitoringServices;", "getMonitoringStatus", "Lorg/ff4j/services/domain/EventRepositoryApiBean;", "start", "", "end", "ff4j-spring-boot-web-api"})
public class MonitoringResource {
    @NotNull
    private final MonitoringServices monitoringServices;

    public MonitoringResource(@Autowired @NotNull MonitoringServices monitoringServices) {
        Intrinsics.checkNotNullParameter((Object)monitoringServices, (String)"monitoringServices");
        this.monitoringServices = monitoringServices;
    }

    @NotNull
    public MonitoringServices getMonitoringServices() {
        return this.monitoringServices;
    }

    @ApiOperation(value="Display Monitoring information for all features", notes="The EventRepository handle to store audit events is not required", response=EventRepositoryApiBean.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Status of event repository bean", response=EventRepositoryApiBean.class), @ApiResponse(code=404, message="No event repository defined", response=String.class)})
    @GetMapping(produces={"application/json"})
    @NotNull
    public EventRepositoryApiBean getMonitoringStatus(@RequestParam(value="start", required=false, defaultValue="0") long start, @RequestParam(value="end", required=false, defaultValue="0") long end) {
        return this.getMonitoringServices().getMonitoringStatus(start, end);
    }
}

