/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.StringUtils;
import org.ff4j.FF4j;
import org.ff4j.cache.FF4jCacheProxy;
import org.ff4j.core.Feature;
import org.ff4j.core.FeatureStore;
import org.ff4j.services.domain.CacheApiBean;
import org.ff4j.services.domain.FeatureApiBean;
import org.ff4j.services.domain.FeatureStoreApiBean;
import org.ff4j.services.domain.GroupDescApiBean;
import org.ff4j.services.exceptions.FeatureStoreNotCached;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Service
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J>\u0010\u0014\u001a\u00020\b2\"\u0010\u0015\u001a\u001e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u000f0\u0016j\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u000f`\u00182\u0006\u0010\u0019\u001a\u00020\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u0017H\u0012R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lorg/ff4j/services/FeatureStoreServices;", "", "fF4j", "Lorg/ff4j/FF4j;", "(Lorg/ff4j/FF4j;)V", "getFF4j", "()Lorg/ff4j/FF4j;", "clearCachedFeatureStore", "", "deleteAllFeatures", "getAllFeatures", "", "Lorg/ff4j/services/domain/FeatureApiBean;", "getAllGroups", "", "Lorg/ff4j/services/domain/GroupDescApiBean;", "getFeatureStore", "Lorg/ff4j/services/domain/FeatureStoreApiBean;", "getFeaturesFromCache", "Lorg/ff4j/services/domain/CacheApiBean;", "initGroup", "groups", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "uid", "groupName", "ff4j-spring-services"})
public class FeatureStoreServices {
    @NotNull
    private final FF4j fF4j;

    public FeatureStoreServices(@Autowired @NotNull FF4j fF4j) {
        Intrinsics.checkNotNullParameter((Object)fF4j, (String)"fF4j");
        this.fF4j = fF4j;
    }

    @NotNull
    public FF4j getFF4j() {
        return this.fF4j;
    }

    @NotNull
    public FeatureStoreApiBean getFeatureStore() {
        FeatureStore featureStore = this.getFF4j().getFeatureStore();
        Intrinsics.checkNotNullExpressionValue((Object)featureStore, (String)"this.fF4j.featureStore");
        return new FeatureStoreApiBean(featureStore);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<FeatureApiBean> getAllFeatures() {
        Collection collection;
        Map allFeatures = this.getFF4j().getFeatureStore().readAll();
        if (CollectionUtils.isEmpty((Map)allFeatures)) {
            collection = new ArrayList(0);
        } else {
            void var2_2;
            ArrayList features = new ArrayList(allFeatures.size());
            features.addAll(allFeatures.values().stream().map(FeatureStoreServices::getAllFeatures$lambda-0).collect(Collectors.toList()));
            collection = (Collection)var2_2;
        }
        return collection;
    }

    @NotNull
    public Collection<GroupDescApiBean> getAllGroups() {
        Map allFeatures;
        HashMap<String, GroupDescApiBean> groups = new HashMap<String, GroupDescApiBean>();
        Map map = allFeatures = this.getFF4j().getFeatureStore().readAll();
        if (map != null) {
            Map it = map;
            boolean bl = false;
            Iterable $this$forEach$iv = allFeatures.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Feature it2 = (Feature)element$iv;
                boolean bl2 = false;
                String string = it2.getUid();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.uid");
                this.initGroup(groups, string, it2.getGroup());
            }
        }
        Collection<GroupDescApiBean> collection = groups.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"groups.values");
        return collection;
    }

    private void initGroup(HashMap<String, GroupDescApiBean> groups, String uid, String groupName) {
        String string = groupName;
        if (string != null) {
            String it = string;
            boolean bl = false;
            if (StringUtils.isNotBlank((CharSequence)groupName)) {
                if (!groups.containsKey(groupName)) {
                    Map map = groups;
                    GroupDescApiBean groupDescApiBean = new GroupDescApiBean(groupName, new ArrayList());
                    map.put(groupName, groupDescApiBean);
                }
                GroupDescApiBean groupDescApiBean = groups.get(groupName);
                if (groupDescApiBean != null) {
                    List<String> list = groupDescApiBean.getFeatures();
                    if (list != null) {
                        list.add(uid);
                    }
                }
            }
        }
    }

    public void deleteAllFeatures() {
        this.getFF4j().getFeatureStore().clear();
    }

    @NotNull
    public CacheApiBean getFeaturesFromCache() {
        if (this.getFF4j().getCacheProxy() == null) {
            throw new FeatureStoreNotCached();
        }
        FeatureStore featureStore = this.getFF4j().getFeatureStore();
        Intrinsics.checkNotNullExpressionValue((Object)featureStore, (String)"fF4j.featureStore");
        return new CacheApiBean(featureStore);
    }

    public void clearCachedFeatureStore() {
        FF4jCacheProxy fF4jCacheProxy = this.getFF4j().getCacheProxy();
        if (fF4jCacheProxy == null) {
            throw new FeatureStoreNotCached();
        }
        FF4jCacheProxy cacheProxy = fF4jCacheProxy;
        cacheProxy.getCacheManager().clearFeatures();
    }

    private static final FeatureApiBean getAllFeatures$lambda-0(Feature it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return new FeatureApiBean(it);
    }
}

