/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.springjdbc.store;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.ff4j.audit.Event;
import org.ff4j.audit.EventQueryDefinition;
import org.ff4j.audit.EventSeries;
import org.ff4j.audit.MutableHitCount;
import org.ff4j.audit.chart.TimeSeriesChart;
import org.ff4j.audit.repository.AbstractEventRepository;
import org.ff4j.springjdbc.store.dto.HitCountDto;
import org.ff4j.springjdbc.store.rowmapper.EventRowMapper;
import org.ff4j.springjdbc.store.rowmapper.HitCountRowMapper;
import org.ff4j.store.JdbcQueryBuilder;
import org.ff4j.utils.JdbcUtils;
import org.ff4j.utils.MappingUtil;
import org.ff4j.utils.Util;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class EventRepositorySpringJdbc
extends AbstractEventRepository {
    private DataSource dataSource;
    private JdbcTemplate jdbcTemplate;
    private JdbcQueryBuilder queryBuilder;
    private EventRowMapper EVENT_ROWMAPPER = new EventRowMapper();

    public EventRepositorySpringJdbc() {
    }

    public EventRepositorySpringJdbc(DataSource ds) {
        this.dataSource = ds;
    }

    public void createSchema() {
        JdbcQueryBuilder qb = this.getQueryBuilder();
        if (!JdbcUtils.isTableExist((DataSource)this.dataSource, (String)qb.getTableNameAudit())) {
            this.getJdbcTemplate().update(qb.sqlCreateTableAudit());
        }
    }

    public boolean saveEvent(Event evt) {
        Util.assertEvent((Event)evt);
        return this.getJdbcTemplate().update(this.getQueryBuilder().sqlSaveAudit(), new Object[]{evt.getUuid(), new Timestamp(evt.getTimestamp()), evt.getType(), evt.getName(), evt.getAction(), evt.getHostName(), evt.getSource(), evt.getDuration(), evt.getUser(), evt.getValue(), MappingUtil.fromMap((Map)evt.getCustomKeys())}) > 0;
    }

    public Event getEventByUUID(String uuid, Long timestamp) {
        Util.assertHasLength((String[])new String[]{uuid});
        List evts = this.getJdbcTemplate().query(this.getQueryBuilder().getEventByUuidQuery(), (RowMapper)this.EVENT_ROWMAPPER, new Object[]{uuid});
        return !evts.isEmpty() ? (Event)evts.get(0) : null;
    }

    public Map<String, MutableHitCount> getFeatureUsageHitCount(EventQueryDefinition query) {
        return this.computeHitCount(query, "EVT_NAME");
    }

    public Map<String, MutableHitCount> getHostHitCount(EventQueryDefinition query) {
        return this.computeHitCount(query, "EVT_HOSTNAME");
    }

    public Map<String, MutableHitCount> getUserHitCount(EventQueryDefinition query) {
        return this.computeHitCount(query, "EVT_USER");
    }

    public Map<String, MutableHitCount> getSourceHitCount(EventQueryDefinition query) {
        return this.computeHitCount(query, "EVT_SOURCE");
    }

    private Map<String, MutableHitCount> computeHitCount(EventQueryDefinition query, String colName) {
        List rawResult = this.getJdbcTemplate().query(this.getQueryBuilder().getHitCount(colName), (RowMapper)new HitCountRowMapper(colName), new Object[]{new Timestamp(query.getFrom()), new Timestamp(query.getTo())});
        HashMap<String, MutableHitCount> mapofHitCount = new HashMap<String, MutableHitCount>();
        for (HitCountDto dto : rawResult) {
            mapofHitCount.put(dto.getColumnName(), dto.getHitcount());
        }
        return mapofHitCount;
    }

    public TimeSeriesChart getFeatureUsageHistory(EventQueryDefinition query, TimeUnit units) {
        TimeSeriesChart tsc = new TimeSeriesChart(query.getFrom().longValue(), query.getTo().longValue(), units);
        Iterator iterEvent = this.searchFeatureUsageEvents(query).iterator();
        while (iterEvent.hasNext()) {
            tsc.addEvent((Event)iterEvent.next());
        }
        return tsc;
    }

    public EventSeries searchFeatureUsageEvents(EventQueryDefinition qDef) {
        return this.searchEvents(this.getQueryBuilder().getSelectFeatureUsageQuery(qDef), qDef.getFrom(), qDef.getTo());
    }

    public EventSeries getAuditTrail(EventQueryDefinition qDef) {
        return this.searchEvents(this.getQueryBuilder().getSelectAuditTrailQuery(qDef), qDef.getFrom(), qDef.getTo());
    }

    private EventSeries searchEvents(String sqlQuery, long from, long to) {
        EventSeries es = new EventSeries();
        es.addAll((Collection)this.getJdbcTemplate().query(sqlQuery, (RowMapper)this.EVENT_ROWMAPPER, new Object[]{new Timestamp(from), new Timestamp(to)}));
        return es;
    }

    public void purgeAuditTrail(EventQueryDefinition query) {
        Util.assertNotNull((Object[])new Object[]{query});
        this.getJdbcTemplate().update(this.getQueryBuilder().getPurgeAuditTrailQuery(query), new Object[]{new Timestamp(query.getFrom()), new Timestamp(query.getTo())});
    }

    public void purgeFeatureUsage(EventQueryDefinition query) {
        Util.assertNotNull((Object[])new Object[]{query});
        query.getActionFilters().add("checkOn");
        this.getJdbcTemplate().update(this.getQueryBuilder().getPurgeFeatureUsageQuery(query), new Object[]{new Timestamp(query.getFrom()), new Timestamp(query.getTo())});
    }

    @Required
    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public JdbcTemplate getJdbcTemplate() {
        if (this.jdbcTemplate == null) {
            if (this.dataSource == null) {
                throw new IllegalStateException("ff4j-jdbc: DatabaseStore has not been properly initialized, datasource is null");
            }
            this.jdbcTemplate = new JdbcTemplate(this.dataSource);
        }
        return this.jdbcTemplate;
    }

    public JdbcQueryBuilder getQueryBuilder() {
        if (this.queryBuilder == null) {
            this.queryBuilder = new JdbcQueryBuilder();
        }
        return this.queryBuilder;
    }

    public void setQueryBuilder(JdbcQueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }
}

