/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.springjdbc.store;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.ff4j.exception.PropertyAlreadyExistException;
import org.ff4j.exception.PropertyNotFoundException;
import org.ff4j.property.Property;
import org.ff4j.property.store.AbstractPropertyStore;
import org.ff4j.springjdbc.store.rowmapper.CustomPropertyRowMapper;
import org.ff4j.store.JdbcQueryBuilder;
import org.ff4j.utils.JdbcUtils;
import org.ff4j.utils.Util;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class PropertyStoreSpringJdbc
extends AbstractPropertyStore {
    private static CustomPropertyRowMapper PMAPPER = new CustomPropertyRowMapper();
    private DataSource dataSource;
    private JdbcTemplate jdbcTemplate;
    private JdbcQueryBuilder queryBuilder;

    public PropertyStoreSpringJdbc() {
    }

    public PropertyStoreSpringJdbc(DataSource ds) {
        this.dataSource = ds;
    }

    public boolean existProperty(String name) {
        Util.assertHasLength((String[])new String[]{name});
        return 1 == (Integer)this.getJdbcTemplate().queryForObject(this.getQueryBuilder().existProperty(), Integer.class, new Object[]{name});
    }

    public <T> void createProperty(Property<T> ap) {
        Util.assertNotNull((Object[])new Object[]{ap});
        Util.assertHasLength((String[])new String[]{ap.getName()});
        if (this.existProperty(ap.getName())) {
            throw new PropertyAlreadyExistException(ap.getName());
        }
        String fixedValues = null;
        if (ap.getFixedValues() != null && ap.getFixedValues().size() > 0) {
            fixedValues = ap.getFixedValues().toString();
            fixedValues = fixedValues.substring(1, fixedValues.length() - 1);
        }
        this.getJdbcTemplate().update(this.getQueryBuilder().createProperty(), new Object[]{ap.getName(), ap.getType(), ap.asString(), ap.getDescription(), fixedValues});
    }

    public Property<?> readProperty(String name) {
        Util.assertNotNull((String)name, (Object[])new Object[0]);
        if (!this.existProperty(name)) {
            throw new PropertyNotFoundException(name);
        }
        return (Property)this.getJdbcTemplate().queryForObject(this.getQueryBuilder().getProperty(), (RowMapper)PMAPPER, new Object[]{name});
    }

    public void updateProperty(String name, String newValue) {
        Util.assertHasLength((String[])new String[]{name});
        if (!this.existProperty(name)) {
            throw new PropertyNotFoundException(name);
        }
        this.readProperty(name).fromString(newValue);
        this.getJdbcTemplate().update(this.getQueryBuilder().updateProperty(), new Object[]{newValue, name});
    }

    public <T> void updateProperty(Property<T> prop) {
        Util.assertNotNull((Object[])new Object[]{prop});
        this.deleteProperty(prop.getName());
        this.createProperty(prop);
    }

    public void deleteProperty(String name) {
        Util.assertHasLength((String[])new String[]{name});
        if (!this.existProperty(name)) {
            throw new PropertyNotFoundException(name);
        }
        this.getJdbcTemplate().update(this.getQueryBuilder().deleteProperty(), new Object[]{name});
    }

    public Map<String, Property<?>> readAllProperties() {
        LinkedHashMap properties = new LinkedHashMap();
        List listOfProps = this.getJdbcTemplate().query(this.getQueryBuilder().getAllProperties(), (RowMapper)PMAPPER);
        for (Property p : listOfProps) {
            properties.put(p.getName(), p);
        }
        return properties;
    }

    public Set<String> listPropertyNames() {
        return new HashSet<String>(this.getJdbcTemplate().query(this.getQueryBuilder().getAllPropertiesNames(), (RowMapper)new SingleColumnRowMapper()));
    }

    public void clear() {
        this.getJdbcTemplate().update(this.getQueryBuilder().deleteAllProperties());
    }

    @Required
    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public JdbcTemplate getJdbcTemplate() {
        if (this.jdbcTemplate == null) {
            if (this.dataSource == null) {
                throw new IllegalStateException("ff4j-jdbc: DatabaseStore has not been properly initialized, datasource is null");
            }
            this.jdbcTemplate = new JdbcTemplate(this.dataSource);
        }
        return this.jdbcTemplate;
    }

    public JdbcQueryBuilder getQueryBuilder() {
        if (this.queryBuilder == null) {
            this.queryBuilder = new JdbcQueryBuilder();
        }
        return this.queryBuilder;
    }

    public void setQueryBuilder(JdbcQueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    @Transactional
    public void createSchema() {
        JdbcQueryBuilder qb = this.getQueryBuilder();
        if (!JdbcUtils.isTableExist((DataSource)this.dataSource, (String)qb.getTableNameProperties())) {
            this.getJdbcTemplate().update(qb.sqlCreateTableProperties());
        }
    }
}

