/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.cmd;

import java.io.Serializable;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.job.api.Job;
import org.flowable.job.service.impl.cmd.JobType;
import org.flowable.job.service.impl.persistence.entity.AbstractRuntimeJobEntity;
import org.flowable.job.service.impl.util.CommandContextUtil;

public class GetJobExceptionStacktraceCmd
implements Command<String>,
Serializable {
    private static final long serialVersionUID = 1L;
    private String jobId;
    protected JobType jobType;

    public GetJobExceptionStacktraceCmd(String jobId, JobType jobType) {
        this.jobId = jobId;
        this.jobType = jobType;
    }

    public String execute(CommandContext commandContext) {
        if (this.jobId == null) {
            throw new FlowableIllegalArgumentException("jobId is null");
        }
        AbstractRuntimeJobEntity job = null;
        switch (this.jobType) {
            case ASYNC: {
                job = (AbstractRuntimeJobEntity)CommandContextUtil.getJobEntityManager(commandContext).findById(this.jobId);
                break;
            }
            case TIMER: {
                job = (AbstractRuntimeJobEntity)CommandContextUtil.getTimerJobEntityManager(commandContext).findById(this.jobId);
                break;
            }
            case SUSPENDED: {
                job = (AbstractRuntimeJobEntity)CommandContextUtil.getSuspendedJobEntityManager(commandContext).findById(this.jobId);
                break;
            }
            case DEADLETTER: {
                job = (AbstractRuntimeJobEntity)CommandContextUtil.getDeadLetterJobEntityManager(commandContext).findById(this.jobId);
            }
        }
        if (job == null) {
            throw new FlowableObjectNotFoundException("No job found with id " + this.jobId, Job.class);
        }
        return job.getExceptionStacktrace();
    }
}

