/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.persistence.entity;

import org.flowable.engine.common.api.delegate.event.FlowableEngineEventType;
import org.flowable.engine.common.api.delegate.event.FlowableEvent;
import org.flowable.engine.common.api.delegate.event.FlowableEventDispatcher;
import org.flowable.engine.common.impl.persistence.entity.Entity;
import org.flowable.engine.common.impl.persistence.entity.EntityManager;
import org.flowable.engine.common.impl.persistence.entity.data.DataManager;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.event.impl.FlowableJobEventBuilder;
import org.flowable.job.service.impl.persistence.AbstractManager;
import org.flowable.job.service.impl.persistence.entity.JobByteArrayRef;

public abstract class AbstractEntityManager<EntityImpl extends Entity>
extends AbstractManager
implements EntityManager<EntityImpl> {
    public AbstractEntityManager(JobServiceConfiguration variableServiceConfiguration) {
        super(variableServiceConfiguration);
    }

    public EntityImpl findById(String entityId) {
        return (EntityImpl)this.getDataManager().findById(entityId);
    }

    public EntityImpl create() {
        return (EntityImpl)this.getDataManager().create();
    }

    public void insert(EntityImpl entity) {
        this.insert(entity, true);
    }

    public void insert(EntityImpl entity, boolean fireCreateEvent) {
        this.getDataManager().insert(entity);
        FlowableEventDispatcher eventDispatcher = this.getEventDispatcher();
        if (fireCreateEvent && eventDispatcher != null && eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableJobEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_CREATED, entity));
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableJobEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_INITIALIZED, entity));
        }
    }

    public EntityImpl update(EntityImpl entity) {
        return this.update(entity, true);
    }

    public EntityImpl update(EntityImpl entity, boolean fireUpdateEvent) {
        Entity updatedEntity = this.getDataManager().update(entity);
        FlowableEventDispatcher eventDispatcher = this.getEventDispatcher();
        if (fireUpdateEvent && eventDispatcher != null && eventDispatcher.isEnabled()) {
            this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableJobEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_UPDATED, entity));
        }
        return (EntityImpl)updatedEntity;
    }

    public void delete(String id) {
        EntityImpl entity = this.findById(id);
        this.delete(entity);
    }

    public void delete(EntityImpl entity) {
        this.delete(entity, true);
    }

    public void delete(EntityImpl entity, boolean fireDeleteEvent) {
        this.getDataManager().delete(entity);
        FlowableEventDispatcher eventDispatcher = this.getEventDispatcher();
        if (fireDeleteEvent && eventDispatcher != null && eventDispatcher.isEnabled()) {
            this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableJobEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_DELETED, entity));
        }
    }

    protected void deleteByteArrayRef(JobByteArrayRef jobByteArrayRef) {
        if (jobByteArrayRef != null) {
            jobByteArrayRef.delete();
        }
    }

    protected abstract DataManager<EntityImpl> getDataManager();
}

