/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.asyncexecutor;

import java.util.Collection;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.service.impl.persistence.entity.JobInfoEntity;
import org.flowable.job.service.impl.persistence.entity.JobInfoEntityManager;
import org.flowable.job.service.impl.util.CommandContextUtil;

public class ResetExpiredJobsCmd
implements Command<Void> {
    protected Collection<String> jobIds;
    protected JobInfoEntityManager<? extends JobInfoEntity> jobEntityManager;

    public ResetExpiredJobsCmd(Collection<String> jobsIds, JobInfoEntityManager<? extends JobInfoEntity> jobEntityManager) {
        this.jobIds = jobsIds;
        this.jobEntityManager = jobEntityManager;
    }

    public Void execute(CommandContext commandContext) {
        for (String jobId : this.jobIds) {
            JobInfoEntity job = (JobInfoEntity)this.jobEntityManager.findById(jobId);
            CommandContextUtil.getJobManager(commandContext).unacquire(job);
            this.jobEntityManager.resetExpiredJob(jobId);
        }
        return null;
    }
}

