/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.asyncexecutor;

import java.util.Collections;
import java.util.Set;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandConfig;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.api.JobInfo;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.asyncexecutor.AsyncRunnableExecutionExceptionHandler;
import org.flowable.job.service.impl.util.CommandContextUtil;

public class UnacquireAsyncHistoryJobExceptionHandler
implements AsyncRunnableExecutionExceptionHandler {
    @Override
    public boolean handleException(final JobServiceConfiguration jobServiceConfiguration, final JobInfo job, Throwable exception) {
        if (job != null && this.getAsyncHistoryJobHandlerTypes(jobServiceConfiguration).contains(job.getJobHandlerType())) {
            return (Boolean)jobServiceConfiguration.getCommandExecutor().execute((Command)new Command<Boolean>(){

                public Boolean execute(CommandContext commandContext) {
                    CommandConfig commandConfig = jobServiceConfiguration.getCommandExecutor().getDefaultConfig().transactionRequiresNew();
                    return (Boolean)jobServiceConfiguration.getCommandExecutor().execute(commandConfig, (Command)new Command<Boolean>(){

                        public Boolean execute(CommandContext commandContext2) {
                            CommandContextUtil.getJobManager(commandContext2).unacquireWithDecrementRetries(job);
                            return true;
                        }
                    });
                }
            });
        }
        return false;
    }

    protected Set<String> getAsyncHistoryJobHandlerTypes(JobServiceConfiguration jobServiceConfiguration) {
        if (jobServiceConfiguration.getHistoryJobHandlers() != null) {
            return jobServiceConfiguration.getHistoryJobHandlers().keySet();
        }
        return Collections.emptySet();
    }
}

