/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.persistence.entity.data.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.flowable.common.engine.impl.Page;
import org.flowable.common.engine.impl.db.AbstractDataManager;
import org.flowable.common.engine.impl.db.DbSqlSession;
import org.flowable.common.engine.impl.db.ListQueryParameterObject;
import org.flowable.common.engine.impl.persistence.cache.CachedEntityMatcher;
import org.flowable.job.api.Job;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.TimerJobQueryImpl;
import org.flowable.job.service.impl.persistence.entity.TimerJobEntity;
import org.flowable.job.service.impl.persistence.entity.TimerJobEntityImpl;
import org.flowable.job.service.impl.persistence.entity.data.TimerJobDataManager;
import org.flowable.job.service.impl.persistence.entity.data.impl.cachematcher.TimerJobsByExecutionIdMatcher;
import org.flowable.job.service.impl.persistence.entity.data.impl.cachematcher.TimerJobsByScopeIdAndSubScopeIdMatcher;

public class MybatisTimerJobDataManager
extends AbstractDataManager<TimerJobEntity>
implements TimerJobDataManager {
    protected JobServiceConfiguration jobServiceConfiguration;
    protected CachedEntityMatcher<TimerJobEntity> timerJobsByExecutionIdMatcher = new TimerJobsByExecutionIdMatcher();
    protected CachedEntityMatcher<TimerJobEntity> timerJobsByScopeIdAndSubScopeIdMatcher = new TimerJobsByScopeIdAndSubScopeIdMatcher();

    public MybatisTimerJobDataManager(JobServiceConfiguration jobServiceConfiguration) {
        this.jobServiceConfiguration = jobServiceConfiguration;
    }

    public Class<? extends TimerJobEntity> getManagedEntityClass() {
        return TimerJobEntityImpl.class;
    }

    public TimerJobEntity create() {
        return new TimerJobEntityImpl();
    }

    @Override
    public List<Job> findJobsByQueryCriteria(TimerJobQueryImpl jobQuery) {
        String query = "selectTimerJobByQueryCriteria";
        return this.getDbSqlSession().selectList(query, (ListQueryParameterObject)jobQuery);
    }

    @Override
    public long findJobCountByQueryCriteria(TimerJobQueryImpl jobQuery) {
        return (Long)this.getDbSqlSession().selectOne("selectTimerJobCountByQueryCriteria", (Object)jobQuery);
    }

    @Override
    public List<TimerJobEntity> findTimerJobsToExecute(Page page) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        String jobExecutionScope = this.jobServiceConfiguration.getJobExecutionScope();
        params.put("jobExecutionScope", jobExecutionScope);
        Date now = this.jobServiceConfiguration.getClock().getCurrentTime();
        params.put("now", now);
        return this.getDbSqlSession().selectList("selectTimerJobsToExecute", params, page);
    }

    @Override
    public List<TimerJobEntity> findJobsByTypeAndProcessDefinitionId(String jobHandlerType, String processDefinitionId) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("handlerType", jobHandlerType);
        params.put("processDefinitionId", processDefinitionId);
        return this.getDbSqlSession().selectList("selectTimerJobByTypeAndProcessDefinitionId", params);
    }

    @Override
    public List<TimerJobEntity> findJobsByExecutionId(String executionId) {
        DbSqlSession dbSqlSession = this.getDbSqlSession();
        if (this.isEntityInserted(dbSqlSession, "execution", executionId)) {
            return this.getListFromCache(this.timerJobsByExecutionIdMatcher, executionId);
        }
        return this.getList(dbSqlSession, "selectTimerJobsByExecutionId", executionId, this.timerJobsByExecutionIdMatcher, true);
    }

    @Override
    public List<TimerJobEntity> findJobsByProcessInstanceId(String processInstanceId) {
        return this.getDbSqlSession().selectList("selectTimerJobsByProcessInstanceId", (Object)processInstanceId);
    }

    @Override
    public List<TimerJobEntity> findJobsByScopeIdAndSubScopeId(String scopeId, String subScopeId) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("scopeId", scopeId);
        paramMap.put("subScopeId", subScopeId);
        return this.getList(this.getDbSqlSession(), "selectTimerJobsByScopeIdAndSubScopeId", paramMap, this.timerJobsByScopeIdAndSubScopeIdMatcher, true);
    }

    @Override
    public List<TimerJobEntity> findJobsByTypeAndProcessDefinitionKeyNoTenantId(String jobHandlerType, String processDefinitionKey) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("handlerType", jobHandlerType);
        params.put("processDefinitionKey", processDefinitionKey);
        return this.getDbSqlSession().selectList("selectTimerJobByTypeAndProcessDefinitionKeyNoTenantId", params);
    }

    @Override
    public List<TimerJobEntity> findJobsByTypeAndProcessDefinitionKeyAndTenantId(String jobHandlerType, String processDefinitionKey, String tenantId) {
        HashMap<String, String> params = new HashMap<String, String>(3);
        params.put("handlerType", jobHandlerType);
        params.put("processDefinitionKey", processDefinitionKey);
        params.put("tenantId", tenantId);
        return this.getDbSqlSession().selectList("selectTimerJobByTypeAndProcessDefinitionKeyAndTenantId", params);
    }

    @Override
    public void updateJobTenantIdForDeployment(String deploymentId, String newTenantId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("deploymentId", deploymentId);
        params.put("tenantId", newTenantId);
        this.getDbSqlSession().update("updateTimerJobTenantIdForDeployment", params);
    }
}

