/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.variable.service.impl.persistence.entity;

import java.io.Serializable;
import org.flowable.variable.service.impl.persistence.entity.VariableByteArrayEntity;
import org.flowable.variable.service.impl.persistence.entity.VariableByteArrayEntityManager;
import org.flowable.variable.service.impl.util.CommandContextUtil;

public class VariableByteArrayRef
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private String name;
    private VariableByteArrayEntity entity;
    protected boolean deleted;

    public VariableByteArrayRef() {
    }

    public VariableByteArrayRef(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public byte[] getBytes() {
        this.ensureInitialized();
        return this.entity != null ? this.entity.getBytes() : null;
    }

    public void setValue(String name, byte[] bytes) {
        this.name = name;
        this.setBytes(bytes);
    }

    private void setBytes(byte[] bytes) {
        if (this.id == null) {
            if (bytes != null) {
                VariableByteArrayEntityManager byteArrayEntityManager = CommandContextUtil.getByteArrayEntityManager();
                this.entity = (VariableByteArrayEntity)byteArrayEntityManager.create();
                this.entity.setName(this.name);
                this.entity.setBytes(bytes);
                byteArrayEntityManager.insert(this.entity);
                this.id = this.entity.getId();
            }
        } else {
            this.ensureInitialized();
            this.entity.setBytes(bytes);
        }
    }

    public VariableByteArrayEntity getEntity() {
        this.ensureInitialized();
        return this.entity;
    }

    public void delete() {
        if (!this.deleted && this.id != null) {
            if (this.entity != null) {
                CommandContextUtil.getByteArrayEntityManager().delete(this.entity);
            } else {
                CommandContextUtil.getByteArrayEntityManager().deleteByteArrayById(this.id);
            }
            this.entity = null;
            this.id = null;
            this.deleted = true;
        }
    }

    private void ensureInitialized() {
        if (this.id != null && this.entity == null) {
            this.entity = (VariableByteArrayEntity)CommandContextUtil.getByteArrayEntityManager().findById(this.id);
            this.name = this.entity.getName();
        }
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public VariableByteArrayRef copy() {
        VariableByteArrayRef copy = new VariableByteArrayRef();
        copy.id = this.id;
        copy.name = this.name;
        copy.entity = this.entity;
        copy.deleted = this.deleted;
        return copy;
    }

    public String toString() {
        return "ByteArrayRef[id=" + this.id + ", name=" + this.name + ", entity=" + this.entity + (this.deleted ? ", deleted]" : "]");
    }
}

