/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.configuration.models;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.flywaydb.core.internal.configuration.models.FlywayEnvironmentModel;
import org.flywaydb.core.internal.util.MergeUtils;

public class EnvironmentModel {
    private String url;
    private String user;
    private String password;
    private String driver;
    private List<String> schemas = new ArrayList<String>();
    private List<String> jarDirs = new ArrayList<String>();
    private Integer connectRetries;
    private Integer connectRetriesInterval;
    private String initSql;
    private Map<String, String> jdbcProperties;
    private Map<String, Map<String, Object>> resolvers;
    private String provisioner;
    private FlywayEnvironmentModel flyway = new FlywayEnvironmentModel();

    public EnvironmentModel merge(EnvironmentModel otherPojo) {
        EnvironmentModel result = new EnvironmentModel();
        result.url = MergeUtils.merge(this.url, otherPojo.url);
        result.user = MergeUtils.merge(this.user, otherPojo.user);
        result.password = MergeUtils.merge(this.password, otherPojo.password);
        result.driver = MergeUtils.merge(this.driver, otherPojo.driver);
        result.schemas = MergeUtils.merge(this.schemas, otherPojo.schemas);
        result.jarDirs = MergeUtils.merge(this.jarDirs, otherPojo.jarDirs);
        result.connectRetries = MergeUtils.merge(this.connectRetries, otherPojo.connectRetries);
        result.connectRetriesInterval = MergeUtils.merge(this.connectRetriesInterval, otherPojo.connectRetriesInterval);
        result.initSql = MergeUtils.merge(this.initSql, otherPojo.initSql);
        result.jdbcProperties = MergeUtils.merge(this.jdbcProperties, otherPojo.jdbcProperties, MergeUtils::merge);
        result.resolvers = MergeUtils.merge(this.resolvers, otherPojo.resolvers, EnvironmentModel::MergeResolvers);
        result.provisioner = MergeUtils.merge(this.provisioner, otherPojo.provisioner);
        result.flyway = this.flyway.merge(otherPojo.flyway);
        return result;
    }

    private static Map<String, Object> MergeResolvers(Map<String, Object> primary, Map<String, Object> overrides) {
        if (primary == null) {
            return overrides;
        }
        if (overrides == null) {
            return primary;
        }
        return MergeUtils.merge(primary, overrides, MergeUtils::merge);
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDriver() {
        return this.driver;
    }

    public List<String> getSchemas() {
        return this.schemas;
    }

    public List<String> getJarDirs() {
        return this.jarDirs;
    }

    public Integer getConnectRetries() {
        return this.connectRetries;
    }

    public Integer getConnectRetriesInterval() {
        return this.connectRetriesInterval;
    }

    public String getInitSql() {
        return this.initSql;
    }

    public Map<String, String> getJdbcProperties() {
        return this.jdbcProperties;
    }

    public Map<String, Map<String, Object>> getResolvers() {
        return this.resolvers;
    }

    public String getProvisioner() {
        return this.provisioner;
    }

    public FlywayEnvironmentModel getFlyway() {
        return this.flyway;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public void setSchemas(List<String> schemas) {
        this.schemas = schemas;
    }

    public void setJarDirs(List<String> jarDirs) {
        this.jarDirs = jarDirs;
    }

    public void setConnectRetries(Integer connectRetries) {
        this.connectRetries = connectRetries;
    }

    public void setConnectRetriesInterval(Integer connectRetriesInterval) {
        this.connectRetriesInterval = connectRetriesInterval;
    }

    public void setInitSql(String initSql) {
        this.initSql = initSql;
    }

    public void setJdbcProperties(Map<String, String> jdbcProperties) {
        this.jdbcProperties = jdbcProperties;
    }

    public void setResolvers(Map<String, Map<String, Object>> resolvers) {
        this.resolvers = resolvers;
    }

    public void setProvisioner(String provisioner) {
        this.provisioner = provisioner;
    }

    public void setFlyway(FlywayEnvironmentModel flyway) {
        this.flyway = flyway;
    }
}

