/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.experimental.schemahistory;

import java.time.LocalDateTime;

public final class SchemaHistoryItem {
    private final int installedRank;
    private final String version;
    private final String description;
    private final String type;
    private final String script;
    private final Integer checksum;
    private final String installedBy;
    private final LocalDateTime installedOn;
    private final int executionTime;
    private final boolean success;

    SchemaHistoryItem(int installedRank, String version, String description, String type, String script, Integer checksum, String installedBy, LocalDateTime installedOn, int executionTime, boolean success) {
        this.installedRank = installedRank;
        this.version = version;
        this.description = description;
        this.type = type;
        this.script = script;
        this.checksum = checksum;
        this.installedBy = installedBy;
        this.installedOn = installedOn;
        this.executionTime = executionTime;
        this.success = success;
    }

    public static SchemaHistoryItemBuilder builder() {
        return new SchemaHistoryItemBuilder();
    }

    public int getInstalledRank() {
        return this.installedRank;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public String getType() {
        return this.type;
    }

    public String getScript() {
        return this.script;
    }

    public Integer getChecksum() {
        return this.checksum;
    }

    public String getInstalledBy() {
        return this.installedBy;
    }

    public LocalDateTime getInstalledOn() {
        return this.installedOn;
    }

    public int getExecutionTime() {
        return this.executionTime;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SchemaHistoryItem)) {
            return false;
        }
        SchemaHistoryItem other = (SchemaHistoryItem)o;
        if (this.getInstalledRank() != other.getInstalledRank()) {
            return false;
        }
        if (this.getExecutionTime() != other.getExecutionTime()) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        Integer this$checksum = this.getChecksum();
        Integer other$checksum = other.getChecksum();
        if (this$checksum == null ? other$checksum != null : !((Object)this$checksum).equals(other$checksum)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$script = this.getScript();
        String other$script = other.getScript();
        if (this$script == null ? other$script != null : !this$script.equals(other$script)) {
            return false;
        }
        String this$installedBy = this.getInstalledBy();
        String other$installedBy = other.getInstalledBy();
        if (this$installedBy == null ? other$installedBy != null : !this$installedBy.equals(other$installedBy)) {
            return false;
        }
        LocalDateTime this$installedOn = this.getInstalledOn();
        LocalDateTime other$installedOn = other.getInstalledOn();
        return !(this$installedOn == null ? other$installedOn != null : !((Object)this$installedOn).equals(other$installedOn));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getInstalledRank();
        result = result * 59 + this.getExecutionTime();
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        Integer $checksum = this.getChecksum();
        result = result * 59 + ($checksum == null ? 43 : ((Object)$checksum).hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $script = this.getScript();
        result = result * 59 + ($script == null ? 43 : $script.hashCode());
        String $installedBy = this.getInstalledBy();
        result = result * 59 + ($installedBy == null ? 43 : $installedBy.hashCode());
        LocalDateTime $installedOn = this.getInstalledOn();
        result = result * 59 + ($installedOn == null ? 43 : ((Object)$installedOn).hashCode());
        return result;
    }

    public String toString() {
        return "SchemaHistoryItem(installedRank=" + this.getInstalledRank() + ", version=" + this.getVersion() + ", description=" + this.getDescription() + ", type=" + this.getType() + ", script=" + this.getScript() + ", checksum=" + this.getChecksum() + ", installedBy=" + this.getInstalledBy() + ", installedOn=" + this.getInstalledOn() + ", executionTime=" + this.getExecutionTime() + ", success=" + this.isSuccess() + ")";
    }

    public static class SchemaHistoryItemBuilder {
        private int installedRank;
        private String version;
        private String description;
        private String type;
        private String script;
        private Integer checksum;
        private String installedBy;
        private LocalDateTime installedOn;
        private int executionTime;
        private boolean success;

        SchemaHistoryItemBuilder() {
        }

        public SchemaHistoryItemBuilder installedRank(int installedRank) {
            this.installedRank = installedRank;
            return this;
        }

        public SchemaHistoryItemBuilder version(String version) {
            this.version = version;
            return this;
        }

        public SchemaHistoryItemBuilder description(String description) {
            this.description = description;
            return this;
        }

        public SchemaHistoryItemBuilder type(String type) {
            this.type = type;
            return this;
        }

        public SchemaHistoryItemBuilder script(String script) {
            this.script = script;
            return this;
        }

        public SchemaHistoryItemBuilder checksum(Integer checksum) {
            this.checksum = checksum;
            return this;
        }

        public SchemaHistoryItemBuilder installedBy(String installedBy) {
            this.installedBy = installedBy;
            return this;
        }

        public SchemaHistoryItemBuilder installedOn(LocalDateTime installedOn) {
            this.installedOn = installedOn;
            return this;
        }

        public SchemaHistoryItemBuilder executionTime(int executionTime) {
            this.executionTime = executionTime;
            return this;
        }

        public SchemaHistoryItemBuilder success(boolean success) {
            this.success = success;
            return this;
        }

        public SchemaHistoryItem build() {
            return new SchemaHistoryItem(this.installedRank, this.version, this.description, this.type, this.script, this.checksum, this.installedBy, this.installedOn, this.executionTime, this.success);
        }

        public String toString() {
            return "SchemaHistoryItem.SchemaHistoryItemBuilder(installedRank=" + this.installedRank + ", version=" + this.version + ", description=" + this.description + ", type=" + this.type + ", script=" + this.script + ", checksum=" + this.checksum + ", installedBy=" + this.installedBy + ", installedOn=" + this.installedOn + ", executionTime=" + this.executionTime + ", success=" + this.success + ")";
        }
    }
}

