/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.dbsupport.db2;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import org.flywaydb.core.internal.dbsupport.DbSupport;
import org.flywaydb.core.internal.dbsupport.Function;
import org.flywaydb.core.internal.dbsupport.JdbcTemplate;
import org.flywaydb.core.internal.dbsupport.Schema;
import org.flywaydb.core.internal.util.StringUtils;

public class DB2Function
extends Function {
    private static final Collection<String> typesWithLength = Arrays.asList("character", "char", "varchar", "graphic", "vargraphic", "decimal", "float", "varbinary");

    public DB2Function(JdbcTemplate jdbcTemplate, DbSupport dbSupport, Schema schema, String name, String ... args) {
        super(jdbcTemplate, dbSupport, schema, name, args);
    }

    @Override
    protected void doDrop() throws SQLException {
        try {
            this.jdbcTemplate.execute("DROP FUNCTION " + this.dbSupport.quote(this.schema.getName(), this.name) + "(" + this.argsToCommaSeparatedString(this.args) + ")", new Object[0]);
        }
        catch (SQLException e) {
            this.jdbcTemplate.execute("DROP FUNCTION " + this.dbSupport.quote(this.schema.getName(), this.name), new Object[0]);
        }
    }

    private String argsToCommaSeparatedString(String[] args) {
        StringBuilder buf = new StringBuilder();
        for (String arg : args) {
            if (buf.length() > 0) {
                buf.append(",");
            }
            buf.append(arg);
            if (!typesWithLength.contains(arg.toLowerCase())) continue;
            buf.append("()");
        }
        return buf.toString();
    }

    @Override
    public String toString() {
        return super.toString() + "(" + StringUtils.arrayToCommaDelimitedString(this.args) + ")";
    }
}

