/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.dbsupport.postgresql;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import org.flywaydb.core.internal.dbsupport.DbSupport;
import org.flywaydb.core.internal.dbsupport.FlywaySqlException;
import org.flywaydb.core.internal.dbsupport.JdbcTemplate;
import org.flywaydb.core.internal.dbsupport.Schema;
import org.flywaydb.core.internal.dbsupport.SqlStatementBuilder;
import org.flywaydb.core.internal.dbsupport.Table;
import org.flywaydb.core.internal.dbsupport.postgresql.PostgreSQLAdvisoryLockTemplate;
import org.flywaydb.core.internal.dbsupport.postgresql.PostgreSQLSchema;
import org.flywaydb.core.internal.dbsupport.postgresql.PostgreSQLSqlStatementBuilder;
import org.flywaydb.core.internal.util.StringUtils;
import org.postgresql.copy.CopyManager;
import org.postgresql.core.BaseConnection;

public class PostgreSQLDbSupport
extends DbSupport {
    public PostgreSQLDbSupport(Connection connection) {
        super(new JdbcTemplate(connection, 0));
    }

    @Override
    public String getDbName() {
        return "postgresql";
    }

    @Override
    public String getCurrentUserFunction() {
        return "current_user";
    }

    @Override
    public Schema getOriginalSchema() {
        if (this.originalSchema == null) {
            return null;
        }
        return this.getSchema(this.getFirstSchemaFromSearchPath(this.originalSchema));
    }

    String getFirstSchemaFromSearchPath(String searchPath) {
        String result = searchPath.replace(this.doQuote("$user"), "").trim();
        if (result.startsWith(",")) {
            result = result.substring(1);
        }
        if (result.contains(",")) {
            result = result.substring(0, result.indexOf(","));
        }
        if ((result = result.trim()).startsWith("\"") && result.endsWith("\"") && !result.endsWith("\\\"") && result.length() > 1) {
            result = result.substring(1, result.length() - 1);
        }
        return result;
    }

    @Override
    protected String doGetCurrentSchemaName() throws SQLException {
        return this.jdbcTemplate.queryForString("SHOW search_path", new String[0]);
    }

    @Override
    public void changeCurrentSchemaTo(Schema schema) {
        if (schema.getName().equals(this.originalSchema) || this.originalSchema.startsWith(schema.getName() + ",") || !schema.exists()) {
            return;
        }
        try {
            if (StringUtils.hasText(this.originalSchema)) {
                this.doChangeCurrentSchemaTo(schema.toString() + "," + this.originalSchema);
            } else {
                this.doChangeCurrentSchemaTo(schema.toString());
            }
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Error setting current schema to " + schema, e);
        }
    }

    @Override
    protected void doChangeCurrentSchemaTo(String schema) throws SQLException {
        if (!StringUtils.hasLength(schema)) {
            this.jdbcTemplate.execute("SELECT set_config('search_path', '', false)", new Object[0]);
            return;
        }
        this.jdbcTemplate.execute("SET search_path = " + schema, new Object[0]);
    }

    @Override
    public boolean supportsDdlTransactions() {
        return true;
    }

    @Override
    public String getBooleanTrue() {
        return "TRUE";
    }

    @Override
    public String getBooleanFalse() {
        return "FALSE";
    }

    @Override
    public SqlStatementBuilder createSqlStatementBuilder() {
        return new PostgreSQLSqlStatementBuilder();
    }

    @Override
    public String doQuote(String identifier) {
        return "\"" + StringUtils.replaceAll(identifier, "\"", "\"\"") + "\"";
    }

    @Override
    public Schema getSchema(String name) {
        return new PostgreSQLSchema(this.jdbcTemplate, this, name);
    }

    @Override
    public boolean catalogIsSchema() {
        return false;
    }

    @Override
    public void executePgCopy(Connection connection, String sql) throws SQLException {
        int split = sql.indexOf(";");
        String statement = sql.substring(0, split);
        String data = sql.substring(split + 1).trim();
        CopyManager copyManager = new CopyManager(connection.unwrap(BaseConnection.class));
        try {
            copyManager.copyIn(statement, (Reader)new StringReader(data));
        }
        catch (IOException e) {
            throw new SQLException("Unable to execute COPY operation", e);
        }
    }

    @Override
    public <T> T lock(Table table, Callable<T> callable) {
        return new PostgreSQLAdvisoryLockTemplate(this.jdbcTemplate, table.toString().hashCode()).execute(callable);
    }

    @Override
    public boolean useSingleConnection() {
        return true;
    }
}

