/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.dbsupport.enterprisedb;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.flywaydb.core.internal.dbsupport.JdbcTemplate;
import org.flywaydb.core.internal.dbsupport.Schema;
import org.flywaydb.core.internal.dbsupport.Table;
import org.flywaydb.core.internal.dbsupport.Type;
import org.flywaydb.core.internal.dbsupport.enterprisedb.EnterpriseDBDbSupport;
import org.flywaydb.core.internal.dbsupport.enterprisedb.EnterpriseDBTable;
import org.flywaydb.core.internal.dbsupport.enterprisedb.EnterpriseDBType;

public class EnterpriseDBSchema
extends Schema<EnterpriseDBDbSupport> {
    public EnterpriseDBSchema(JdbcTemplate jdbcTemplate, EnterpriseDBDbSupport dbSupport, String name) {
        super(jdbcTemplate, dbSupport, name);
    }

    @Override
    protected boolean doExists() throws SQLException {
        return this.jdbcTemplate.queryForInt("SELECT COUNT(*) FROM pg_namespace WHERE nspname=?", this.name) > 0;
    }

    @Override
    protected boolean doEmpty() throws SQLException {
        int objectCount = this.jdbcTemplate.queryForInt("SELECT count(*) FROM information_schema.tables WHERE table_schema=? AND table_type='BASE TABLE'", this.name);
        return objectCount == 0;
    }

    @Override
    protected void doCreate() throws SQLException {
        this.jdbcTemplate.execute("CREATE SCHEMA " + ((EnterpriseDBDbSupport)this.dbSupport).quote(this.name), new Object[0]);
    }

    @Override
    protected void doDrop() throws SQLException {
        this.jdbcTemplate.execute("DROP SCHEMA " + ((EnterpriseDBDbSupport)this.dbSupport).quote(this.name) + " CASCADE", new Object[0]);
    }

    @Override
    protected void doClean() throws SQLException {
        int databaseMajorVersion = this.jdbcTemplate.getMetaData().getDatabaseMajorVersion();
        int databaseMinorVersion = this.jdbcTemplate.getMetaData().getDatabaseMinorVersion();
        if (databaseMajorVersion > 9 || databaseMajorVersion == 9 && databaseMinorVersion >= 3) {
            for (String statement : this.generateDropStatementsForMaterializedViews()) {
                this.jdbcTemplate.execute(statement, new Object[0]);
            }
        }
        for (String statement : this.generateDropStatementsForPackages()) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.generateDropStatementsForViews()) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (Table table : this.allTables()) {
            table.drop();
        }
        for (String statement : this.generateDropStatementsForSequences()) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.generateDropStatementsForBaseTypes(true)) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.generateDropStatementsForAggregates()) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.generateDropStatementsForRoutines()) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.generateDropStatementsForEnums()) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.generateDropStatementsForDomains()) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        for (String statement : this.generateDropStatementsForBaseTypes(false)) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
    }

    private List<String> generateDropStatementsForSequences() throws SQLException {
        List<String> sequenceNames = this.jdbcTemplate.queryForStringList("SELECT sequence_name FROM information_schema.sequences WHERE sequence_schema=?", this.name);
        ArrayList<String> statements = new ArrayList<String>();
        for (String sequenceName : sequenceNames) {
            statements.add("DROP SEQUENCE IF EXISTS " + ((EnterpriseDBDbSupport)this.dbSupport).quote(this.name, sequenceName));
        }
        return statements;
    }

    private List<String> generateDropStatementsForBaseTypes(boolean recreate) throws SQLException {
        List<Map<String, String>> rows = this.jdbcTemplate.queryForList("select typname, typcategory from pg_catalog.pg_type t where (t.typrelid = 0 OR (SELECT c.relkind = 'c' FROM pg_catalog.pg_class c WHERE c.oid = t.typrelid)) and NOT EXISTS(SELECT 1 FROM pg_catalog.pg_type el WHERE el.oid = t.typelem AND el.typarray = t.oid) and t.typnamespace in (select oid from pg_catalog.pg_namespace where nspname = ?)", this.name);
        ArrayList<String> statements = new ArrayList<String>();
        for (Map<String, String> row : rows) {
            statements.add("DROP TYPE IF EXISTS " + ((EnterpriseDBDbSupport)this.dbSupport).quote(this.name, row.get("typname")) + " CASCADE");
        }
        if (recreate) {
            for (Map<String, String> row : rows) {
                if (!Arrays.asList("P", "U").contains(row.get("typcategory"))) continue;
                statements.add("CREATE TYPE " + ((EnterpriseDBDbSupport)this.dbSupport).quote(this.name, row.get("typname")));
            }
        }
        return statements;
    }

    private List<String> generateDropStatementsForAggregates() throws SQLException {
        List<Map<String, String>> rows = this.jdbcTemplate.queryForList("SELECT proname, oidvectortypes(proargtypes) AS args FROM pg_proc INNER JOIN pg_namespace ns ON (pg_proc.pronamespace = ns.oid) WHERE pg_proc.proisagg = true AND ns.nspname = ?", this.name);
        ArrayList<String> statements = new ArrayList<String>();
        for (Map<String, String> row : rows) {
            statements.add("DROP AGGREGATE IF EXISTS " + ((EnterpriseDBDbSupport)this.dbSupport).quote(this.name, row.get("proname")) + "(" + row.get("args") + ") CASCADE");
        }
        return statements;
    }

    private List<String> generateDropStatementsForRoutines() throws SQLException {
        List<Map<String, String>> rows = this.jdbcTemplate.queryForList("SELECT proname, oidvectortypes(proargtypes) AS args FROM pg_proc INNER JOIN pg_namespace ns ON (pg_proc.pronamespace = ns.oid) LEFT JOIN pg_depend dep ON dep.objid = pg_proc.oid AND dep.deptype = 'e' WHERE pg_proc.proisagg = false AND ns.nspname = ? AND dep.objid IS NULL", this.name);
        ArrayList<String> statements = new ArrayList<String>();
        for (Map<String, String> row : rows) {
            statements.add("DROP FUNCTION IF EXISTS " + ((EnterpriseDBDbSupport)this.dbSupport).quote(this.name, row.get("proname")) + "(" + row.get("args") + ") CASCADE");
        }
        return statements;
    }

    private List<String> generateDropStatementsForPackages() throws SQLException {
        List<Map<String, String>> rows = this.jdbcTemplate.queryForList("SELECT edb_package.pkgname FROM edb_package JOIN pg_namespace ON edb_package.pkgowner = pg_namespace.oid WHERE pg_namespace.nspname = ?", this.name);
        ArrayList<String> statements = new ArrayList<String>();
        for (Map<String, String> row : rows) {
            statements.add("DROP PACKAGE " + ((EnterpriseDBDbSupport)this.dbSupport).quote(this.name, row.get("pkgname")));
        }
        return statements;
    }

    private List<String> generateDropStatementsForEnums() throws SQLException {
        List<String> enumNames = this.jdbcTemplate.queryForStringList("SELECT t.typname FROM pg_catalog.pg_type t INNER JOIN pg_catalog.pg_namespace n ON n.oid = t.typnamespace WHERE n.nspname = ? and t.typtype = 'e'", this.name);
        ArrayList<String> statements = new ArrayList<String>();
        for (String enumName : enumNames) {
            statements.add("DROP TYPE " + ((EnterpriseDBDbSupport)this.dbSupport).quote(this.name, enumName));
        }
        return statements;
    }

    private List<String> generateDropStatementsForDomains() throws SQLException {
        List<String> domainNames = this.jdbcTemplate.queryForStringList("SELECT domain_name FROM information_schema.domains WHERE domain_schema=?", this.name);
        ArrayList<String> statements = new ArrayList<String>();
        for (String domainName : domainNames) {
            statements.add("DROP DOMAIN " + ((EnterpriseDBDbSupport)this.dbSupport).quote(this.name, domainName));
        }
        return statements;
    }

    private List<String> generateDropStatementsForMaterializedViews() throws SQLException {
        List<String> viewNames = this.jdbcTemplate.queryForStringList("SELECT relname FROM pg_catalog.pg_class c JOIN pg_namespace n ON n.oid = c.relnamespace WHERE c.relkind = 'm' AND n.nspname = ?", this.name);
        ArrayList<String> statements = new ArrayList<String>();
        for (String domainName : viewNames) {
            statements.add("DROP MATERIALIZED VIEW IF EXISTS " + ((EnterpriseDBDbSupport)this.dbSupport).quote(this.name, domainName) + " CASCADE");
        }
        return statements;
    }

    private List<String> generateDropStatementsForViews() throws SQLException {
        List<String> viewNames = this.jdbcTemplate.queryForStringList("SELECT relname FROM pg_catalog.pg_class c JOIN pg_namespace n ON n.oid = c.relnamespace LEFT JOIN pg_depend dep ON dep.objid = c.oid AND dep.deptype = 'e' WHERE c.relkind = 'v' AND  n.nspname = ? AND dep.objid IS NULL", this.name);
        ArrayList<String> statements = new ArrayList<String>();
        for (String domainName : viewNames) {
            statements.add("DROP VIEW IF EXISTS " + ((EnterpriseDBDbSupport)this.dbSupport).quote(this.name, domainName) + " CASCADE");
        }
        return statements;
    }

    @Override
    protected Table[] doAllTables() throws SQLException {
        List<String> tableNames = this.jdbcTemplate.queryForStringList("SELECT t.table_name FROM information_schema.tables t WHERE table_schema=? AND table_type='BASE TABLE' AND NOT (SELECT EXISTS (SELECT inhrelid FROM pg_catalog.pg_inherits WHERE inhrelid = (quote_ident(t.table_schema)||'.'||quote_ident(t.table_name))::regclass::oid))", this.name);
        Table[] tables = new Table[tableNames.size()];
        for (int i = 0; i < tableNames.size(); ++i) {
            tables[i] = new EnterpriseDBTable(this.jdbcTemplate, this.dbSupport, this, tableNames.get(i));
        }
        return tables;
    }

    @Override
    public Table getTable(String tableName) {
        return new EnterpriseDBTable(this.jdbcTemplate, this.dbSupport, this, tableName);
    }

    @Override
    protected Type getType(String typeName) {
        return new EnterpriseDBType(this.jdbcTemplate, this.dbSupport, this, typeName);
    }
}

