/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.dbsupport.phoenix;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.flywaydb.core.internal.dbsupport.JdbcTemplate;
import org.flywaydb.core.internal.dbsupport.Schema;
import org.flywaydb.core.internal.dbsupport.Table;
import org.flywaydb.core.internal.dbsupport.phoenix.PhoenixDbSupport;
import org.flywaydb.core.internal.dbsupport.phoenix.PhoenixTable;
import org.flywaydb.core.internal.util.jdbc.RowMapper;
import org.flywaydb.core.internal.util.logging.Log;
import org.flywaydb.core.internal.util.logging.LogFactory;

public class PhoenixSchema
extends Schema<PhoenixDbSupport> {
    private static final Log LOG = LogFactory.getLog(PhoenixSchema.class);

    public PhoenixSchema(JdbcTemplate jdbcTemplate, PhoenixDbSupport dbSupport, String name) {
        super(jdbcTemplate, dbSupport, name);
    }

    @Override
    protected boolean doExists() throws SQLException {
        ResultSet rs = this.jdbcTemplate.getMetaData().getSchemas();
        while (rs.next()) {
            String schemaName = rs.getString("TABLE_SCHEM");
            if (!(schemaName == null ? this.name == null : this.name != null && schemaName.equals(this.name))) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean doEmpty() throws SQLException {
        return this.allTables().length == 0;
    }

    @Override
    protected void doCreate() throws SQLException {
        LOG.info("Phoenix does not support creating schemas. Schema not created: " + this.name);
    }

    @Override
    protected void doDrop() throws SQLException {
        LOG.info("Phoenix does not support dropping schemas directly. Running clean of objects instead");
        this.doClean();
    }

    @Override
    protected void doClean() throws SQLException {
        List<String> sequenceNames = this.listObjectsOfType("sequence");
        for (String string : this.generateDropStatements("SEQUENCE", sequenceNames, "")) {
            this.jdbcTemplate.execute(string, new Object[0]);
        }
        List<String> viewNames = this.listObjectsOfType("view");
        for (String statement : this.generateDropStatements("VIEW", viewNames, "")) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        List<String> list = this.listObjectsOfType("index");
        ArrayList<String> indexNames = new ArrayList<String>();
        ArrayList<String> indexTables = new ArrayList<String>();
        for (String string : list) {
            String[] splits = string.split(",");
            indexNames.add(splits[0]);
            indexTables.add("ON " + ((PhoenixDbSupport)this.dbSupport).quote(this.name, splits[1]));
        }
        List<String> statements = this.generateDropIndexStatements(indexNames, indexTables);
        for (String statement : statements) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        List<String> list2 = this.listObjectsOfType("table");
        for (String statement : this.generateDropStatements("TABLE", list2, "")) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
    }

    private List<String> generateDropStatements(String objectType, List<String> objectNames, String dropStatementSuffix) {
        ArrayList<String> statements = new ArrayList<String>();
        for (String objectName : objectNames) {
            String dropStatement = "DROP " + objectType + " " + ((PhoenixDbSupport)this.dbSupport).quote(this.name, objectName) + " " + dropStatementSuffix;
            statements.add(dropStatement);
        }
        return statements;
    }

    private List<String> generateDropIndexStatements(List<String> objectNames, List<String> dropStatementSuffixes) {
        ArrayList<String> statements = new ArrayList<String>();
        for (int i = 0; i < objectNames.size(); ++i) {
            String dropStatement = "DROP INDEX " + ((PhoenixDbSupport)this.dbSupport).quote(objectNames.get(i)) + " " + dropStatementSuffixes.get(i);
            statements.add(dropStatement);
        }
        return statements;
    }

    @Override
    protected Table[] doAllTables() throws SQLException {
        List<String> tableNames = this.listObjectsOfType("table");
        Table[] tables = new Table[tableNames.size()];
        for (int i = 0; i < tableNames.size(); ++i) {
            tables[i] = new PhoenixTable(this.jdbcTemplate, this.dbSupport, this, tableNames.get(i));
        }
        return tables;
    }

    protected List<String> listObjectsOfType(String type) throws SQLException {
        String finalName;
        List<String> retVal = new ArrayList<String>();
        String string = finalName = this.name == null ? "" : this.name;
        if (type.equalsIgnoreCase("view")) {
            ResultSet rs = this.jdbcTemplate.getConnection().getMetaData().getTables(null, finalName, null, new String[]{"VIEW"});
            while (rs.next()) {
                String viewName = rs.getString("TABLE_NAME");
                if (viewName == null) continue;
                retVal.add(viewName);
            }
        } else if (type.equalsIgnoreCase("table")) {
            ResultSet rs = this.jdbcTemplate.getMetaData().getTables(null, finalName, null, new String[]{"TABLE"});
            while (rs.next()) {
                String tableName = rs.getString("TABLE_NAME");
                HashSet<String> tables = new HashSet<String>();
                if (tableName != null) {
                    tables.add(tableName);
                }
                retVal.addAll(tables);
            }
        } else {
            if (type.equalsIgnoreCase("sequence")) {
                if (this.name == null) {
                    String query = "SELECT SEQUENCE_NAME FROM SYSTEM.\"SEQUENCE\" WHERE SEQUENCE_SCHEMA IS NULL";
                    return this.jdbcTemplate.queryForStringList(query, new String[0]);
                }
                String query = "SELECT SEQUENCE_NAME FROM SYSTEM.\"SEQUENCE\" WHERE SEQUENCE_SCHEMA = ?";
                return this.jdbcTemplate.queryForStringList(query, this.name);
            }
            if (type.equalsIgnoreCase("index")) {
                String query = "SELECT TABLE_NAME, DATA_TABLE_NAME FROM SYSTEM.CATALOG WHERE TABLE_SCHEM";
                query = this.name == null ? query + " IS NULL" : query + " = ?";
                query = query + " AND TABLE_TYPE = 'i'";
                String finalQuery = query.replaceFirst("\\?", "'" + this.name + "'");
                retVal = this.jdbcTemplate.query(finalQuery, new RowMapper<String>(){

                    @Override
                    public String mapRow(ResultSet rs) throws SQLException {
                        return rs.getString("TABLE_NAME") + "," + rs.getString("DATA_TABLE_NAME");
                    }
                });
            }
        }
        return retVal;
    }

    @Override
    public Table getTable(String tableName) {
        return new PhoenixTable(this.jdbcTemplate, this.dbSupport, this, tableName);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Schema schema = (Schema)o;
        if (this.name == null) {
            return this.name == schema.getName();
        }
        return this.name.equals(schema.getName());
    }
}

