/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.util.scanner;

import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.util.FeatureDetector;
import org.flywaydb.core.internal.util.Location;
import org.flywaydb.core.internal.util.scanner.Resource;
import org.flywaydb.core.internal.util.scanner.classpath.ClassPathScanner;
import org.flywaydb.core.internal.util.scanner.classpath.ResourceAndClassScanner;
import org.flywaydb.core.internal.util.scanner.classpath.android.AndroidScanner;
import org.flywaydb.core.internal.util.scanner.filesystem.FileSystemScanner;

public class Scanner {
    private final ResourceAndClassScanner resourceAndClassScanner;
    private final ClassLoader classLoader;
    private final FileSystemScanner fileSystemScanner = new FileSystemScanner();

    public Scanner(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.resourceAndClassScanner = new FeatureDetector(classLoader).isAndroidAvailable() ? new AndroidScanner(classLoader) : new ClassPathScanner(classLoader);
    }

    public Resource[] scanForResources(Location location, String prefix, String suffix) {
        try {
            if (location.isFileSystem()) {
                return this.fileSystemScanner.scanForResources(location, prefix, suffix);
            }
            return this.resourceAndClassScanner.scanForResources(location, prefix, suffix);
        }
        catch (Exception e) {
            throw new FlywayException("Unable to scan for SQL migrations in location: " + location, e);
        }
    }

    public Class<?>[] scanForClasses(Location location, Class<?> implementedInterface) throws Exception {
        return this.resourceAndClassScanner.scanForClasses(location, implementedInterface);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

