/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.postgresql;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.Callable;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.exception.FlywaySqlException;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.RowMapper;

public class PostgreSQLAdvisoryLockTemplate {
    private static final Log LOG = LogFactory.getLog(PostgreSQLAdvisoryLockTemplate.class);
    private static final long LOCK_MAGIC_NUM = 77431708279161L;
    private final JdbcTemplate jdbcTemplate;
    private final long lockNum;

    PostgreSQLAdvisoryLockTemplate(JdbcTemplate jdbcTemplate, int discriminator) {
        this.jdbcTemplate = jdbcTemplate;
        this.lockNum = 77431708279161L + (long)discriminator;
    }

    public <T> T execute(Callable<T> callable) {
        try {
            this.lock();
            T t = callable.call();
            return t;
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to acquire PostgreSQL advisory lock", e);
        }
        catch (Exception e) {
            RuntimeException rethrow = e instanceof RuntimeException ? (RuntimeException)e : new FlywayException(e);
            throw rethrow;
        }
        finally {
            try {
                this.jdbcTemplate.execute("SELECT pg_advisory_unlock(" + this.lockNum + ")", new Object[0]);
            }
            catch (SQLException e) {
                LOG.error("Unable to release PostgreSQL advisory lock", e);
            }
        }
    }

    private void lock() throws SQLException {
        while (!this.tryLock()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new FlywayException("Interrupted while attempting to acquire PostgreSQL advisory lock", e);
            }
        }
    }

    private boolean tryLock() throws SQLException {
        List<Boolean> results = this.jdbcTemplate.query("SELECT pg_try_advisory_lock(" + this.lockNum + ")", new RowMapper<Boolean>(){

            @Override
            public Boolean mapRow(ResultSet rs) throws SQLException {
                return "t".equals(rs.getString("pg_try_advisory_lock"));
            }
        }, new Object[0]);
        return results.size() == 1 && results.get(0) != false;
    }
}

