/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.parser;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import org.flywaydb.core.api.FlywayException;

public class PlaceholderReplacingReader
extends FilterReader {
    private final String prefix;
    private final String suffix;
    private final Map<String, String> placeholders;
    private final int readAheadLimitAdjustment;
    private final StringBuilder buffer = new StringBuilder();
    private String markBuffer;
    private String replacement;
    private int replacementPos;
    private String markReplacement;
    private int markReplacementPos;

    public PlaceholderReplacingReader(String prefix, String suffix, Map<String, String> placeholders, Reader in) {
        super(in);
        int prefixSuffixLength;
        this.prefix = prefix;
        this.suffix = suffix;
        this.placeholders = placeholders;
        int maxPlaceholderLength = prefixSuffixLength = prefix.length() + suffix.length();
        int minReplacementLength = Integer.MAX_VALUE;
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            maxPlaceholderLength = Math.max(maxPlaceholderLength, prefixSuffixLength + entry.getKey().length());
            minReplacementLength = Math.min(minReplacementLength, entry.getValue().length());
        }
        this.readAheadLimitAdjustment = Math.max(maxPlaceholderLength - minReplacementLength, 0);
    }

    @Override
    public int read() throws IOException {
        if (this.replacement == null) {
            int r1;
            int r;
            if (this.buffer.length() > 0) {
                char c = this.buffer.charAt(0);
                this.buffer.deleteCharAt(0);
                return c;
            }
            while ((r = super.read()) != -1) {
                this.buffer.append((char)r);
                if (this.buffer.length() < this.prefix.length() && this.endsWith(this.buffer, this.prefix.substring(0, this.buffer.length()))) continue;
            }
            if (!this.endsWith(this.buffer, this.prefix)) {
                if (this.buffer.length() > 0) {
                    char c = this.buffer.charAt(0);
                    this.buffer.deleteCharAt(0);
                    return c;
                }
                return -1;
            }
            this.buffer.delete(0, this.buffer.length());
            StringBuilder placeholder = new StringBuilder();
            while ((r1 = this.in.read()) != -1) {
                placeholder.append((char)r1);
                if (!this.endsWith(placeholder, this.suffix)) continue;
            }
            for (int i = 0; i < this.suffix.length(); ++i) {
                placeholder.deleteCharAt(placeholder.length() - 1);
            }
            this.replacement = this.placeholders.get(placeholder.toString());
            if (this.replacement == null) {
                throw new FlywayException("No value provided for placeholder: " + this.prefix + placeholder + this.suffix + ".  Check your configuration!");
            }
            if (this.replacement.length() == 0) {
                this.replacement = null;
                return this.read();
            }
        }
        char result = this.replacement.charAt(this.replacementPos);
        ++this.replacementPos;
        if (this.replacementPos >= this.replacement.length()) {
            this.replacement = null;
            this.replacementPos = 0;
        }
        return result;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int count = 0;
        for (int i = 0; i < len; ++i) {
            int r = this.read();
            if (r == -1) {
                return count == 0 ? -1 : count;
            }
            cbuf[off + i] = (char)r;
            ++count;
        }
        return count;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        this.markBuffer = this.buffer.toString();
        this.markReplacement = this.replacement;
        this.markReplacementPos = this.replacementPos;
        super.mark(readAheadLimit + this.readAheadLimitAdjustment);
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.buffer.delete(0, this.buffer.length());
        this.buffer.append(this.markBuffer);
        this.replacement = this.markReplacement;
        this.replacementPos = this.markReplacementPos;
    }

    private boolean endsWith(StringBuilder result, String str) {
        if (result.length() < str.length()) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (result.charAt(result.length() - str.length() + i) == str.charAt(i)) continue;
            return false;
        }
        return true;
    }
}

