// CheckStyle: start generated
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;

/**
 * Debug Info: <pre>
 *   Specialization {@link GlobalScopeLookupNode#doAbsent}
 *     Activation probability: 0.48333
 *     With/without class size: 11/4 bytes
 *   Specialization {@link GlobalScopeLookupNode#doCached}
 *     Activation probability: 0.33333
 *     With/without class size: 13/11 bytes
 *   Specialization {@link GlobalScopeLookupNode#doUncached}
 *     Activation probability: 0.18333
 *     With/without class size: 7/1 bytes
 * </pre>
 */
@GeneratedBy(GlobalScopeLookupNode.class)
@SuppressWarnings("javadoc")
public final class GlobalScopeLookupNodeGen extends GlobalScopeLookupNode {

    private static final StateField STATE_0_GlobalScopeLookupNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
    static final ReferenceField<CachedData> CACHED_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "cached_cache", CachedData.class);
    /**
     * Source Info: <pre>
     *   Specialization: {@link GlobalScopeLookupNode#doUncached}
     *   Parameter: {@link InlinedBranchProfile} errorBranch
     *   Inline method: {@link InlinedBranchProfile#inline}</pre>
     */
    private static final InlinedBranchProfile INLINED_UNCACHED_ERROR_BRANCH_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, STATE_0_GlobalScopeLookupNode_UPDATER.subUpdater(3, 1)));

    /**
     * State Info: <pre>
     *   0: SpecializationActive {@link GlobalScopeLookupNode#doAbsent}
     *   1: SpecializationActive {@link GlobalScopeLookupNode#doCached}
     *   2: SpecializationActive {@link GlobalScopeLookupNode#doUncached}
     *   3: InlinedCache
     *        Specialization: {@link GlobalScopeLookupNode#doUncached}
     *        Parameter: {@link InlinedBranchProfile} errorBranch
     *        Inline method: {@link InlinedBranchProfile#inline}
     * </pre>
     */
    @CompilationFinal @UnsafeAccessedField private int state_0_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link GlobalScopeLookupNode#doAbsent}
     *   Parameter: {@link Assumption} assumption</pre>
     */
    @CompilationFinal private Assumption absent_assumption_;
    @UnsafeAccessedField @CompilationFinal private CachedData cached_cache;

    private GlobalScopeLookupNodeGen(TruffleString varName, boolean write) {
        super(varName, write);
    }

    @ExplodeLoop
    @Override
    public boolean execute(Object arg0Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b111) != 0 /* is SpecializationActive[GlobalScopeLookupNode.doAbsent(JSDynamicObject, Assumption)] || SpecializationActive[GlobalScopeLookupNode.doCached(JSDynamicObject, Shape, boolean, boolean, boolean, int)] || SpecializationActive[GlobalScopeLookupNode.doUncached(JSDynamicObject, InlinedBranchProfile)] */ && arg0Value instanceof JSDynamicObject) {
            JSDynamicObject arg0Value_ = (JSDynamicObject) arg0Value;
            if ((state_0 & 0b1) != 0 /* is SpecializationActive[GlobalScopeLookupNode.doAbsent(JSDynamicObject, Assumption)] */) {
                if (!Assumption.isValidAssumption((this.absent_assumption_))) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    removeAbsent_();
                    return executeAndSpecialize(arg0Value_);
                }
                {
                    Assumption assumption__ = this.absent_assumption_;
                    if (assumption__ != null) {
                        return GlobalScopeLookupNode.doAbsent(arg0Value_, assumption__);
                    }
                }
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[GlobalScopeLookupNode.doCached(JSDynamicObject, Shape, boolean, boolean, boolean, int)] */) {
                CachedData s1_ = this.cached_cache;
                while (s1_ != null) {
                    if (!Assumption.isValidAssumption(s1_.assumption0_)) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        removeCached_(s1_);
                        return executeAndSpecialize(arg0Value_);
                    }
                    if ((arg0Value_.getShape() == s1_.cachedShape_)) {
                        return doCached(arg0Value_, s1_.cachedShape_, s1_.exists_, s1_.dead_, s1_.constAssignment_, s1_.cacheLimit_);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[GlobalScopeLookupNode.doUncached(JSDynamicObject, InlinedBranchProfile)] */) {
                return doUncached(arg0Value_, INLINED_UNCACHED_ERROR_BRANCH_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value);
    }

    @SuppressWarnings("unused")
    private boolean executeAndSpecialize(Object arg0Value) {
        int state_0 = this.state_0_;
        if (arg0Value instanceof JSDynamicObject) {
            JSDynamicObject arg0Value_ = (JSDynamicObject) arg0Value;
            if (((state_0 & 0b110)) == 0 /* is-not SpecializationActive[GlobalScopeLookupNode.doCached(JSDynamicObject, Shape, boolean, boolean, boolean, int)] && SpecializationActive[GlobalScopeLookupNode.doUncached(JSDynamicObject, InlinedBranchProfile)] */) {
                {
                    Assumption assumption__ = (getAbsentPropertyAssumption(arg0Value_.getShape()));
                    Assumption absent_assumption0 = (assumption__);
                    if (Assumption.isValidAssumption(absent_assumption0)) {
                        Objects.requireNonNull(assumption__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        VarHandle.storeStoreFence();
                        this.absent_assumption_ = assumption__;
                        state_0 = state_0 | 0b1 /* add SpecializationActive[GlobalScopeLookupNode.doAbsent(JSDynamicObject, Assumption)] */;
                        this.state_0_ = state_0;
                        return GlobalScopeLookupNode.doAbsent(arg0Value_, assumption__);
                    }
                }
            }
            if (((state_0 & 0b100)) == 0 /* is-not SpecializationActive[GlobalScopeLookupNode.doUncached(JSDynamicObject, InlinedBranchProfile)] */) {
                while (true) {
                    int count1_ = 0;
                    CachedData s1_ = CACHED_CACHE_UPDATER.getVolatile(this);
                    CachedData s1_original = s1_;
                    while (s1_ != null) {
                        if ((arg0Value_.getShape() == s1_.cachedShape_) && Assumption.isValidAssumption(s1_.assumption0_)) {
                            break;
                        }
                        count1_++;
                        s1_ = s1_.next_;
                    }
                    if (s1_ == null) {
                        {
                            Shape cachedShape__ = (arg0Value_.getShape());
                            if ((arg0Value_.getShape() == cachedShape__)) {
                                Assumption assumption0 = (cachedShape__.getValidAssumption());
                                if (Assumption.isValidAssumption(assumption0)) {
                                    int cacheLimit__ = (getPropertyCacheLimit());
                                    if (count1_ < (cacheLimit__)) {
                                        s1_ = new CachedData(s1_original);
                                        Objects.requireNonNull(cachedShape__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                        s1_.cachedShape_ = cachedShape__;
                                        s1_.exists_ = (cachedShape__.hasProperty(varName));
                                        s1_.dead_ = (isDead(cachedShape__));
                                        s1_.constAssignment_ = (isConstAssignment(cachedShape__));
                                        s1_.cacheLimit_ = cacheLimit__;
                                        s1_.assumption0_ = assumption0;
                                        if (!CACHED_CACHE_UPDATER.compareAndSet(this, s1_original, s1_)) {
                                            continue;
                                        }
                                        this.absent_assumption_ = null;
                                        state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[GlobalScopeLookupNode.doAbsent(JSDynamicObject, Assumption)] */;
                                        state_0 = state_0 | 0b10 /* add SpecializationActive[GlobalScopeLookupNode.doCached(JSDynamicObject, Shape, boolean, boolean, boolean, int)] */;
                                        this.state_0_ = state_0;
                                    }
                                }
                            }
                        }
                    }
                    if (s1_ != null) {
                        return doCached(arg0Value_, s1_.cachedShape_, s1_.exists_, s1_.dead_, s1_.constAssignment_, s1_.cacheLimit_);
                    }
                    break;
                }
            }
            this.absent_assumption_ = null;
            this.cached_cache = null;
            state_0 = state_0 & 0xfffffffc /* remove SpecializationActive[GlobalScopeLookupNode.doAbsent(JSDynamicObject, Assumption)], SpecializationActive[GlobalScopeLookupNode.doCached(JSDynamicObject, Shape, boolean, boolean, boolean, int)] */;
            state_0 = state_0 | 0b100 /* add SpecializationActive[GlobalScopeLookupNode.doUncached(JSDynamicObject, InlinedBranchProfile)] */;
            this.state_0_ = state_0;
            return doUncached(arg0Value_, INLINED_UNCACHED_ERROR_BRANCH_);
        }
        throw new UnsupportedSpecializationException(this, null, arg0Value);
    }

    void removeAbsent_() {
        this.state_0_ = state_0_ & 0xfffffffe /* remove SpecializationActive[GlobalScopeLookupNode.doAbsent(JSDynamicObject, Assumption)] */;
    }

    void removeCached_(CachedData s1_) {
        while (true) {
            CachedData cur = this.cached_cache;
            CachedData original = cur;
            CachedData update = null;
            while (cur != null) {
                if (cur == s1_) {
                    if (cur == original) {
                        update = cur.next_;
                    } else {
                        update = original.remove(s1_);
                    }
                    break;
                }
                cur = cur.next_;
            }
            if (cur != null && !CACHED_CACHE_UPDATER.compareAndSet(this, original, update)) {
                continue;
            }
            break;
        }
    }

    @NeverDefault
    public static GlobalScopeLookupNode create(TruffleString varName, boolean write) {
        return new GlobalScopeLookupNodeGen(varName, write);
    }

    @GeneratedBy(GlobalScopeLookupNode.class)
    @DenyReplace
    private static final class CachedData implements SpecializationDataNode {

        @CompilationFinal final CachedData next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link GlobalScopeLookupNode#doCached}
         *   Parameter: {@link Shape} cachedShape</pre>
         */
        @CompilationFinal Shape cachedShape_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link GlobalScopeLookupNode#doCached}
         *   Parameter: boolean exists</pre>
         */
        @CompilationFinal boolean exists_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link GlobalScopeLookupNode#doCached}
         *   Parameter: boolean dead</pre>
         */
        @CompilationFinal boolean dead_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link GlobalScopeLookupNode#doCached}
         *   Parameter: boolean constAssignment</pre>
         */
        @CompilationFinal boolean constAssignment_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link GlobalScopeLookupNode#doCached}
         *   Parameter: int cacheLimit</pre>
         */
        @CompilationFinal int cacheLimit_;
        @CompilationFinal Assumption assumption0_;

        CachedData(CachedData next_) {
            this.next_ = next_;
        }

        CachedData remove(CachedData search) {
            CachedData newNext = this.next_;
            if (newNext != null) {
                if (search == newNext) {
                    newNext = newNext.next_;
                } else {
                    newNext = newNext.remove(search);
                }
            }
            CachedData copy = new CachedData(newNext);
            copy.cachedShape_ = this.cachedShape_;
            copy.exists_ = this.exists_;
            copy.dead_ = this.dead_;
            copy.constAssignment_ = this.constAssignment_;
            copy.cacheLimit_ = this.cacheLimit_;
            copy.assumption0_ = this.assumption0_;
            return copy;
        }

    }
}
