// CheckStyle: start generated
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.utilities.TriState;
import com.oracle.truffle.polyglot.PolyglotProxy;
import com.oracle.truffle.polyglot.PolyglotProxy.IsIdenticalOrUndefined;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.concurrent.locks.Lock;

@GeneratedBy(PolyglotProxy.class)
@SuppressWarnings("unused")
final class PolyglotProxyGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    static  {
        LibraryExport.register(PolyglotProxy.class, new InteropLibraryExports());
    }

    private PolyglotProxyGen() {
    }

    @GeneratedBy(PolyglotProxy.class)
    private static final class InteropLibraryExports extends LibraryExport<InteropLibrary> {

        private InteropLibraryExports() {
            super(InteropLibrary.class, PolyglotProxy.class, false);
        }

        @Override
        protected InteropLibrary createUncached(Object receiver) {
            assert receiver instanceof PolyglotProxy;
            InteropLibrary uncached = new Uncached();
            return uncached;
        }

        @Override
        protected InteropLibrary createCached(Object receiver) {
            assert receiver instanceof PolyglotProxy;
            return new Cached();
        }

        @GeneratedBy(PolyglotProxy.class)
        private static final class Cached extends InteropLibrary {

            @CompilationFinal private volatile int state_;
            @Child private InteropLibrary executables;

            Cached() {
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof PolyglotProxy) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof PolyglotProxy;
            }

            @Override
            protected TriState isIdenticalOrUndefined(Object arg0Value_, Object arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                int state = state_;
                if ((state & 0b11) != 0 /* is-active doHostObject(PolyglotProxy, PolyglotProxy) || doOther(PolyglotProxy, Object) */) {
                    if ((state & 0b1) != 0 /* is-active doHostObject(PolyglotProxy, PolyglotProxy) */ && arg1Value instanceof PolyglotProxy) {
                        PolyglotProxy arg1Value_ = (PolyglotProxy) arg1Value;
                        return IsIdenticalOrUndefined.doHostObject(arg0Value, arg1Value_);
                    }
                    if ((state & 0b10) != 0 /* is-active doOther(PolyglotProxy, Object) */) {
                        if (isIdenticalOrUndefinedFallbackGuard_(state, arg0Value, arg1Value)) {
                            return IsIdenticalOrUndefined.doOther(arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isIdenticalOrUndefinedAndSpecialize(arg0Value, arg1Value);
            }

            private TriState isIdenticalOrUndefinedAndSpecialize(PolyglotProxy arg0Value, Object arg1Value) {
                int state = state_;
                if (arg1Value instanceof PolyglotProxy) {
                    PolyglotProxy arg1Value_ = (PolyglotProxy) arg1Value;
                    this.state_ = state = state | 0b1 /* add-active doHostObject(PolyglotProxy, PolyglotProxy) */;
                    return IsIdenticalOrUndefined.doHostObject(arg0Value, arg1Value_);
                }
                this.state_ = state = state | 0b10 /* add-active doOther(PolyglotProxy, Object) */;
                return IsIdenticalOrUndefined.doOther(arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                int state = state_;
                if ((state & 0b11) == 0b0) {
                    return NodeCost.UNINITIALIZED;
                } else if (((state & 0b11) & ((state & 0b11) - 1)) == 0 /* is-single-active  */) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            @Override
            public boolean isInstantiable(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((PolyglotProxy) receiver)).isInstantiable();
            }

            @Override
            public Object instantiate(Object arg0Value_, Object... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                {
                    InteropLibrary instantiateNode__library__ = (this);
                    return arg0Value.instantiate(arg1Value, instantiateNode__library__);
                }
            }

            @Override
            public boolean isExecutable(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((PolyglotProxy) receiver)).isExecutable();
            }

            @Override
            public Object execute(Object arg0Value_, Object... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                {
                    InteropLibrary executeNode__library__ = (this);
                    return arg0Value.execute(arg1Value, executeNode__library__);
                }
            }

            @Override
            public boolean isPointer(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((PolyglotProxy) receiver)).isPointer();
            }

            @Override
            public long asPointer(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                {
                    InteropLibrary asPointerNode__library__ = (this);
                    return arg0Value.asPointer(asPointerNode__library__);
                }
            }

            @Override
            public boolean hasArrayElements(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((PolyglotProxy) receiver)).hasArrayElements();
            }

            @Override
            public Object readArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                {
                    InteropLibrary readArrayElementNode__library__ = (this);
                    return arg0Value.readArrayElement(arg1Value, readArrayElementNode__library__);
                }
            }

            @Override
            public void writeArrayElement(Object arg0Value_, long arg1Value, Object arg2Value) throws UnsupportedMessageException, UnsupportedTypeException, InvalidArrayIndexException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                {
                    InteropLibrary writeArrayElementNode__library__ = (this);
                    arg0Value.writeArrayElement(arg1Value, arg2Value, writeArrayElementNode__library__);
                    return;
                }
            }

            @Override
            public void removeArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                {
                    InteropLibrary removeArrayElementNode__library__ = (this);
                    arg0Value.removeArrayElement(arg1Value, removeArrayElementNode__library__);
                    return;
                }
            }

            @Override
            public long getArraySize(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                {
                    InteropLibrary getArraySizeNode__library__ = (this);
                    return arg0Value.getArraySize(getArraySizeNode__library__);
                }
            }

            @Override
            public boolean isArrayElementReadable(Object arg0Value_, long arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                {
                    InteropLibrary isArrayElementExistingNode__library__ = (this);
                    return arg0Value.isArrayElementExisting(arg1Value, isArrayElementExistingNode__library__);
                }
            }

            @Override
            public boolean isArrayElementModifiable(Object arg0Value_, long arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                {
                    InteropLibrary isArrayElementExistingNode__library__ = (this);
                    return arg0Value.isArrayElementExisting(arg1Value, isArrayElementExistingNode__library__);
                }
            }

            @Override
            public boolean isArrayElementRemovable(Object arg0Value_, long arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                {
                    InteropLibrary isArrayElementExistingNode__library__ = (this);
                    return arg0Value.isArrayElementExisting(arg1Value, isArrayElementExistingNode__library__);
                }
            }

            @Override
            public boolean isArrayElementInsertable(Object arg0Value_, long arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                {
                    InteropLibrary isArrayElementInsertableNode__library__ = (this);
                    return arg0Value.isArrayElementInsertable(arg1Value, isArrayElementInsertableNode__library__);
                }
            }

            @Override
            public boolean hasMembers(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((PolyglotProxy) receiver)).hasMembers();
            }

            @Override
            public Object getMembers(Object arg0Value_, boolean arg1Value) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                {
                    InteropLibrary getMembersNode__library__ = (this);
                    return arg0Value.getMembers(arg1Value, getMembersNode__library__);
                }
            }

            @Override
            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                {
                    InteropLibrary readMemberNode__library__ = (this);
                    return arg0Value.readMember(arg1Value, readMemberNode__library__);
                }
            }

            @Override
            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                {
                    InteropLibrary writeMemberNode__library__ = (this);
                    arg0Value.writeMember(arg1Value, arg2Value, writeMemberNode__library__);
                    return;
                }
            }

            @Override
            public Object invokeMember(Object arg0Value_, String arg1Value, Object... arg2Value) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                int state = state_;
                if ((state & 0b100) != 0 /* is-active invokeMember(PolyglotProxy, String, Object[], InteropLibrary, InteropLibrary) */) {
                    {
                        InteropLibrary invokeMemberNode__library__ = (this);
                        return arg0Value.invokeMember(arg1Value, arg2Value, invokeMemberNode__library__, this.executables);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return invokeMemberNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private Object invokeMemberNode_AndSpecialize(PolyglotProxy arg0Value, String arg1Value, Object[] arg2Value) throws UnsupportedMessageException, UnsupportedTypeException, ArityException, UnknownIdentifierException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    {
                        InteropLibrary invokeMemberNode__library__ = null;
                        invokeMemberNode__library__ = (this);
                        if (this.executables == null) {
                            this.executables = super.insert((INTEROP_LIBRARY_.createDispatched(PolyglotProxy.LIMIT)));
                        }
                        this.state_ = state = state | 0b100 /* add-active invokeMember(PolyglotProxy, String, Object[], InteropLibrary, InteropLibrary) */;
                        lock.unlock();
                        hasLock = false;
                        return arg0Value.invokeMember(arg1Value, arg2Value, invokeMemberNode__library__, this.executables);
                    }
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isMemberInvocable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                int state = state_;
                if ((state & 0b1000) != 0 /* is-active isMemberInvocable(PolyglotProxy, String, InteropLibrary, InteropLibrary) */) {
                    {
                        InteropLibrary isMemberInvocableNode__library__ = (this);
                        return arg0Value.isMemberInvocable(arg1Value, isMemberInvocableNode__library__, this.executables);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isMemberInvocableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberInvocableNode_AndSpecialize(PolyglotProxy arg0Value, String arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    {
                        InteropLibrary isMemberInvocableNode__library__ = null;
                        isMemberInvocableNode__library__ = (this);
                        if (this.executables == null) {
                            this.executables = super.insert((INTEROP_LIBRARY_.createDispatched(PolyglotProxy.LIMIT)));
                        }
                        this.state_ = state = state | 0b1000 /* add-active isMemberInvocable(PolyglotProxy, String, InteropLibrary, InteropLibrary) */;
                        lock.unlock();
                        hasLock = false;
                        return arg0Value.isMemberInvocable(arg1Value, isMemberInvocableNode__library__, this.executables);
                    }
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void removeMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                {
                    InteropLibrary removeMemberNode__library__ = (this);
                    arg0Value.removeMember(arg1Value, removeMemberNode__library__);
                    return;
                }
            }

            @Override
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                {
                    InteropLibrary isMemberExistingNode__library__ = (this);
                    return arg0Value.isMemberExisting(arg1Value, isMemberExistingNode__library__);
                }
            }

            @Override
            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                {
                    InteropLibrary isMemberExistingNode__library__ = (this);
                    return arg0Value.isMemberExisting(arg1Value, isMemberExistingNode__library__);
                }
            }

            @Override
            public boolean isMemberRemovable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                {
                    InteropLibrary isMemberExistingNode__library__ = (this);
                    return arg0Value.isMemberExisting(arg1Value, isMemberExistingNode__library__);
                }
            }

            @Override
            public boolean isMemberInsertable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                {
                    InteropLibrary isMemberInsertableNode__library__ = (this);
                    return arg0Value.isMemberInsertable(arg1Value, isMemberInsertableNode__library__);
                }
            }

            @Override
            public boolean isDate(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((PolyglotProxy) receiver)).isDate();
            }

            @Override
            public boolean isTime(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((PolyglotProxy) receiver)).isTime();
            }

            @Override
            public boolean isTimeZone(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((PolyglotProxy) receiver)).isTimeZone();
            }

            @Override
            public ZoneId asTimeZone(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                {
                    InteropLibrary asTimeZoneNode__library__ = (this);
                    return arg0Value.asTimeZone(asTimeZoneNode__library__);
                }
            }

            @Override
            public LocalDate asDate(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                {
                    InteropLibrary asDateNode__library__ = (this);
                    return arg0Value.asDate(asDateNode__library__);
                }
            }

            @Override
            public LocalTime asTime(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                {
                    InteropLibrary asTimeNode__library__ = (this);
                    return arg0Value.asTime(asTimeNode__library__);
                }
            }

            @Override
            public Instant asInstant(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                {
                    InteropLibrary asInstantNode__library__ = (this);
                    return arg0Value.asInstant(asInstantNode__library__);
                }
            }

            @Override
            public boolean isDuration(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((PolyglotProxy) receiver)).isDuration();
            }

            @Override
            public Duration asDuration(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                {
                    InteropLibrary asDurationNode__library__ = (this);
                    return arg0Value.asDuration(asDurationNode__library__);
                }
            }

            @Override
            public boolean hasLanguage(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((PolyglotProxy) receiver)).hasLanguage();
            }

            @Override
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((PolyglotProxy) receiver)).getLanguage();
            }

            @Override
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((PolyglotProxy) receiver)).toDisplayString(allowSideEffects);
            }

            @Override
            public boolean hasMetaObject(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((PolyglotProxy) receiver)).hasMetaObject();
            }

            @Override
            public Object getMetaObject(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((PolyglotProxy) receiver)).getMetaObject();
            }

            @Override
            public int identityHashCode(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return PolyglotProxy.identityHashCode((((PolyglotProxy) receiver)));
            }

            private static boolean isIdenticalOrUndefinedFallbackGuard_(int state, PolyglotProxy arg0Value, Object arg1Value) {
                if (((state & 0b1)) == 0 /* is-not-active doHostObject(PolyglotProxy, PolyglotProxy) */ && arg1Value instanceof PolyglotProxy) {
                    return false;
                }
                return true;
            }

        }
        @GeneratedBy(PolyglotProxy.class)
        private static final class Uncached extends InteropLibrary {

            Uncached() {
            }

            @TruffleBoundary
            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof PolyglotProxy) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof PolyglotProxy;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public TriState isIdenticalOrUndefined(Object arg0Value_, Object arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                if (arg1Value instanceof PolyglotProxy) {
                    PolyglotProxy arg1Value_ = (PolyglotProxy) arg1Value;
                    return IsIdenticalOrUndefined.doHostObject(arg0Value, arg1Value_);
                }
                return IsIdenticalOrUndefined.doOther(arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public boolean isInstantiable(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((PolyglotProxy) receiver) .isInstantiable();
            }

            @TruffleBoundary
            @Override
            public Object instantiate(Object arg0Value_, Object... arg1Value) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.instantiate(arg1Value, (this));
            }

            @TruffleBoundary
            @Override
            public boolean isExecutable(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((PolyglotProxy) receiver) .isExecutable();
            }

            @TruffleBoundary
            @Override
            public Object execute(Object arg0Value_, Object... arg1Value) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.execute(arg1Value, (this));
            }

            @TruffleBoundary
            @Override
            public boolean isPointer(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((PolyglotProxy) receiver) .isPointer();
            }

            @TruffleBoundary
            @Override
            public long asPointer(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.asPointer((this));
            }

            @TruffleBoundary
            @Override
            public boolean hasArrayElements(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((PolyglotProxy) receiver) .hasArrayElements();
            }

            @TruffleBoundary
            @Override
            public Object readArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.readArrayElement(arg1Value, (this));
            }

            @TruffleBoundary
            @Override
            public void writeArrayElement(Object arg0Value_, long arg1Value, Object arg2Value) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                arg0Value.writeArrayElement(arg1Value, arg2Value, (this));
                return;
            }

            @TruffleBoundary
            @Override
            public void removeArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                arg0Value.removeArrayElement(arg1Value, (this));
                return;
            }

            @TruffleBoundary
            @Override
            public long getArraySize(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.getArraySize((this));
            }

            @TruffleBoundary
            @Override
            public boolean isArrayElementReadable(Object arg0Value_, long arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.isArrayElementExisting(arg1Value, (this));
            }

            @TruffleBoundary
            @Override
            public boolean isArrayElementModifiable(Object arg0Value_, long arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.isArrayElementExisting(arg1Value, (this));
            }

            @TruffleBoundary
            @Override
            public boolean isArrayElementRemovable(Object arg0Value_, long arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.isArrayElementExisting(arg1Value, (this));
            }

            @TruffleBoundary
            @Override
            public boolean isArrayElementInsertable(Object arg0Value_, long arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.isArrayElementInsertable(arg1Value, (this));
            }

            @TruffleBoundary
            @Override
            public boolean hasMembers(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((PolyglotProxy) receiver) .hasMembers();
            }

            @TruffleBoundary
            @Override
            public Object getMembers(Object arg0Value_, boolean arg1Value) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.getMembers(arg1Value, (this));
            }

            @TruffleBoundary
            @Override
            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.readMember(arg1Value, (this));
            }

            @TruffleBoundary
            @Override
            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                arg0Value.writeMember(arg1Value, arg2Value, (this));
                return;
            }

            @TruffleBoundary
            @Override
            public Object invokeMember(Object arg0Value_, String arg1Value, Object... arg2Value) throws UnsupportedMessageException, UnsupportedTypeException, ArityException, UnknownIdentifierException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.invokeMember(arg1Value, arg2Value, (this), (INTEROP_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean isMemberInvocable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.isMemberInvocable(arg1Value, (this), (INTEROP_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public void removeMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                arg0Value.removeMember(arg1Value, (this));
                return;
            }

            @TruffleBoundary
            @Override
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.isMemberExisting(arg1Value, (this));
            }

            @TruffleBoundary
            @Override
            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.isMemberExisting(arg1Value, (this));
            }

            @TruffleBoundary
            @Override
            public boolean isMemberRemovable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.isMemberExisting(arg1Value, (this));
            }

            @TruffleBoundary
            @Override
            public boolean isMemberInsertable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.isMemberInsertable(arg1Value, (this));
            }

            @TruffleBoundary
            @Override
            public boolean isDate(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((PolyglotProxy) receiver) .isDate();
            }

            @TruffleBoundary
            @Override
            public boolean isTime(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((PolyglotProxy) receiver) .isTime();
            }

            @TruffleBoundary
            @Override
            public boolean isTimeZone(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((PolyglotProxy) receiver) .isTimeZone();
            }

            @TruffleBoundary
            @Override
            public ZoneId asTimeZone(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.asTimeZone((this));
            }

            @TruffleBoundary
            @Override
            public LocalDate asDate(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.asDate((this));
            }

            @TruffleBoundary
            @Override
            public LocalTime asTime(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.asTime((this));
            }

            @TruffleBoundary
            @Override
            public Instant asInstant(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.asInstant((this));
            }

            @TruffleBoundary
            @Override
            public boolean isDuration(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((PolyglotProxy) receiver) .isDuration();
            }

            @TruffleBoundary
            @Override
            public Duration asDuration(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                PolyglotProxy arg0Value = ((PolyglotProxy) arg0Value_);
                return arg0Value.asDuration((this));
            }

            @TruffleBoundary
            @Override
            public boolean hasLanguage(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((PolyglotProxy) receiver) .hasLanguage();
            }

            @TruffleBoundary
            @Override
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((PolyglotProxy) receiver) .getLanguage();
            }

            @TruffleBoundary
            @Override
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((PolyglotProxy) receiver) .toDisplayString(allowSideEffects);
            }

            @TruffleBoundary
            @Override
            public boolean hasMetaObject(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((PolyglotProxy) receiver) .hasMetaObject();
            }

            @TruffleBoundary
            @Override
            public Object getMetaObject(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((PolyglotProxy) receiver) .getMetaObject();
            }

            @TruffleBoundary
            @Override
            public int identityHashCode(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return PolyglotProxy.identityHashCode(((PolyglotProxy) receiver) );
            }

        }
    }
}
